/*
 * Copyright (c) 2009 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.app.views;

import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.Viewer;

public class LocalSelectionWrapper implements ISelection {

	private final Viewer sourceViewer;

	private final ISelection selection;


	public LocalSelectionWrapper(Viewer sourceViewer) {
		this.sourceViewer = sourceViewer;
		this.selection = sourceViewer.getSelection();
	}

	public boolean isEmpty() {
		return selection.isEmpty();
	}

	public Viewer getSourceViewer() {
		return sourceViewer;
	}

	public ISelection getSelection() {
		return selection;
	}

	public static <T extends ISelection> T getSelection(LocalSelectionTransfer transfer, Viewer sourceViewer) {
		ISelection selection = transfer.getSelection();
		if (!(selection instanceof LocalSelectionWrapper)) {
			return null;
		}

		LocalSelectionWrapper wrapper = (LocalSelectionWrapper) selection;
		if (sourceViewer != null && sourceViewer != wrapper.getSourceViewer()) {
			return null;
		}

		@SuppressWarnings("unchecked")
		T actualSelection = (T) wrapper.getSelection();
		return actualSelection;
	}

	public static <T extends ISelection> T getSelection(LocalSelectionTransfer transfer) {
		return getSelection(transfer, null);
	}

}
