/*
 * Copyright (c) 2010 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.app.project;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

import ch.kuramo.javie.app.PropertyUtil;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.Project;

public class ModifyLayerPropertyOperation<T> extends ProjectOperation {

	private final String compId;

	private final String layerId;

	private final String property;

	private final T oldValue;

	private final T newValue;


	public ModifyLayerPropertyOperation(
			ProjectManager pm, Layer layer, String property, T newValue, String label) {

		super(pm, label);

		LayerComposition comp = pm.checkLayer(layer);
		this.compId = comp.getId();
		this.layerId = layer.getId();
		this.property = property;
		this.oldValue = PropertyUtil.getProperty(layer, property);
		this.newValue = newValue;

		_noEffect = (newValue == oldValue) || (newValue != null && newValue.equals(oldValue));
	}

	@Override
	protected IStatus executeOrRedo(IProgressMonitor monitor, IAdaptable info,
			Project project, ProjectManager pm) throws ExecutionException {

		modifyProperty(newValue, project, pm);
		return Status.OK_STATUS;
	}

	@Override
	protected IStatus undo(IProgressMonitor monitor, IAdaptable info,
			Project project, ProjectManager pm) throws ExecutionException {

		modifyProperty(oldValue, project, pm);
		return Status.OK_STATUS;
	}

	private void modifyProperty(T value, Project project, ProjectManager pm) {
		LayerComposition comp = project.getComposition(compId);
		Layer layer = comp.getLayer(layerId);

		PropertyUtil.setProperty(layer, property, value);

		if (pm != null) {
			pm.fireLayerPropertyChange(layer, property);
		}
	}

}
