/*
 * Copyright (c) 2011 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.app;

import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.LoaderClassPath;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Shell;

import ch.kuramo.javie.core.JavieRuntimeException;

public class Java6Update26Detection {

	public static void patch() {
		String platform = SWT.getPlatform();
		if (!platform.equals("win32")) {
			return;
		}

		String javaVersion = System.getProperty("java.version");
		if (javaVersion == null) return;

		String[] javaVersions = javaVersion.split("[._]", 4);
		if (javaVersions.length != 4) return; 

		int[] num = new int[4];
		try {
			for (int i = 0; i < 4; ++i) {
				num[i] = Integer.parseInt(javaVersions[i]);
			}
		} catch (NumberFormatException e) {
			e.printStackTrace();
			return;
		}

		do {
			if (num[0] < 1) return;
			if (num[0] > 1) break;
			if (num[1] < 6) return;
			if (num[1] > 6) break;
			if (num[2] < 0) return;
			if (num[2] > 0) break;
			if (num[3] < 26) return;
			if (num[3] > 26) break;
		} while (false);

		try {
			ClassLoader loader = SWT.class.getClassLoader();

			ClassPool pool = new ClassPool();
			pool.appendClassPath(new LoaderClassPath(loader));

			CtClass targetClass = pool.get("org.eclipse.swt.widgets.FileDialog");

			targetClass.addField(CtField.make("public static Class alertClass;", targetClass), "null");
			targetClass.addField(CtField.make("private static int failedCount;", targetClass), "0");

			CtMethod openMethod = targetClass.getDeclaredMethod("open");
			openMethod.setName("open_orig");

			String newOpenSrc = 
				"public String open() {" +
				"	long t1 = System.currentTimeMillis();" +
				"	String result = open_orig();" +
				"	long t2 = System.currentTimeMillis();" +
				"	if (result != null || t2 - t1 > 5000) {" +
				"		failedCount = 0x80000000;" +
				"	} else if (t2 - t1 < 500 && ++failedCount >=2 && alertClass != null) {" +
				"		alertClass.getMethod(\"alert\", new Class[]{ org.eclipse.swt.widgets.Shell.class })" +
				"				.invoke(null, new Object[]{ parent });" +
				"	}" +
				"	return result;" +
				"}";
			targetClass.addMethod(CtMethod.make(newOpenSrc, targetClass));

			Class<?> clazz = targetClass.toClass(loader, null);
			clazz.getField("alertClass").set(null, Java6Update26Detection.class);

		} catch (Exception e) {
			throw new JavieRuntimeException(e);
		}
	}

	public static void alert(Shell parent) {
		MessageDialog.openError(parent, "Java 6 Update 26 の不具合を検出しました",
				"ご利用中のOSとJavaの組み合わせでは、Javieは正常に動作しません。Java 6 Update 25 を利用してください。");
	}

}
