/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.nio;

import com.jogamp.common.nio.AbstractBuffer;
import com.jogamp.common.os.NativeLibrary;
import java.nio.ByteBuffer;
import java.util.HashMap;

public abstract class AbstractLongBuffer
extends AbstractBuffer {
    protected long[] backup;
    protected HashMap dataMap = new HashMap();

    protected AbstractLongBuffer(ByteBuffer bb, int elementSize) {
        super(bb, elementSize);
        this.backup = new long[this.capacity];
    }

    final void updateBackup() {
        for (int i = 0; i < this.capacity; ++i) {
            this.backup[i] = this.get(i);
        }
    }

    public final boolean hasArray() {
        return true;
    }

    public final long[] array() {
        return this.backup;
    }

    public abstract long get(int var1);

    public final long get() {
        long r = this.get(this.position);
        ++this.position;
        return r;
    }

    public final AbstractLongBuffer get(long[] dest, int offset, int length) {
        if (dest.length < offset + length) {
            throw new IndexOutOfBoundsException();
        }
        if (this.remaining() < length) {
            throw new IndexOutOfBoundsException();
        }
        while (length > 0) {
            dest[offset++] = this.get(this.position++);
            --length;
        }
        return this;
    }

    public abstract AbstractLongBuffer put(int var1, long var2);

    public final AbstractLongBuffer put(long value) {
        this.put(this.position, value);
        ++this.position;
        return this;
    }

    public final AbstractLongBuffer put(long[] src, int offset, int length) {
        if (src.length < offset + length) {
            throw new IndexOutOfBoundsException();
        }
        if (this.remaining() < length) {
            throw new IndexOutOfBoundsException();
        }
        while (length > 0) {
            this.put(this.position++, src[offset++]);
            --length;
        }
        return this;
    }

    public AbstractLongBuffer put(AbstractLongBuffer src) {
        if (this.remaining() < src.remaining()) {
            throw new IndexOutOfBoundsException();
        }
        while (src.hasRemaining()) {
            this.put(src.get());
        }
        return this;
    }

    static {
        NativeLibrary.ensureNativeLibLoaded();
    }
}

