/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.impl;

import com.jogamp.common.util.IntIntHashMap;
import com.jogamp.opengl.impl.Debug;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import javax.media.opengl.GLException;

public class GLStateTracker {
    private static final boolean DEBUG = Debug.debug("GLStateTracker");
    private volatile boolean enabled = true;
    private IntIntHashMap pixelStateMap;
    private List stack = new ArrayList();

    public GLStateTracker() {
        this.pixelStateMap = new IntIntHashMap();
        this.pixelStateMap.setKeyNotFoundValue(-1);
        this.resetStates();
    }

    public void clearStates(boolean bl) {
        this.enabled = bl;
        this.pixelStateMap.clear();
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean getInt(int n, int[] nArray, int n2) {
        int n3;
        if (this.enabled && 0 <= (n3 = this.pixelStateMap.get(n))) {
            nArray[n2] = n3;
            return true;
        }
        return false;
    }

    public boolean getInt(int n, IntBuffer intBuffer, int n2) {
        int n3;
        if (this.enabled && 0 <= (n3 = this.pixelStateMap.get(n))) {
            intBuffer.put(intBuffer.position(), n3);
            return true;
        }
        return false;
    }

    public void setInt(int n, int n2) {
        if (this.enabled) {
            this.pixelStateMap.put(n, n2);
        }
    }

    public void pushAttrib(int n) {
        if (this.enabled) {
            SavedState savedState = new SavedState();
            if (0 != (n & 1)) {
                savedState.putPixelStateMap(this.pixelStateMap);
            }
            this.stack.add(0, savedState);
        }
    }

    public void popAttrib() {
        if (this.enabled) {
            if (this.stack.size() == 0) {
                throw new GLException("stack contains no elements");
            }
            SavedState savedState = (SavedState)this.stack.remove(0);
            if (null == savedState) {
                throw new GLException("null stack element (remaining stack size " + this.stack.size() + ")");
            }
            IntIntHashMap intIntHashMap = new IntIntHashMap();
            intIntHashMap.setKeyNotFoundValue(-1);
            if (null != savedState.getPixelStateMap()) {
                intIntHashMap.putAll(savedState.getPixelStateMap());
            }
            this.pixelStateMap = intIntHashMap;
        }
    }

    public void resetStates() {
        this.pixelStateMap.clear();
        this.pixelStateMap.put(3333, 4);
        this.pixelStateMap.put(3328, 0);
        this.pixelStateMap.put(3329, 0);
        this.pixelStateMap.put(3330, 0);
        this.pixelStateMap.put(3331, 0);
        this.pixelStateMap.put(3332, 0);
        this.pixelStateMap.put(32876, 0);
        this.pixelStateMap.put(32875, 0);
        this.pixelStateMap.put(3317, 4);
        this.pixelStateMap.put(3312, 0);
        this.pixelStateMap.put(3313, 0);
        this.pixelStateMap.put(3314, 0);
        this.pixelStateMap.put(3315, 0);
        this.pixelStateMap.put(3316, 0);
        this.pixelStateMap.put(32878, 0);
        this.pixelStateMap.put(32877, 0);
    }

    static class SavedState {
        private IntIntHashMap pixelStateMap = null;

        SavedState() {
        }

        void putPixelStateMap(IntIntHashMap intIntHashMap) {
            this.pixelStateMap = new IntIntHashMap();
            this.pixelStateMap.setKeyNotFoundValue(-1);
            this.pixelStateMap.putAll(intIntHashMap);
        }

        IntIntHashMap getPixelStateMap() {
            return this.pixelStateMap;
        }
    }
}

