/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.ui;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.metadata.repository.MetadataRepositoryManager;
import org.eclipse.equinox.internal.p2.ui.ProvUIActivator;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.CompoundQueryable;
import org.eclipse.equinox.internal.provisional.p2.query.IQueryable;
import org.eclipse.equinox.internal.provisional.p2.query.Query;
import org.eclipse.equinox.internal.provisional.p2.repository.IRepository;
import org.eclipse.equinox.internal.provisional.p2.repository.IRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.ui.QueryableRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.ui.RepositoryLocationQuery;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.ProvisioningUtil;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.IUViewQueryContext;
import org.osgi.framework.BundleContext;

public class QueryableMetadataRepositoryManager
extends QueryableRepositoryManager {
    static /* synthetic */ Class class$0;

    public QueryableMetadataRepositoryManager(IUViewQueryContext queryContext, boolean includeDisabledRepos) {
        super(queryContext, includeDisabledRepos);
    }

    protected IRepository getRepository(IRepositoryManager manager, URI location) {
        if (manager instanceof MetadataRepositoryManager) {
            return ((MetadataRepositoryManager)manager).getRepository(location);
        }
        return super.getRepository(manager, location);
    }

    protected IRepositoryManager getRepositoryManager() {
        BundleContext bundleContext = ProvUIActivator.getContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (IMetadataRepositoryManager)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName());
    }

    protected IRepository doLoadRepository(IRepositoryManager manager, URI location, IProgressMonitor monitor) throws ProvisionException {
        if (manager instanceof IMetadataRepositoryManager) {
            return ProvisioningUtil.loadMetadataRepository(location, monitor);
        }
        return null;
    }

    protected Collector query(URI[] uris, Query query, Collector collector, IProgressMonitor monitor) {
        if (query instanceof RepositoryLocationQuery) {
            query.perform(Arrays.asList(uris).iterator(), collector);
            monitor.done();
        } else {
            SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)((uris.length + 1) * 100));
            ArrayList<IRepository> loadedRepos = new ArrayList<IRepository>(uris.length);
            int i = 0;
            while (i < uris.length) {
                IRepository repo = null;
                try {
                    repo = this.loadRepository(this.getRepositoryManager(), uris[i], (IProgressMonitor)sub.newChild(100));
                }
                catch (ProvisionException e) {
                    this.handleLoadFailure(e, uris[i]);
                }
                catch (OperationCanceledException operationCanceledException) {
                    repo = null;
                }
                if (repo != null) {
                    loadedRepos.add(repo);
                }
                ++i;
            }
            if (loadedRepos.size() > 0) {
                IQueryable[] queryables = loadedRepos.toArray(new IQueryable[loadedRepos.size()]);
                collector = new CompoundQueryable(queryables).query(query, collector, (IProgressMonitor)sub.newChild(100));
            }
        }
        return collector;
    }

    protected URI[] getRepoLocations(IRepositoryManager manager) {
        HashSet<URI> locations = new HashSet<URI>();
        int flags = this.queryContext.getMetadataRepositoryFlags();
        locations.addAll(Arrays.asList(manager.getKnownRepositories(flags)));
        if (this.includeDisabledRepos) {
            locations.addAll(Arrays.asList(manager.getKnownRepositories(8 | flags)));
        }
        return locations.toArray(new URI[locations.size()]);
    }
}

