/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util;

import java.util.Arrays;
import java.util.Iterator;

public class LongLongHashMap
implements Iterable {
    private final float loadFactor;
    private Entry[] table;
    private int size;
    private int mask;
    private int capacity;
    private int threshold;
    private long keyNotFoundValue = -1L;

    public LongLongHashMap() {
        this(16, 0.75f);
    }

    public LongLongHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public LongLongHashMap(int initialCapacity, float loadFactor) {
        if (initialCapacity > 0x40000000) {
            throw new IllegalArgumentException("initialCapacity is too large.");
        }
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initialCapacity must be greater than zero.");
        }
        if (loadFactor <= 0.0f) {
            throw new IllegalArgumentException("loadFactor must be greater than zero.");
        }
        this.capacity = 1;
        while (this.capacity < initialCapacity) {
            this.capacity <<= 1;
        }
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)this.capacity * loadFactor);
        this.table = new Entry[this.capacity];
        this.mask = this.capacity - 1;
    }

    public boolean containsValue(long value) {
        Entry[] t = this.table;
        int i = t.length;
        while (i-- > 0) {
            Entry e = t[i];
            while (e != null) {
                if (e.value == value) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    public boolean containsKey(long key) {
        Entry[] t = this.table;
        int index = (int)(key & (long)this.mask);
        Entry e = t[index];
        while (e != null) {
            if (e.key == key) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public long get(long key) {
        Entry[] t = this.table;
        int index = (int)(key & (long)this.mask);
        Entry e = t[index];
        while (e != null) {
            if (e.key == key) {
                return e.value;
            }
            e = e.next;
        }
        return this.keyNotFoundValue;
    }

    public long put(long key, long value) {
        Entry[] t = this.table;
        int index = (int)(key & (long)this.mask);
        Entry e = t[index];
        while (e != null) {
            if (e.key == key) {
                long oldValue = e.value;
                e.value = value;
                return oldValue;
            }
            e = e.next;
        }
        t[index] = new Entry(key, value, t[index]);
        if (this.size++ >= this.threshold) {
            int newCapacity = 2 * this.capacity;
            Entry[] newTable = new Entry[newCapacity];
            long bucketmask = newCapacity - 1;
            for (int j = 0; j < t.length; ++j) {
                Entry next;
                Entry e2 = t[j];
                if (e2 == null) continue;
                t[j] = null;
                do {
                    next = e2.next;
                    index = (int)(e2.key & bucketmask);
                    e2.next = newTable[index];
                    newTable[index] = e2;
                } while ((e2 = next) != null);
            }
            this.table = newTable;
            this.capacity = newCapacity;
            this.threshold = (int)((float)newCapacity * this.loadFactor);
            this.mask = this.capacity - 1;
        }
        return this.keyNotFoundValue;
    }

    public void putAll(LongLongHashMap source) {
        Iterator itr = source.iterator();
        while (itr.hasNext()) {
            Entry e = (Entry)itr.next();
            this.put(e.key, e.value);
        }
    }

    public long remove(long key) {
        Entry prev;
        Entry[] t = this.table;
        int index = (int)(key & (long)this.mask);
        Entry e = prev = t[index];
        while (e != null) {
            Entry next = e.next;
            if (e.key == key) {
                --this.size;
                if (prev == e) {
                    t[index] = next;
                } else {
                    prev.next = next;
                }
                return e.value;
            }
            prev = e;
            e = next;
        }
        return this.keyNotFoundValue;
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        Arrays.fill(this.table, null);
        this.size = 0;
    }

    public Iterator iterator() {
        return new EntryIterator(this.table);
    }

    public long setKeyNotFoundValue(long newKeyNotFoundValue) {
        long t = this.keyNotFoundValue;
        this.keyNotFoundValue = newKeyNotFoundValue;
        return t;
    }

    public long getKeyNotFoundValue() {
        return this.keyNotFoundValue;
    }

    public String toString() {
        String str = "{";
        Iterator itr = this.iterator();
        while (itr.hasNext()) {
            str = str + itr.next();
            if (!itr.hasNext()) continue;
            str = str + ", ";
        }
        str = str + "}";
        return str;
    }

    public static final class Entry {
        public final long key;
        public long value;
        private Entry next;

        private Entry(long k, long v, Entry n) {
            this.key = k;
            this.value = v;
            this.next = n;
        }

        public long getKey() {
            return this.key;
        }

        public long getValue() {
            return this.value;
        }

        public void setValue(long value) {
            this.value = value;
        }

        public String toString() {
            return "[" + this.key + ":" + this.value + "]";
        }
    }

    private static final class EntryIterator
    implements Iterator {
        private final Entry[] entries;
        private int index;
        private Entry next;

        private EntryIterator(Entry[] entries) {
            this.entries = entries;
            this.next();
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public Object next() {
            Entry current = this.next;
            if (current != null && current.next != null) {
                this.next = current.next;
            } else {
                while (this.index < this.entries.length) {
                    Entry e;
                    if ((e = this.entries[this.index++]) == null) continue;
                    this.next = e;
                    return current;
                }
                this.next = null;
            }
            return current;
        }

        public void remove() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

