/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal.services;

import ch.kuramo.javie.api.ColorMode;
import ch.kuramo.javie.api.IShaderProgram;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.services.IArrayPools;
import ch.kuramo.javie.api.services.IVideoRenderSupport;
import ch.kuramo.javie.core.internal.VideoBufferImpl;
import ch.kuramo.javie.core.services.GLGlobal;
import ch.kuramo.javie.core.services.RenderContext;
import com.google.inject.Inject;
import java.util.Collection;
import javax.media.opengl.GL2;
import javax.media.opengl.GLUniformData;
import javax.media.opengl.glu.GLU;
import javax.media.opengl.glu.GLUtessellator;
import javax.media.opengl.glu.GLUtessellatorCallback;
import javax.media.opengl.glu.GLUtessellatorCallbackAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VideoRenderSupportImpl
implements IVideoRenderSupport {
    private static final Logger _logger = LoggerFactory.getLogger(VideoRenderSupportImpl.class);
    private final RenderContext context;
    private final IArrayPools arrayPools;
    private final GLGlobal glGlobal;

    @Inject
    public VideoRenderSupportImpl(RenderContext context, IArrayPools arrayPools, GLGlobal glGlobal) {
        this.context = context;
        this.arrayPools = arrayPools;
        this.glGlobal = glGlobal;
    }

    public IVideoBuffer createVideoBuffer(VideoBounds bounds) {
        return this.createVideoBuffer(bounds, this.context.getColorMode());
    }

    public IVideoBuffer createVideoBuffer(VideoBounds bounds, ColorMode colorMode) {
        return new VideoBufferImpl(colorMode, bounds, this.context, this, this.arrayPools, this.glGlobal);
    }

    private int limitMaxTextureImageUnits(int n) {
        int max = this.glGlobal.getMaxTextureImageUnits();
        if (n > max) {
            _logger.warn(String.format("number of texture (%d) exceeds GL_MAX_TEXTURE_IMAGE_UNITS (%d)", n, max));
            n = max;
        }
        return n;
    }

    /*
     * Unable to fully structure code
     */
    private void useFramebufferMRT(Runnable operation, int pushAttribs, boolean enableTexture, IVideoBuffer[] output, IVideoBuffer ... input) {
        gl = this.context.getGL().getGL2();
        fb = new int[1];
        gl.glGetFramebufferAttachmentParameteriv(36160, 36064, 36049, fb, 0);
        if (fb[0] != 0) {
            throw new IllegalStateException("framebuffer is in use");
        }
        gl.glPushAttrib(pushAttribs | 262144 | (enableTexture != false ? 8192 : 0));
        try {
            drawBuffers = new int[output.length];
            i = 0;
            while (i < output.length) {
                drawBuffers[i] = 36064 + i;
                gl.glFramebufferTexture2D(36160, drawBuffers[i], 3553, output[i].getTexture(), 0);
                ++i;
            }
            gl.glDrawBuffers(drawBuffers.length, drawBuffers, 0);
            i = 0;
            n = this.limitMaxTextureImageUnits(input.length);
            while (i < n) {
                gl.glActiveTexture(33984 + i);
                gl.glBindTexture(3553, input[i].getTexture());
                if (enableTexture) {
                    gl.glEnable(3553);
                }
                ++i;
            }
            operation.run();
        }
        finally {
            i = 0;
            ** while (i < output.length)
        }
lbl-1000:
        // 1 sources

        {
            gl.glFramebufferTexture2D(36160, 36064 + i, 3553, 0, 0);
            ++i;
            continue;
        }
lbl33:
        // 1 sources

        gl.glPopAttrib();
    }

    private void useFramebuffer(Runnable operation, int pushAttribs, boolean enableTexture, IVideoBuffer output, IVideoBuffer ... input) {
        this.useFramebufferMRT(operation, pushAttribs, enableTexture, new IVideoBuffer[]{output}, input);
    }

    public IVideoBuffer useFramebuffer(Runnable operation, int pushAttribs, IVideoBuffer output, IVideoBuffer ... input) {
        IVideoBuffer buffer = null;
        if (output == null) {
            if (input.length == 0) {
                throw new IllegalArgumentException("when output is null, at least one input must be specified.");
            }
            buffer = output = this.createVideoBuffer(input[0].getBounds());
        }
        try {
            this.useFramebuffer(operation, pushAttribs, true, output, input);
            buffer = null;
            IVideoBuffer iVideoBuffer = output;
            return iVideoBuffer;
        }
        finally {
            if (buffer != null) {
                buffer.dispose();
            }
        }
    }

    public IVideoBuffer useShaderProgram(IShaderProgram program, Collection<GLUniformData> uniforms, Runnable operation, int pushAttribs, IVideoBuffer output, IVideoBuffer ... input) {
        IVideoBuffer buffer = null;
        if (output == null) {
            if (input.length == 0) {
                throw new IllegalArgumentException("when output is null, at least one input must be specified.");
            }
            buffer = output = this.createVideoBuffer(input[0].getBounds());
        }
        try {
            this.useShaderProgramMRT(program, uniforms, operation, pushAttribs, new IVideoBuffer[]{output}, input);
            buffer = null;
            IVideoBuffer iVideoBuffer = output;
            return iVideoBuffer;
        }
        finally {
            if (buffer != null) {
                buffer.dispose();
            }
        }
    }

    public void useShaderProgramMRT(final IShaderProgram program, final Collection<GLUniformData> uniforms, final Runnable operation, int pushAttribs, IVideoBuffer[] output, IVideoBuffer ... input) {
        Runnable useProgram = new Runnable(){

            public void run() {
                program.useProgram(new Runnable(){

                    public void run() {
                        GL2 gl = VideoRenderSupportImpl.this.context.getGL().getGL2();
                        for (GLUniformData data : uniforms) {
                            data.setLocation(program.getUniformLocation(data.getName()));
                            gl.glUniform(data);
                        }
                        operation.run();
                    }
                });
            }
        };
        this.useFramebufferMRT(useProgram, pushAttribs, false, output, input);
    }

    public IVideoBuffer useShaderProgram(IShaderProgram program, Collection<GLUniformData> uniforms, IVideoBuffer output, IVideoBuffer ... input) {
        IVideoBuffer buffer = null;
        if (output == null) {
            if (input.length == 0) {
                throw new IllegalArgumentException("when output is null, at least one input must be specified.");
            }
            buffer = output = this.createVideoBuffer(input[0].getBounds());
        }
        try {
            this.useShaderProgramMRT(program, uniforms, new IVideoBuffer[]{output}, input);
            buffer = null;
            IVideoBuffer iVideoBuffer = output;
            return iVideoBuffer;
        }
        finally {
            if (buffer != null) {
                buffer.dispose();
            }
        }
    }

    public void useShaderProgramMRT(IShaderProgram program, Collection<GLUniformData> uniforms, final IVideoBuffer[] output, final IVideoBuffer ... input) {
        Runnable operation = new Runnable(){

            public void run() {
                VideoRenderSupportImpl.this.ortho2D(output[0]);
                VideoRenderSupportImpl.this.quad2D(output[0], input);
            }
        };
        this.useShaderProgramMRT(program, uniforms, operation, 0, output, input);
    }

    private void ortho2D(double left, double top, int width, int height) {
        GL2 gl = this.context.getGL().getGL2();
        GLU glu = this.context.getGLU();
        gl.glViewport(0, 0, width, height);
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        glu.gluOrtho2D(left, left + (double)width, top, top + (double)height);
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
    }

    public void ortho2D(IVideoBuffer output) {
        this.ortho2D(output.getBounds());
    }

    public void ortho2D(VideoBounds bounds) {
        this.ortho2D(bounds.x, bounds.y, bounds.width, bounds.height);
    }

    private double[][][] toTexCoords(IVideoBuffer output, IVideoBuffer ... input) {
        VideoBounds outputBounds = output.getBounds();
        double x = outputBounds.x;
        double y = outputBounds.y;
        int w = outputBounds.width;
        int h = outputBounds.height;
        int n = input.length;
        double[][][] texCoords = new double[n][][];
        int i = 0;
        while (i < n) {
            VideoBounds inputBounds = input[i].getBounds();
            double dx = x - inputBounds.x;
            double dy = y - inputBounds.y;
            double iw = inputBounds.width;
            double ih = inputBounds.height;
            texCoords[i] = new double[][]{{dx / iw, dy / ih}, {(dx + (double)w) / iw, dy / ih}, {(dx + (double)w) / iw, (dy + (double)h) / ih}, {dx / iw, (dy + (double)h) / ih}};
            ++i;
        }
        return texCoords;
    }

    public void quad2D(IVideoBuffer output, IVideoBuffer ... input) {
        this.quad2D(output.getBounds(), this.toTexCoords(output, input));
    }

    public void quad2D(VideoBounds bounds, double[][] ... texCoords) {
        double left = bounds.x;
        double top = bounds.y;
        double right = left + (double)bounds.width;
        double bottom = top + (double)bounds.height;
        this.quad2D(left, top, right, bottom, texCoords);
    }

    public void quad2D(double left, double top, double right, double bottom, double[][] ... texCoords) {
        int n = texCoords.length;
        GL2 gl = this.context.getGL().getGL2();
        gl.glBegin(7);
        int i = 0;
        while (i < n) {
            gl.glMultiTexCoord2f(33984 + i, (float)texCoords[i][0][0], (float)texCoords[i][0][1]);
            ++i;
        }
        gl.glVertex2f((float)left, (float)top);
        i = 0;
        while (i < n) {
            gl.glMultiTexCoord2f(33984 + i, (float)texCoords[i][1][0], (float)texCoords[i][1][1]);
            ++i;
        }
        gl.glVertex2f((float)right, (float)top);
        i = 0;
        while (i < n) {
            gl.glMultiTexCoord2f(33984 + i, (float)texCoords[i][2][0], (float)texCoords[i][2][1]);
            ++i;
        }
        gl.glVertex2f((float)right, (float)bottom);
        i = 0;
        while (i < n) {
            gl.glMultiTexCoord2f(33984 + i, (float)texCoords[i][3][0], (float)texCoords[i][3][1]);
            ++i;
        }
        gl.glVertex2f((float)left, (float)bottom);
        gl.glEnd();
    }

    public void polygon2D(double[][][] contours, IVideoBuffer output, IVideoBuffer ... input) {
        this.polygon2D(contours, output.getBounds(), this.toTexCoords(output, input));
    }

    public void polygon2D(double[][][] contours, final VideoBounds bounds, final double[][] ... texCoords) {
        GLUtessellatorCallbackAdapter callback = new GLUtessellatorCallbackAdapter(){
            final GL2 gl;
            {
                this.gl = VideoRenderSupportImpl.this.context.getGL().getGL2();
            }

            public void begin(int type) {
                this.gl.glBegin(type);
            }

            public void end() {
                this.gl.glEnd();
            }

            public void vertex(Object vertexData) {
                double[] vertex = (double[])vertexData;
                double px = (vertex[0] - bounds.x) / (double)bounds.width;
                double py = (vertex[1] - bounds.y) / (double)bounds.height;
                int i = 0;
                int n = texCoords.length;
                while (i < n) {
                    double x1 = texCoords[i][0][0] * (1.0 - px) + texCoords[i][1][0] * px;
                    double x2 = texCoords[i][3][0] * (1.0 - px) + texCoords[i][2][0] * px;
                    double x = x1 * (1.0 - py) + x2 * py;
                    double y1 = texCoords[i][0][1] * (1.0 - py) + texCoords[i][3][1] * py;
                    double y2 = texCoords[i][1][1] * (1.0 - py) + texCoords[i][2][1] * py;
                    double y = y1 * (1.0 - px) + y2 * px;
                    this.gl.glMultiTexCoord2f(33984 + i, (float)x, (float)y);
                    ++i;
                }
                this.gl.glVertex2f((float)vertex[0], (float)vertex[1]);
            }

            public void combine(double[] coords, Object[] data, float[] weight, Object[] outData) {
                outData[0] = new double[]{coords[0], coords[1], coords[2]};
            }

            public void error(int errnum) {
                System.err.println("Tessellation Error: " + VideoRenderSupportImpl.this.context.getGLU().gluErrorString(errnum));
            }
        };
        GLUtessellator tess = GLU.gluNewTess();
        try {
            GLU.gluTessCallback((GLUtessellator)tess, (int)100100, (GLUtessellatorCallback)callback);
            GLU.gluTessCallback((GLUtessellator)tess, (int)100102, (GLUtessellatorCallback)callback);
            GLU.gluTessCallback((GLUtessellator)tess, (int)100101, (GLUtessellatorCallback)callback);
            GLU.gluTessCallback((GLUtessellator)tess, (int)100105, (GLUtessellatorCallback)callback);
            GLU.gluTessCallback((GLUtessellator)tess, (int)100103, (GLUtessellatorCallback)callback);
            GLU.gluTessBeginPolygon((GLUtessellator)tess, null);
            double[][][] dArray = contours;
            int n = contours.length;
            int n2 = 0;
            while (n2 < n) {
                double[][] points = dArray[n2];
                GLU.gluTessBeginContour((GLUtessellator)tess);
                double[][] dArray2 = points;
                int n3 = points.length;
                int n4 = 0;
                while (n4 < n3) {
                    double[] pt = dArray2[n4];
                    double[] vertex = new double[]{pt[0], pt[1], 0.0};
                    GLU.gluTessVertex((GLUtessellator)tess, (double[])vertex, (int)0, (Object)vertex);
                    ++n4;
                }
                GLU.gluTessEndContour((GLUtessellator)tess);
                ++n2;
            }
            GLU.gluTessEndPolygon((GLUtessellator)tess);
        }
        finally {
            GLU.gluDeleteTess((GLUtessellator)tess);
        }
    }

    public void copy(IVideoBuffer src, IVideoBuffer dst) {
        final VideoBounds srcBounds = src.getBounds();
        final VideoBounds dstBounds = dst.getBounds();
        if (srcBounds.isEmpty() || dstBounds.isEmpty()) {
            return;
        }
        Runnable operation = new Runnable(){

            public void run() {
                GL2 gl = VideoRenderSupportImpl.this.context.getGL().getGL2();
                gl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
                VideoRenderSupportImpl.this.ortho2D(dstBounds);
                VideoRenderSupportImpl.this.quad2D(srcBounds, new double[][][]{new double[][]{{0.0, 0.0}, {1.0, 0.0}, {1.0, 1.0}, {0.0, 1.0}}});
            }
        };
        int pushAttribs = 1;
        this.useFramebuffer(operation, pushAttribs, dst, src);
    }
}

