/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core;

import ch.kuramo.javie.api.IAnimatableVec3d;
import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.api.Vec2d;
import ch.kuramo.javie.api.Vec3d;
import ch.kuramo.javie.core.AbstractAnimatableValue;
import ch.kuramo.javie.core.ArithmeticalAnimatableValue;
import ch.kuramo.javie.core.CoreContext;
import ch.kuramo.javie.core.Keyframe;
import ch.kuramo.javie.core.exprelems.Vec2dProperty;
import ch.kuramo.javie.core.exprelems.Vec3dProperty;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Quat4d;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Wrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnimatableVec3d
extends ArithmeticalAnimatableValue<Vec3d>
implements IAnimatableVec3d {
    private boolean _slerp;

    public AnimatableVec3d(Vec3d staticValue, Collection<Keyframe<Vec3d>> keyframes, String expression) {
        super(staticValue, keyframes, expression, Vec3d.NEGATIVE_INFINITY, Vec3d.POSITIVE_INFINITY);
    }

    public AnimatableVec3d(Vec3d defaultValue, boolean slerp) {
        super(defaultValue, Vec3d.NEGATIVE_INFINITY, Vec3d.POSITIVE_INFINITY);
        this._slerp = slerp;
    }

    public AnimatableVec3d(Vec3d defaultValue) {
        this(defaultValue, false);
    }

    public AnimatableVec3d(Vec3d defaultValue, Vec3d minValue, Vec3d maxValue) {
        super(defaultValue, minValue, maxValue);
    }

    @Override
    public void copyConfigurationFrom(AbstractAnimatableValue<Vec3d> src) {
        super.copyConfigurationFrom(src);
        this._slerp = ((AnimatableVec3d)src)._slerp;
    }

    @Override
    public Vec3d clamp(Vec3d value) {
        if (this._slerp) {
            return new Vec3d((value.x % 360.0 + 360.0) % 360.0, (value.y % 360.0 + 360.0) % 360.0, (value.z % 360.0 + 360.0) % 360.0);
        }
        return Vec3d.min((Vec3d)Vec3d.max((Vec3d)value, (Vec3d)((Vec3d)this._minValue)), (Vec3d)((Vec3d)this._maxValue));
    }

    @Override
    protected Vec3d interpolate(Time time, Keyframe<Vec3d> k1, Keyframe<Vec3d> k2, Iterator<Map.Entry<Time, Keyframe<Vec3d>>> tail) {
        if (!this._slerp) {
            return super.interpolate(time, k1, k2, tail);
        }
        switch (k1.interpolation) {
            case LINEAR: {
                return this.valueOf(this.slerp(this.toArray((Vec3d)k1.value), this.toArray((Vec3d)k2.value), k1.time, k2.time, time));
            }
            case CATMULL_ROM: {
                SortedMap headMap = this._keyframes.headMap(k1.time);
                Keyframe k0 = !headMap.isEmpty() ? (Keyframe)headMap.get(headMap.lastKey()) : k1;
                Keyframe<Vec3d> k3 = tail.hasNext() ? tail.next().getValue() : k2;
                double[] p0 = this.toArray((Vec3d)k0.value);
                double[] p1 = this.toArray((Vec3d)k1.value);
                double[] p2 = this.toArray((Vec3d)k2.value);
                double[] p3 = this.toArray((Vec3d)k3.value);
                this.prepareSlerpModeCatmullRom(p1, p0);
                this.prepareSlerpModeCatmullRom(p1, p2);
                this.prepareSlerpModeCatmullRom(p2, p3);
                return this.valueOf(this.catmullRom(p0, p1, p2, p3, k0.time, k1.time, k2.time, k3.time, time));
            }
        }
        return super.interpolate(time, k1, k2, tail);
    }

    private void prepareSlerpModeCatmullRom(double[] a, double[] b) {
        int i = 0;
        while (i < 3) {
            double d = ((b[i] - a[i]) % 360.0 + 360.0) % 360.0;
            if (d > 180.0) {
                d -= 360.0;
            }
            b[i] = a[i] + d;
            ++i;
        }
    }

    protected double[] slerp(double[] p1, double[] p2, Time time1, Time time2, Time time) {
        if (time.equals((Object)time1)) {
            return p1;
        }
        if (time.equals((Object)time2)) {
            return p2;
        }
        double s1 = time1.toSecond();
        double s2 = time2.toSecond();
        double s = time.toSecond();
        double t = (s - s1) / (s2 - s1);
        Matrix4d m1 = new Matrix4d();
        Matrix4d m2 = new Matrix4d();
        Matrix4d m = new Matrix4d();
        AxisAngle4d aa = new AxisAngle4d();
        m1.setIdentity();
        aa.set(1.0, 0.0, 0.0, Math.toRadians(p1[0]));
        m.set(aa);
        m1.mul(m);
        aa.set(0.0, 1.0, 0.0, Math.toRadians(p1[1]));
        m.set(aa);
        m1.mul(m);
        aa.set(0.0, 0.0, 1.0, Math.toRadians(p1[2]));
        m.set(aa);
        m1.mul(m);
        m2.setIdentity();
        aa.set(1.0, 0.0, 0.0, Math.toRadians(p2[0]));
        m.set(aa);
        m2.mul(m);
        aa.set(0.0, 1.0, 0.0, Math.toRadians(p2[1]));
        m.set(aa);
        m2.mul(m);
        aa.set(0.0, 0.0, 1.0, Math.toRadians(p2[2]));
        m.set(aa);
        m2.mul(m);
        Quat4d q1 = new Quat4d();
        Quat4d q2 = new Quat4d();
        q1.set(m1);
        q2.set(m2);
        q1.interpolate(q2, t);
        m.set(q1);
        double x = Math.toDegrees(Math.atan2(m.m12, m.m22));
        double y = Math.toDegrees(Math.asin(-m.m02));
        double z = Math.toDegrees(Math.atan2(m.m01, m.m00));
        x = -x;
        y = -y;
        z = -z;
        return new double[]{x, y, z};
    }

    @Override
    public Vec3d jsToJava(Object jsValue) {
        if (jsValue instanceof Wrapper) {
            Object javaObj = ((Wrapper)jsValue).unwrap();
            if (javaObj instanceof Vec3dProperty) {
                javaObj = ((Vec3dProperty)javaObj).getValue();
            } else if (javaObj instanceof Vec2dProperty) {
                javaObj = ((Vec2dProperty)javaObj).getValue();
            }
            if (javaObj instanceof Vec3d) {
                return (Vec3d)javaObj;
            }
            if (javaObj instanceof Vec2d) {
                Vec2d v2d = (Vec2d)javaObj;
                return new Vec3d(v2d.x, v2d.y);
            }
            if (javaObj instanceof Object[]) {
                Object[] value = (Object[])javaObj;
                double[] array = new double[3];
                int i = 0;
                int n = Math.min(3, value.length);
                while (i < n) {
                    array[i] = (Double)Context.jsToJava((Object)value[i], Double.TYPE);
                    ++i;
                }
                return this.valueOf(array);
            }
        } else {
            if (jsValue instanceof NativeArray) {
                double[] array = (double[])Context.jsToJava((Object)jsValue, double[].class);
                if (array.length < 3) {
                    double[] tmp = array;
                    array = new double[3];
                    int i = 0;
                    while (i < tmp.length) {
                        array[i] = tmp[i];
                        ++i;
                    }
                }
                return this.valueOf(array);
            }
            if (jsValue == null) {
                return Vec3d.ZERO;
            }
        }
        double d = (Double)Context.jsToJava((Object)jsValue, Double.TYPE);
        return new Vec3d(d, d, d);
    }

    @Override
    protected double[] toArray(Vec3d value) {
        return new double[]{value.x, value.y, value.z};
    }

    @Override
    protected Vec3d valueOf(double[] d) {
        return new Vec3d(d[0], d[1], d[2]);
    }

    public Scriptable createExpressionElement(final CoreContext context) {
        Vec3dProperty v3p = new Vec3dProperty(){

            public Vec3d getValue() {
                return (Vec3d)AnimatableVec3d.this.value(context);
            }

            public Vec3d valueAtTime(double t) {
                return (Vec3d)AnimatableVec3d.this.valueAtTime(t, context);
            }
        };
        return context.toNativeJavaObject(v3p, null);
    }
}

