/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.extensionlocation;

import java.net.URI;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.extensionlocation.Activator;
import org.eclipse.equinox.internal.p2.extensionlocation.ExtensionLocationMetadataRepository;
import org.eclipse.equinox.internal.p2.extensionlocation.Messages;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepository;
import org.eclipse.equinox.internal.provisional.spi.p2.metadata.repository.MetadataRepositoryFactory;
import org.eclipse.equinox.internal.provisional.spi.p2.metadata.repository.SimpleMetadataRepositoryFactory;
import org.eclipse.osgi.util.NLS;

public class ExtensionLocationMetadataRepositoryFactory
extends MetadataRepositoryFactory {
    public IMetadataRepository create(URI location, String name, String type, Map properties) throws ProvisionException {
        IStatus status = this.validate(location, null);
        if (!status.isOK()) {
            throw new ProvisionException(status);
        }
        URI repoLocation = ExtensionLocationMetadataRepository.getLocalRepositoryLocation(location);
        if (repoLocation == null) {
            throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.extensionlocation", Messages.failed_create_local_artifact_repository));
        }
        boolean failed = false;
        try {
            new SimpleMetadataRepositoryFactory().load(repoLocation, 0, null);
            failed = true;
        }
        catch (ProvisionException provisionException) {}
        if (failed) {
            String msg = NLS.bind((String)Messages.repo_already_exists, (Object)location.toString());
            throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.extensionlocation", 1001, msg, null));
        }
        IMetadataRepository repository = new SimpleMetadataRepositoryFactory().create(repoLocation, name, null, properties);
        return new ExtensionLocationMetadataRepository(location, repository, null);
    }

    public IMetadataRepository load(URI location, int flags, IProgressMonitor monitor) throws ProvisionException {
        if ((flags & 1) > 0) {
            return null;
        }
        IStatus status = this.validate(location, null);
        if (!status.isOK()) {
            throw new ProvisionException(status);
        }
        URI repoLocation = ExtensionLocationMetadataRepository.getLocalRepositoryLocation(location);
        if (repoLocation == null) {
            throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.extensionlocation", Messages.failed_create_local_artifact_repository));
        }
        try {
            IMetadataRepository repository = new SimpleMetadataRepositoryFactory().load(repoLocation, flags, null);
            return new ExtensionLocationMetadataRepository(location, repository, monitor);
        }
        catch (ProvisionException provisionException) {
            return this.create(location, Activator.getRepositoryName(location), "org.eclipse.equinox.p2.extensionlocation.metadataRepository", null);
        }
    }

    public IStatus validate(URI location, IProgressMonitor monitor) {
        try {
            ExtensionLocationMetadataRepository.validate(location, monitor);
        }
        catch (ProvisionException e) {
            return e.getStatus();
        }
        return Status.OK_STATUS;
    }
}

