/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.engine;

import java.io.File;
import java.util.EventObject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.engine.ActionManager;
import org.eclipse.equinox.internal.p2.engine.DebugHelper;
import org.eclipse.equinox.internal.p2.engine.EngineActivator;
import org.eclipse.equinox.internal.p2.engine.Profile;
import org.eclipse.equinox.internal.p2.engine.SimpleProfileRegistry;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.IProvisioningEventBus;
import org.eclipse.equinox.internal.provisional.p2.engine.BeginOperationEvent;
import org.eclipse.equinox.internal.provisional.p2.engine.CommitOperationEvent;
import org.eclipse.equinox.internal.provisional.p2.engine.EngineSession;
import org.eclipse.equinox.internal.provisional.p2.engine.IEngine;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.engine.Messages;
import org.eclipse.equinox.internal.provisional.p2.engine.Operand;
import org.eclipse.equinox.internal.provisional.p2.engine.PhaseSet;
import org.eclipse.equinox.internal.provisional.p2.engine.ProvisioningContext;
import org.eclipse.equinox.internal.provisional.p2.engine.RollbackOperationEvent;
import org.osgi.framework.BundleContext;

public class Engine
implements IEngine {
    private static final String ENGINE = "engine";
    private final IProvisioningEventBus eventBus;
    private ActionManager actionManager;
    static /* synthetic */ Class class$0;

    public Engine(IProvisioningEventBus eventBus) {
        this.eventBus = eventBus;
        this.actionManager = new ActionManager();
    }

    public IStatus perform(IProfile iprofile, PhaseSet phaseSet, Operand[] operands, ProvisioningContext context, IProgressMonitor monitor) {
        this.checkArguments(iprofile, phaseSet, operands, context, monitor);
        if (context == null) {
            context = new ProvisioningContext();
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        BundleContext bundleContext = EngineActivator.getContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.engine.IProfileRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        SimpleProfileRegistry profileRegistry = (SimpleProfileRegistry)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName());
        Profile profile = profileRegistry.validate(iprofile);
        profileRegistry.lockProfile(profile);
        try {
            IStatus status;
            File profileDataDirectory;
            EngineSession session;
            MultiStatus result;
            this.eventBus.publishEvent((EventObject)new BeginOperationEvent(profile, phaseSet, operands, this));
            if (DebugHelper.DEBUG_ENGINE) {
                DebugHelper.debug(ENGINE, "Beginning engine operation for profile=" + profile.getProfileId() + " [" + profile.getTimestamp() + "]:" + DebugHelper.LINE_SEPARATOR + DebugHelper.formatOperation(phaseSet, operands, context));
            }
            if ((result = phaseSet.perform(this.actionManager, session = new EngineSession(profile, profileDataDirectory = profileRegistry.getProfileDataDirectory(profile.getProfileId()), context), profile, operands, context, monitor)).isOK() || result.matches(3)) {
                if (DebugHelper.DEBUG_ENGINE) {
                    DebugHelper.debug(ENGINE, "Preparing to commit engine operation for profile=" + profile.getProfileId());
                }
                result.merge(session.prepare(monitor));
            }
            if (result.matches(12)) {
                if (DebugHelper.DEBUG_ENGINE) {
                    DebugHelper.debug(ENGINE, "Rolling back engine operation for profile=" + profile.getProfileId() + ". Reason was: " + result.toString());
                }
                if ((status = session.rollback(monitor, result.getSeverity())).matches(4)) {
                    LogHelper.log((IStatus)status);
                }
                this.eventBus.publishEvent((EventObject)new RollbackOperationEvent(profile, phaseSet, operands, this, (IStatus)result));
            } else {
                if (DebugHelper.DEBUG_ENGINE) {
                    DebugHelper.debug(ENGINE, "Committing engine operation for profile=" + profile.getProfileId());
                }
                if (profile.isChanged()) {
                    profileRegistry.updateProfile(profile);
                }
                if ((status = session.commit(monitor)).matches(4)) {
                    LogHelper.log((IStatus)status);
                }
                this.eventBus.publishEvent((EventObject)new CommitOperationEvent(profile, phaseSet, operands, this));
            }
            IStatus[] children = result.getChildren();
            MultiStatus multiStatus = children.length == 1 ? children[0] : result;
            return multiStatus;
        }
        finally {
            profileRegistry.unlockProfile(profile);
            profile.setChanged(false);
        }
    }

    public IStatus validate(IProfile iprofile, PhaseSet phaseSet, Operand[] operands, ProvisioningContext context, IProgressMonitor monitor) {
        this.checkArguments(iprofile, phaseSet, operands, context, monitor);
        if (context == null) {
            context = new ProvisioningContext();
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        return phaseSet.validate(this.actionManager, iprofile, operands, context, monitor);
    }

    private void checkArguments(IProfile iprofile, PhaseSet phaseSet, Operand[] operands, ProvisioningContext context, IProgressMonitor monitor) {
        if (iprofile == null) {
            throw new IllegalArgumentException(Messages.null_profile);
        }
        if (phaseSet == null) {
            throw new IllegalArgumentException(Messages.null_phaseset);
        }
        if (operands == null) {
            throw new IllegalArgumentException(Messages.null_operands);
        }
    }
}

