/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.mmd2javie;

import ch.kuramo.javie.core.Project;
import ch.kuramo.javie.core.Util;
import ch.kuramo.mmd2javie.AEScriptObjects;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MMD2Javie {
    private static final Logger logger = LoggerFactory.getLogger(MMD2Javie.class);
    private final ContextFactory contextFactory;

    MMD2Javie(ContextFactory contextFactory) {
        this.contextFactory = contextFactory;
    }

    boolean run(final File file, final Project project, IRunnableContext rc) {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    MMD2Javie.this.evaluateJSXFile(file, project, monitor);
                }
                catch (IOException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        try {
            logger.info("\u51e6\u7406\u3092\u958b\u59cb\u3057\u307e\u3057\u305f...");
            rc.run(true, true, runnable);
            logger.info("\u51e6\u7406\u3092\u5b8c\u4e86\u3057\u307e\u3057\u305f");
            return true;
        }
        catch (InterruptedException interruptedException) {
            logger.info("\u51e6\u7406\u3092\u4e2d\u65ad\u3057\u307e\u3057\u305f");
        }
        catch (InvocationTargetException ex) {
            Throwable t = ex.getTargetException();
            logger.error("\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f", t != null ? t : ex);
        }
        return false;
    }

    private void evaluateJSXFile(File file, Project project, IProgressMonitor monitor) throws IOException, InterruptedException {
        List lines = Util.newList();
        monitor.beginTask("JSX\u30d5\u30a1\u30a4\u30eb\u3092\u8aad\u307f\u8fbc\u307f\u4e2d...", -1);
        BufferedReader jsxReader = null;
        try {
            String line;
            jsxReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            while ((line = jsxReader.readLine()) != null) {
                lines.add(line);
            }
        }
        finally {
            monitor.done();
            if (jsxReader != null) {
                jsxReader.close();
            }
        }
        monitor.beginTask("\u30b9\u30af\u30ea\u30d7\u30c8\u3092\u51e6\u7406\u4e2d...", lines.size());
        try {
            Context context = this.contextFactory.enterContext();
            ScriptableObject scope = context.initStandardObjects();
            Object app = Context.javaToJS((Object)AEScriptObjects.createAppObject(project), (Scriptable)scope);
            ScriptableObject.putProperty((Scriptable)scope, (String)"app", (Object)app);
            String sourceName = file.getName();
            StringBuilder sb = new StringBuilder();
            ListIterator it = lines.listIterator();
            while (it.hasNext()) {
                if (monitor.isCanceled()) {
                    throw new InterruptedException("canceled");
                }
                int i = it.nextIndex();
                sb.setLength(0);
                int j = 0;
                while (j < 200 && it.hasNext()) {
                    sb.append((String)it.next()).append("\n");
                    ++j;
                }
                context.evaluateString((Scriptable)scope, sb.toString(), sourceName, i, null);
                monitor.worked(j);
            }
        }
        finally {
            monitor.done();
            Context.exit();
        }
    }
}

