/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.wizards;

import ch.kuramo.javie.api.AudioMode;
import ch.kuramo.javie.app.widgets.GridBuilder;
import ch.kuramo.javie.core.Composition;
import ch.kuramo.javie.core.output.MacOSXQTMovieOutput;
import ch.kuramo.javie.core.output.Output;
import java.util.Arrays;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class QTMovieOutputSettingsWizardPage
extends WizardPage {
    private static boolean videoEnabledDefault = true;
    private static Output.VideoChannels videoChannelsDefault = Output.VideoChannels.RGB;
    private static ch.kuramo.javie.api.Color colorMatteDefault = ch.kuramo.javie.api.Color.BLACK;
    private static MacOSXQTMovieOutput.VideoCompressorSettings vcSettingsDefault;
    private static boolean audioEnabledDefault;
    private static AudioMode audioModeDefault;
    private static MacOSXQTMovieOutput.AudioCompressorSettings acSettingsDefault;
    private final double compositionFrameRate;
    private boolean videoEnabled = videoEnabledDefault;
    private Output.VideoChannels videoChannels = videoChannelsDefault;
    private ch.kuramo.javie.api.Color colorMatte = colorMatteDefault;
    private MacOSXQTMovieOutput.VideoCompressorSettings vcSettings;
    private boolean audioEnabled = audioEnabledDefault;
    private AudioMode audioMode = audioModeDefault;
    private MacOSXQTMovieOutput.AudioCompressorSettings acSettings;
    private Image colorMatteImage;

    static {
        audioEnabledDefault = true;
        audioModeDefault = AudioMode.STEREO_48KHZ_INT16;
    }

    public QTMovieOutputSettingsWizardPage(Composition composition) {
        super("QTMovieOutputSettingsWizardPage");
        this.setTitle("\u51fa\u529b\u8a2d\u5b9a");
        this.compositionFrameRate = 1.0 / composition.getFrameDuration().toSecond();
        this.vcSettings = MacOSXQTMovieOutput.doVideoCompressorSettings((MacOSXQTMovieOutput.VideoCompressorSettings)vcSettingsDefault, (double)this.compositionFrameRate, (boolean)false);
        this.acSettings = MacOSXQTMovieOutput.doAudioCompressorSettings((MacOSXQTMovieOutput.AudioCompressorSettings)acSettingsDefault, (double)this.audioMode.sampleRate, (boolean)false);
    }

    public void dispose() {
        if (this.colorMatteImage != null) {
            this.colorMatteImage.dispose();
            this.colorMatteImage = null;
        }
        super.dispose();
    }

    public void createControl(Composite parent) {
        GridBuilder gb = new GridBuilder(parent, 1, false);
        ((GridLayout)gb.getComposite().getLayout()).verticalSpacing = 0;
        this.createVideoGroup(gb);
        gb.size(10, 10).composite(0);
        this.createAudioGroup(gb);
        Composite grid = gb.getComposite();
        grid.setTabList(gb.getTabList());
        this.setControl((Control)grid);
        this.doValidate();
    }

    private void createVideoGroup(GridBuilder gb) {
        String[] channelItems = new String[]{"RGB", "\u30a2\u30eb\u30d5\u30a1", "RGB + \u30a2\u30eb\u30d5\u30a1\uff08\u30b9\u30c8\u30ec\u30fc\u30c8\uff09", "RGB + \u30a2\u30eb\u30d5\u30a1\uff08\u4e57\u7b97\u6e08\u307f\uff09"};
        final Button enabledCheck = gb.hAlign(16384).hGrab().button(32, "\u30d3\u30c7\u30aa\u51fa\u529b");
        enabledCheck.setSelection(this.videoEnabled);
        Group group = gb.hAlign(4).group(0, null);
        group.setLayout((Layout)new FillLayout(256));
        GridBuilder gb2 = new GridBuilder((Composite)group, 6, false);
        GridLayout layout = (GridLayout)gb2.getComposite().getLayout();
        layout.marginWidth = 15;
        final Label chLabel = gb2.hSpan(1).hAlign(131072).label(0, "\u51fa\u529b\u30c1\u30e3\u30f3\u30cd\u30eb:");
        final Combo chCombo = gb2.hSpan(2).hAlign(16384).combo(8, 0, channelItems, channelItems[this.videoChannels.ordinal()]);
        gb2.hSpan(1).size(10, 10).composite(0);
        final Label matteLabel = gb2.hSpan(1).hAlign(131072).label(0, "\u30ab\u30e9\u30fc\u30de\u30c3\u30c8:");
        final Button matteButton = gb2.hSpan(1).hAlign(16384).button(0x800008, "");
        final Label vcompLabel = gb2.hSpan(1).hAlign(131072).label(0, "\u30d3\u30c7\u30aa\u5727\u7e2e:");
        final Button vcompButton = gb2.hSpan(1).hAlign(16384).button(8, "\u8a2d\u5b9a...");
        final Label vcompAsText = gb2.span(4, 2).hAlign(4).label(0, this.vcSettings.text);
        gb2.hSpan(2).vGrab().size(10, 10).composite(0);
        this.enableControls(this.videoEnabled, new Control[]{chLabel, chCombo, vcompLabel, vcompButton, vcompAsText});
        this.enableControls(this.videoEnabled && this.videoChannels == Output.VideoChannels.RGBA_PREMULTIPLIED, new Control[]{matteLabel, matteButton});
        this.updateColorMatteImage(matteButton, this.toRGB(this.colorMatte));
        enabledCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QTMovieOutputSettingsWizardPage.this.videoEnabled = enabledCheck.getSelection();
                QTMovieOutputSettingsWizardPage.this.enableControls(QTMovieOutputSettingsWizardPage.this.videoEnabled, new Control[]{chLabel, chCombo, vcompLabel, vcompButton, vcompAsText});
                QTMovieOutputSettingsWizardPage.this.enableControls(QTMovieOutputSettingsWizardPage.this.videoEnabled && QTMovieOutputSettingsWizardPage.this.videoChannels == Output.VideoChannels.RGBA_PREMULTIPLIED, new Control[]{matteLabel, matteButton});
                QTMovieOutputSettingsWizardPage.this.doValidate();
            }
        });
        chCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QTMovieOutputSettingsWizardPage.this.videoChannels = Output.VideoChannels.values()[chCombo.getSelectionIndex()];
                QTMovieOutputSettingsWizardPage.this.enableControls(QTMovieOutputSettingsWizardPage.this.videoChannels == Output.VideoChannels.RGBA_PREMULTIPLIED, new Control[]{matteLabel, matteButton});
                QTMovieOutputSettingsWizardPage.this.doValidate();
            }
        });
        matteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColorDialog dialog = new ColorDialog(QTMovieOutputSettingsWizardPage.this.getShell());
                dialog.setRGB(QTMovieOutputSettingsWizardPage.this.toRGB(QTMovieOutputSettingsWizardPage.this.colorMatte));
                RGB rgb = dialog.open();
                if (rgb != null) {
                    QTMovieOutputSettingsWizardPage.this.colorMatte = QTMovieOutputSettingsWizardPage.this.toColor(rgb);
                    QTMovieOutputSettingsWizardPage.this.updateColorMatteImage((Button)e.widget, rgb);
                    QTMovieOutputSettingsWizardPage.this.doValidate();
                }
                QTMovieOutputSettingsWizardPage.this.doValidate();
            }
        });
        vcompButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MacOSXQTMovieOutput.VideoCompressorSettings newSettings = MacOSXQTMovieOutput.doVideoCompressorSettings((MacOSXQTMovieOutput.VideoCompressorSettings)QTMovieOutputSettingsWizardPage.this.vcSettings, (double)((QTMovieOutputSettingsWizardPage)QTMovieOutputSettingsWizardPage.this).vcSettings.frameRate, (boolean)true);
                if (newSettings != null) {
                    QTMovieOutputSettingsWizardPage.this.vcSettings = newSettings;
                    vcompAsText.setText(newSettings.text);
                    QTMovieOutputSettingsWizardPage.this.doValidate();
                }
            }
        });
        Composite grid2 = gb2.getComposite();
        grid2.setTabList(gb2.getTabList());
    }

    private void createAudioGroup(GridBuilder gb) {
        String[] audioItems = new String[]{"48kHz, 16bit", "48kHz, 32bit", "48kHz, 32bit\u6d6e\u52d5\u5c0f\u6570", "96kHz, 16bit", "96kHz, 32bit", "96kHz, 32bit\u6d6e\u52d5\u5c0f\u6570"};
        final Button enabledCheck = gb.hAlign(16384).hGrab().button(32, "\u30aa\u30fc\u30c7\u30a3\u30aa\u51fa\u529b");
        enabledCheck.setSelection(this.audioEnabled);
        Group group = gb.hAlign(4).group(0, null);
        group.setLayout((Layout)new FillLayout(256));
        GridBuilder gb3 = new GridBuilder((Composite)group, 3, false);
        GridLayout layout = (GridLayout)gb3.getComposite().getLayout();
        layout.marginWidth = 15;
        final Label amodeLabel = gb3.hSpan(1).hAlign(131072).label(0, "\u5185\u90e8\u51e6\u7406\u5f62\u5f0f:");
        final Combo amodeCombo = gb3.hSpan(2).hAlign(16384).combo(8, 0, audioItems, audioItems[this.audioMode.ordinal()]);
        final Label acompLabel = gb3.hSpan(1).hAlign(131072).label(0, "\u30aa\u30fc\u30c7\u30a3\u30aa\u5727\u7e2e:");
        final Button acompButton = gb3.hSpan(1).hAlign(16384).button(8, "\u8a2d\u5b9a...");
        final Label acompAsText = gb3.span(1, 2).hAlign(4).label(0, this.acSettings.text);
        gb3.hSpan(2).vGrab().size(10, 10).composite(0);
        this.enableControls(this.audioEnabled, new Control[]{amodeLabel, amodeCombo, acompLabel, acompButton, acompAsText});
        enabledCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QTMovieOutputSettingsWizardPage.this.audioEnabled = enabledCheck.getSelection();
                QTMovieOutputSettingsWizardPage.this.enableControls(QTMovieOutputSettingsWizardPage.this.audioEnabled, new Control[]{amodeLabel, amodeCombo, acompLabel, acompButton, acompAsText});
                QTMovieOutputSettingsWizardPage.this.doValidate();
            }
        });
        amodeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QTMovieOutputSettingsWizardPage.this.audioMode = AudioMode.values()[amodeCombo.getSelectionIndex()];
                QTMovieOutputSettingsWizardPage.this.doValidate();
            }
        });
        acompButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MacOSXQTMovieOutput.AudioCompressorSettings newSettings = MacOSXQTMovieOutput.doAudioCompressorSettings((MacOSXQTMovieOutput.AudioCompressorSettings)QTMovieOutputSettingsWizardPage.this.acSettings, (double)((QTMovieOutputSettingsWizardPage)QTMovieOutputSettingsWizardPage.this).acSettings.sampleRate, (boolean)true);
                if (newSettings != null) {
                    QTMovieOutputSettingsWizardPage.this.acSettings = newSettings;
                    acompAsText.setText(newSettings.text);
                    QTMovieOutputSettingsWizardPage.this.doValidate();
                }
            }
        });
        Composite grid3 = gb3.getComposite();
        grid3.setTabList(gb3.getTabList());
    }

    private void enableControls(boolean enabled, Control ... controls) {
        Color disabledColor = this.getShell().getDisplay().getSystemColor(16);
        Control[] controlArray = controls;
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            if (c instanceof Label) {
                c.setForeground(enabled ? c.getParent().getForeground() : disabledColor);
            } else {
                c.setEnabled(enabled);
            }
            ++n2;
        }
    }

    private RGB toRGB(ch.kuramo.javie.api.Color color) {
        return new RGB((int)(color.r * 255.0), (int)(color.g * 255.0), (int)(color.b * 255.0));
    }

    private ch.kuramo.javie.api.Color toColor(RGB rgb) {
        return new ch.kuramo.javie.api.Color((double)rgb.red / 255.0, (double)rgb.green / 255.0, (double)rgb.blue / 255.0, 1.0);
    }

    private void updateColorMatteImage(Button button, RGB rgb) {
        PaletteData palette = new PaletteData(new RGB[]{new RGB(0, 0, 0), rgb});
        byte[] data = new byte[64];
        Arrays.fill(data, (byte)-1);
        ImageData imageData = new ImageData(32, 16, 1, palette, 1, data);
        Image image = new Image((Device)button.getDisplay(), imageData);
        button.setImage(image);
        if (this.colorMatteImage != null) {
            this.colorMatteImage.dispose();
        }
        this.colorMatteImage = image;
    }

    private void doValidate() {
        this.setPageComplete(false);
        if (!this.videoEnabled && !this.audioEnabled) {
            this.setErrorMessage("\u30d3\u30c7\u30aa\u51fa\u529b\u3068\u30aa\u30fc\u30c7\u30a3\u30aa\u51fa\u529b\u306e\u5c11\u306a\u304f\u3068\u3082\u3069\u3061\u3089\u304b\u4e00\u65b9\u306f\u6709\u52b9\u306b\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002");
            return;
        }
        if (this.videoEnabled) {
            switch (this.videoChannels) {
                case RGBA_STRAIGHT: 
                case RGBA_PREMULTIPLIED: {
                    if (this.vcSettings.depth >= 32) break;
                    this.setErrorMessage("\u201cRGB + \u30a2\u30eb\u30d5\u30a1\u201d \u3092\u51fa\u529b\u3059\u308b\u306b\u306f\u3001\u30d3\u30c7\u30aa\u5727\u7e2e\u306e\u968e\u8abf\u3092 \u201c\u7d04 1670 \u4e07\u8272\u4ee5\u4e0a\u201d \u306b\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002");
                    return;
                }
            }
        }
        String warning = null;
        if (this.videoEnabled) {
            String fpsVideoComp = String.format("%.02f", this.vcSettings.frameRate);
            String fpsComposition = String.format("%.02f", this.compositionFrameRate);
            if (warning == null && !fpsVideoComp.equals(fpsComposition)) {
                warning = "\u30d3\u30c7\u30aa\u5727\u7e2e\u306e\u30d5\u30ec\u30fc\u30e0\u30ec\u30fc\u30c8\u304c\u30b3\u30f3\u30dd\u30b8\u30b7\u30e7\u30f3\u306e\u30d5\u30ec\u30fc\u30e0\u30ec\u30fc\u30c8\u3068\u4e00\u81f4\u3057\u3066\u3044\u307e\u305b\u3093\u3002\u30b3\u30f3\u30dd\u30b8\u30b7\u30e7\u30f3\u306e\u30d5\u30ec\u30fc\u30e0\u30ec\u30fc\u30c8\u306f" + String.format(" %.02f \u3067\u3059\u3002", this.compositionFrameRate);
            }
        }
        if (this.audioEnabled && warning == null && this.acSettings.sampleRate != (double)this.audioMode.sampleRate) {
            warning = "\u5185\u90e8\u51e6\u7406\u5f62\u5f0f\u306e\u30b5\u30f3\u30d7\u30eb\u30ec\u30fc\u30c8\u3068\u30aa\u30fc\u30c7\u30a3\u30aa\u5727\u7e2e\u306e\u30b5\u30f3\u30d7\u30eb\u30ec\u30fc\u30c8\u304c\u4e00\u81f4\u3057\u3066\u3044\u307e\u305b\u3093\u3002";
        }
        this.setMessage(warning, 2);
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }

    public void saveDefaults() {
        videoEnabledDefault = this.videoEnabled;
        videoChannelsDefault = this.videoChannels;
        colorMatteDefault = this.colorMatte;
        vcSettingsDefault = this.vcSettings;
        audioEnabledDefault = this.audioEnabled;
        audioModeDefault = this.audioMode;
        acSettingsDefault = this.acSettings;
    }

    public boolean isVideoEnabled() {
        return this.videoEnabled;
    }

    public Output.VideoChannels getVideoChannels() {
        return this.videoChannels;
    }

    public ch.kuramo.javie.api.Color getColorMatte() {
        return this.colorMatte;
    }

    public MacOSXQTMovieOutput.VideoCompressorSettings getVideoCompressorSettings() {
        return this.vcSettings;
    }

    public boolean isAudioEnabled() {
        return this.audioEnabled;
    }

    public AudioMode getAudioMode() {
        return this.audioMode;
    }

    public MacOSXQTMovieOutput.AudioCompressorSettings getAudioCompressorSettings() {
        return this.acSettings;
    }
}

