/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.wizards;

import ch.kuramo.javie.api.AudioMode;
import ch.kuramo.javie.app.widgets.GridBuilder;
import ch.kuramo.javie.core.Composition;
import ch.kuramo.javie.core.JavieRuntimeException;
import ch.kuramo.javie.core.Util;
import ch.kuramo.javie.core.output.Output;
import ch.kuramo.javie.core.output.WindowsDirectShowOutput;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AVIOutputSettingsWizardPage
extends WizardPage {
    private static final WindowsDirectShowOutput.VideoCompressorDescriptor VIDEOCOMPDESC_UNCOMPRESSED = WindowsDirectShowOutput.VideoCompressorDescriptor.uncompressedDescriptor((String)"\u975e\u5727\u7e2e");
    private static boolean videoEnabledDefault = true;
    private static Output.VideoChannels videoChannelsDefault = Output.VideoChannels.RGB;
    private static ch.kuramo.javie.api.Color colorMatteDefault = ch.kuramo.javie.api.Color.BLACK;
    private static WindowsDirectShowOutput.VideoCompressorSettings vcSettingsDefault = new WindowsDirectShowOutput.VideoCompressorSettings(VIDEOCOMPDESC_UNCOMPRESSED);
    private static boolean audioEnabledDefault = true;
    private static AudioMode audioModeDefault = AudioMode.STEREO_48KHZ_INT16;
    private final Composition composition;
    private boolean videoEnabled = videoEnabledDefault;
    private Output.VideoChannels videoChannels = videoChannelsDefault;
    private ch.kuramo.javie.api.Color colorMatte = colorMatteDefault;
    private WindowsDirectShowOutput.VideoCompressorSettings vcSettings = vcSettingsDefault;
    private boolean audioEnabled = audioEnabledDefault;
    private AudioMode audioMode = audioModeDefault;
    private Image colorMatteImage;

    public AVIOutputSettingsWizardPage(Composition composition) {
        super("AVIOutputSettingsWizardPage");
        this.setTitle("\u51fa\u529b\u8a2d\u5b9a");
        this.composition = composition;
    }

    public void dispose() {
        if (this.colorMatteImage != null) {
            this.colorMatteImage.dispose();
            this.colorMatteImage = null;
        }
        super.dispose();
    }

    public void createControl(Composite parent) {
        GridBuilder gb = new GridBuilder(parent, 1, false);
        ((GridLayout)gb.getComposite().getLayout()).verticalSpacing = 0;
        this.createVideoGroup(gb);
        gb.size(15, 15).composite(0);
        this.createAudioGroup(gb);
        Composite grid = gb.getComposite();
        grid.setTabList(gb.getTabList());
        this.setControl((Control)grid);
        this.doValidate();
    }

    private void createVideoGroup(GridBuilder gb) {
        String[] channelItems = new String[]{"RGB", "\u30a2\u30eb\u30d5\u30a1", "RGB + \u30a2\u30eb\u30d5\u30a1\uff08\u30b9\u30c8\u30ec\u30fc\u30c8\uff09", "RGB + \u30a2\u30eb\u30d5\u30a1\uff08\u4e57\u7b97\u6e08\u307f\uff09"};
        final Button enabledCheck = gb.hAlign(16384).hGrab().button(32, "\u30d3\u30c7\u30aa\u51fa\u529b");
        enabledCheck.setSelection(this.videoEnabled);
        Group group = gb.hAlign(4).group(0, null);
        group.setLayout((Layout)new FillLayout(256));
        GridBuilder gb2 = new GridBuilder((Composite)group, 6, false);
        GridLayout layout = (GridLayout)gb2.getComposite().getLayout();
        layout.marginWidth = 15;
        layout.marginBottom = 3;
        final Label chLabel = gb2.hSpan(1).hAlign(131072).label(0, "\u51fa\u529b\u30c1\u30e3\u30f3\u30cd\u30eb:");
        final Combo chCombo = gb2.hSpan(2).hAlign(16384).combo(8, 0, channelItems, channelItems[this.videoChannels.ordinal()]);
        gb2.hSpan(1).size(10, 10).composite(0);
        final Label matteLabel = gb2.hSpan(1).hAlign(131072).label(0, "\u30ab\u30e9\u30fc\u30de\u30c3\u30c8:");
        final Button matteButton = gb2.hSpan(1).hAlign(16384).button(0x800008, "");
        final Label vcompLabel = gb2.hSpan(1).hAlign(131072).label(0, "\u30d3\u30c7\u30aa\u5727\u7e2e:");
        final Button vcompButton = gb2.hSpan(1).hAlign(16384).button(8, "\u8a2d\u5b9a...");
        final Label vcompName = gb2.hSpan(4).hAlign(4).hGrab().label(0, this.vcSettings.friendlyName);
        this.enableControls(this.videoEnabled, new Control[]{chLabel, chCombo, vcompLabel, vcompButton, vcompName});
        this.enableControls(this.videoEnabled && this.videoChannels == Output.VideoChannels.RGBA_PREMULTIPLIED, new Control[]{matteLabel, matteButton});
        this.updateColorMatteImage(matteButton, this.toRGB(this.colorMatte));
        enabledCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AVIOutputSettingsWizardPage.this.videoEnabled = enabledCheck.getSelection();
                AVIOutputSettingsWizardPage.this.enableControls(AVIOutputSettingsWizardPage.this.videoEnabled, new Control[]{chLabel, chCombo, vcompLabel, vcompButton, vcompName});
                AVIOutputSettingsWizardPage.this.enableControls(AVIOutputSettingsWizardPage.this.videoEnabled && AVIOutputSettingsWizardPage.this.videoChannels == Output.VideoChannels.RGBA_PREMULTIPLIED, new Control[]{matteLabel, matteButton});
                AVIOutputSettingsWizardPage.this.doValidate();
            }
        });
        chCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AVIOutputSettingsWizardPage.this.videoChannels = Output.VideoChannels.values()[chCombo.getSelectionIndex()];
                AVIOutputSettingsWizardPage.this.enableControls(AVIOutputSettingsWizardPage.this.videoChannels == Output.VideoChannels.RGBA_PREMULTIPLIED, new Control[]{matteLabel, matteButton});
                AVIOutputSettingsWizardPage.this.doValidate();
            }
        });
        matteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColorDialog dialog = new ColorDialog(AVIOutputSettingsWizardPage.this.getShell());
                dialog.setRGB(AVIOutputSettingsWizardPage.this.toRGB(AVIOutputSettingsWizardPage.this.colorMatte));
                RGB rgb = dialog.open();
                if (rgb != null) {
                    AVIOutputSettingsWizardPage.this.colorMatte = AVIOutputSettingsWizardPage.this.toColor(rgb);
                    AVIOutputSettingsWizardPage.this.updateColorMatteImage((Button)e.widget, rgb);
                    AVIOutputSettingsWizardPage.this.doValidate();
                }
                AVIOutputSettingsWizardPage.this.doValidate();
            }
        });
        vcompButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VideoCompressorSettingsDialog dialog = new VideoCompressorSettingsDialog(AVIOutputSettingsWizardPage.this.getShell(), AVIOutputSettingsWizardPage.this.composition, AVIOutputSettingsWizardPage.this.vcSettings);
                if (dialog.open() == 0) {
                    AVIOutputSettingsWizardPage.this.vcSettings = dialog.getSettings();
                    vcompName.setText(((AVIOutputSettingsWizardPage)AVIOutputSettingsWizardPage.this).vcSettings.friendlyName);
                    AVIOutputSettingsWizardPage.this.doValidate();
                }
            }
        });
        Composite grid2 = gb2.getComposite();
        grid2.setTabList(gb2.getTabList());
    }

    private void createAudioGroup(GridBuilder gb) {
        String[] audioItems = new String[]{"48kHz, 16bit", "48kHz, 32bit", "48kHz, 32bit\u6d6e\u52d5\u5c0f\u6570", "96kHz, 16bit", "96kHz, 32bit", "96kHz, 32bit\u6d6e\u52d5\u5c0f\u6570"};
        final Button enabledCheck = gb.hAlign(16384).hGrab().button(32, "\u30aa\u30fc\u30c7\u30a3\u30aa\u51fa\u529b");
        enabledCheck.setSelection(this.audioEnabled);
        Group group = gb.hAlign(4).group(0, null);
        group.setLayout((Layout)new FillLayout(256));
        GridBuilder gb3 = new GridBuilder((Composite)group, 2, false);
        GridLayout layout = (GridLayout)gb3.getComposite().getLayout();
        layout.marginWidth = 15;
        layout.marginBottom = 3;
        final Label amodeLabel = gb3.hSpan(1).hAlign(131072).label(0, "\u5185\u90e8\u51e6\u7406\u5f62\u5f0f:");
        final Combo amodeCombo = gb3.hSpan(1).hAlign(16384).combo(8, 0, audioItems, audioItems[this.audioMode.ordinal()]);
        this.enableControls(this.audioEnabled, new Control[]{amodeLabel, amodeCombo});
        enabledCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AVIOutputSettingsWizardPage.this.audioEnabled = enabledCheck.getSelection();
                AVIOutputSettingsWizardPage.this.enableControls(AVIOutputSettingsWizardPage.this.audioEnabled, new Control[]{amodeLabel, amodeCombo});
                AVIOutputSettingsWizardPage.this.doValidate();
            }
        });
        amodeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AVIOutputSettingsWizardPage.this.audioMode = AudioMode.values()[amodeCombo.getSelectionIndex()];
                AVIOutputSettingsWizardPage.this.doValidate();
            }
        });
        Composite grid3 = gb3.getComposite();
        grid3.setTabList(gb3.getTabList());
    }

    private void enableControls(boolean enabled, Control ... controls) {
        Color disabledColor = this.getShell().getDisplay().getSystemColor(16);
        Control[] controlArray = controls;
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            if (c instanceof Label) {
                c.setForeground(enabled ? c.getParent().getForeground() : disabledColor);
            } else {
                c.setEnabled(enabled);
            }
            ++n2;
        }
    }

    private RGB toRGB(ch.kuramo.javie.api.Color color) {
        return new RGB((int)(color.r * 255.0), (int)(color.g * 255.0), (int)(color.b * 255.0));
    }

    private ch.kuramo.javie.api.Color toColor(RGB rgb) {
        return new ch.kuramo.javie.api.Color((double)rgb.red / 255.0, (double)rgb.green / 255.0, (double)rgb.blue / 255.0, 1.0);
    }

    private void updateColorMatteImage(Button button, RGB rgb) {
        PaletteData palette = new PaletteData(new RGB[]{new RGB(0, 0, 0), rgb});
        byte[] data = new byte[64];
        Arrays.fill(data, (byte)-1);
        ImageData imageData = new ImageData(32, 16, 1, palette, 1, data);
        Image image = new Image((Device)button.getDisplay(), imageData);
        button.setImage(image);
        if (this.colorMatteImage != null) {
            this.colorMatteImage.dispose();
        }
        this.colorMatteImage = image;
    }

    private void doValidate() {
        this.setPageComplete(false);
        if (!this.videoEnabled && !this.audioEnabled) {
            this.setErrorMessage("\u30d3\u30c7\u30aa\u51fa\u529b\u3068\u30aa\u30fc\u30c7\u30a3\u30aa\u51fa\u529b\u306e\u5c11\u306a\u304f\u3068\u3082\u3069\u3061\u3089\u304b\u4e00\u65b9\u306f\u6709\u52b9\u306b\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002");
            return;
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }

    public void saveDefaults() {
        videoEnabledDefault = this.videoEnabled;
        videoChannelsDefault = this.videoChannels;
        colorMatteDefault = this.colorMatte;
        vcSettingsDefault = this.vcSettings;
        audioEnabledDefault = this.audioEnabled;
        audioModeDefault = this.audioMode;
    }

    public boolean isVideoEnabled() {
        return this.videoEnabled;
    }

    public Output.VideoChannels getVideoChannels() {
        return this.videoChannels;
    }

    public ch.kuramo.javie.api.Color getColorMatte() {
        return this.colorMatte;
    }

    public WindowsDirectShowOutput.VideoCompressorSettings getVideoCompressorSettings() {
        return this.vcSettings;
    }

    public boolean isAudioEnabled() {
        return this.audioEnabled;
    }

    public AudioMode getAudioMode() {
        return this.audioMode;
    }

    private static class VideoCompressorSettingsDialog
    extends Dialog {
        private final Composition composition;
        private final List<WindowsDirectShowOutput.VideoCompressorDescriptor> compressors;
        private final Map<Integer, WindowsDirectShowOutput.VideoCompressorSettings> settingsCache = Util.newMap();
        private int selectedIndex;
        private Combo compressorCombo;
        private Text qualityText;
        private Text keyFrameText;
        private Text PFramesText;
        private Text bitRateText;
        private Text windowSizeText;
        private Button configButton;
        private Button resetButton;
        private Button aboutButton;
        private Label errorLabel;
        private boolean updatingControls;

        private VideoCompressorSettingsDialog(Shell parentShell, Composition composition, WindowsDirectShowOutput.VideoCompressorSettings defaultSettings) {
            super(parentShell);
            this.composition = composition;
            this.compressors = WindowsDirectShowOutput.listVideoCompressors((Composition)composition);
            Collections.sort(this.compressors, new Comparator<WindowsDirectShowOutput.VideoCompressorDescriptor>(){

                @Override
                public int compare(WindowsDirectShowOutput.VideoCompressorDescriptor o1, WindowsDirectShowOutput.VideoCompressorDescriptor o2) {
                    return o1.friendlyName.compareTo(o2.friendlyName);
                }
            });
            this.compressors.add(VIDEOCOMPDESC_UNCOMPRESSED);
            this.selectedIndex = this.compressors.size() - 1;
            int i = 0;
            int n = this.compressors.size() - 1;
            while (i < n) {
                WindowsDirectShowOutput.VideoCompressorDescriptor desc = this.compressors.get(i);
                if (desc.moniker.equals(defaultSettings.moniker)) {
                    this.settingsCache.put(i, defaultSettings.clone());
                    this.selectedIndex = i;
                    break;
                }
                ++i;
            }
        }

        private WindowsDirectShowOutput.VideoCompressorSettings getSettings() {
            return this.settingsCache.get(this.selectedIndex);
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText("\u30d3\u30c7\u30aa\u5727\u7e2e");
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            List compressorNames = Util.newList();
            for (WindowsDirectShowOutput.VideoCompressorDescriptor desc : this.compressors) {
                compressorNames.add(desc.friendlyName);
            }
            GridBuilder gb = new GridBuilder(composite, 10, true);
            gb.hSpan(2).hAlign(131072).hGrab().label(0, "\u5727\u7e2e\u30d7\u30ed\u30b0\u30e9\u30e0:");
            this.compressorCombo = gb.hSpan(8).hAlign(4).hGrab().combo(8, compressorNames.toArray(new String[compressorNames.size()]));
            gb.hSpan(10).size(10, 10).composite(0);
            gb.hSpan(3).hAlign(131072).hGrab().label(0, "\u5727\u7e2e\u306e\u54c1\u8cea (0\uff5e100):");
            this.qualityText = gb.hSpan(2).hAlign(4).hGrab().tabAfter((Control)this.compressorCombo).text(2048, "");
            gb.hSpan(2).size(10, 10).composite(0);
            this.configButton = gb.hSpan(3).hAlign(4).hGrab().button(8, "\u8a2d\u5b9a");
            gb.hSpan(3).hAlign(131072).hGrab().label(0, "\u30ad\u30fc\u30d5\u30ec\u30fc\u30e0 (0:\u7121\u3057):");
            this.keyFrameText = gb.hSpan(2).hAlign(4).hGrab().tabAfter((Control)this.qualityText).text(2048, "");
            gb.hSpan(2).hAlign(4).hGrab().label(0, "\u30d5\u30ec\u30fc\u30e0\u3054\u3068");
            this.resetButton = gb.hSpan(3).hAlign(4).hGrab().button(8, "\u6a19\u6e96\u306b\u623b\u3059");
            gb.hSpan(3).hAlign(131072).hGrab().label(0, "\uff77\uff70\uff8c\uff9a\uff70\uff91\u6bce\u306eP\uff8c\uff9a\uff70\uff91:");
            this.PFramesText = gb.hSpan(2).hAlign(4).hGrab().tabAfter((Control)this.keyFrameText).text(2048, "");
            gb.hSpan(2).hAlign(4).hGrab().label(0, "\u30d5\u30ec\u30fc\u30e0");
            this.aboutButton = gb.hSpan(3).hAlign(4).hGrab().button(8, "\u30d0\u30fc\u30b8\u30e7\u30f3\u60c5\u5831");
            gb.hSpan(3).hAlign(131072).hGrab().label(0, "\u30c7\u30fc\u30bf\u30ec\u30fc\u30c8 (0:\u7121\u3057):");
            this.bitRateText = gb.hSpan(2).hAlign(4).hGrab().tabAfter((Control)this.PFramesText).text(2048, "");
            gb.hSpan(2).hAlign(4).hGrab().label(0, "KB/\u79d2");
            gb.hSpan(3).hAlign(4).hGrab().button(8, "").setVisible(false);
            gb.hSpan(3).hAlign(131072).hGrab().label(0, "\u30a6\u30a4\u30f3\u30c9\u30a6\u30b5\u30a4\u30ba:");
            this.windowSizeText = gb.hSpan(2).hAlign(4).hGrab().tabAfter((Control)this.bitRateText).text(2048, "");
            gb.hSpan(2).hAlign(4).hGrab().label(0, "\u30d5\u30ec\u30fc\u30e0");
            gb.hSpan(3).hAlign(4).hGrab().button(8, "").setVisible(false);
            gb.hSpan(10).size(15, 15).composite(0);
            this.errorLabel = gb.hSpan(10).hAlign(4).hGrab().label(0, "");
            ModifyListener modifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (!VideoCompressorSettingsDialog.this.updatingControls) {
                        VideoCompressorSettingsDialog.this.updateSettings();
                    }
                }
            };
            this.qualityText.addModifyListener(modifyListener);
            this.keyFrameText.addModifyListener(modifyListener);
            this.PFramesText.addModifyListener(modifyListener);
            this.bitRateText.addModifyListener(modifyListener);
            this.windowSizeText.addModifyListener(modifyListener);
            this.configButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    VideoCompressorSettingsDialog.this.config();
                }
            });
            this.resetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    VideoCompressorSettingsDialog.this.reset();
                }
            });
            this.aboutButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    VideoCompressorSettingsDialog.this.about();
                }
            });
            this.compressorCombo.setVisibleItemCount(20);
            this.compressorCombo.select(this.selectedIndex);
            this.compressorCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    VideoCompressorSettingsDialog.this.selectedIndex = VideoCompressorSettingsDialog.this.compressorCombo.getSelectionIndex();
                    VideoCompressorSettingsDialog.this.updateControls();
                }
            });
            Composite grid = gb.getComposite();
            grid.setTabList(gb.getTabList());
            return composite;
        }

        public void create() {
            super.create();
            this.updateControls();
        }

        private void updateText(Text control, boolean enabled, String text) {
            control.setEnabled(enabled);
            control.setText(enabled ? text : "");
        }

        private void updateControls() {
            this.updatingControls = true;
            try {
                WindowsDirectShowOutput.VideoCompressorDescriptor desc = this.compressors.get(this.selectedIndex);
                WindowsDirectShowOutput.VideoCompressorSettings settings = this.settingsCache.get(this.selectedIndex);
                if (settings == null) {
                    settings = new WindowsDirectShowOutput.VideoCompressorSettings(desc);
                    this.settingsCache.put(this.selectedIndex, settings);
                }
                this.updateText(this.qualityText, desc.canQuality, String.valueOf((int)(settings.quality * 100.0)));
                this.updateText(this.keyFrameText, desc.canKeyFrame, String.valueOf(settings.keyFrameRate));
                this.updateText(this.PFramesText, desc.canBFrame, String.valueOf(settings.PFramesPerKey));
                this.updateText(this.bitRateText, desc.canCrunch, String.valueOf(settings.bitRate >> 13));
                this.updateText(this.windowSizeText, desc.canWindow, String.valueOf(settings.windowSize));
                boolean enableReset = desc.canQuality | desc.canKeyFrame | desc.canBFrame | desc.canCrunch | desc.canWindow | desc.canConfigDialog;
                this.configButton.setEnabled(desc.canConfigDialog);
                this.resetButton.setEnabled(enableReset);
                this.aboutButton.setEnabled(desc.canAboutDialog);
                this.errorMessage(null);
                this.dialogComplete(true);
            }
            finally {
                this.updatingControls = false;
            }
        }

        private void updateSettings() {
            this.dialogComplete(false);
            WindowsDirectShowOutput.VideoCompressorDescriptor desc = this.compressors.get(this.selectedIndex);
            WindowsDirectShowOutput.VideoCompressorSettings settings = this.settingsCache.get(this.selectedIndex);
            double quality = settings.quality;
            if (desc.canQuality) {
                try {
                    quality = Integer.parseInt(this.qualityText.getText().trim());
                }
                catch (NumberFormatException numberFormatException) {
                    quality = -1.0;
                }
                if (quality < 0.0 || quality > 100.0) {
                    this.errorMessage("\u5727\u7e2e\u306e\u54c1\u8cea\u306b\u306f0\u304b\u3089100\u307e\u3067\u306e\u6574\u6570\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                    return;
                }
                quality /= 100.0;
            }
            int keyFrameRate = settings.keyFrameRate;
            if (desc.canKeyFrame) {
                try {
                    keyFrameRate = Integer.parseInt(this.keyFrameText.getText().trim());
                }
                catch (NumberFormatException numberFormatException) {
                    keyFrameRate = -1;
                }
                if (keyFrameRate < 0) {
                    this.errorMessage("\u30ad\u30fc\u30d5\u30ec\u30fc\u30e0\u306b\u306f0\u4ee5\u4e0a\u306e\u6574\u6570\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                    return;
                }
            }
            int PFramesPerKey = settings.PFramesPerKey;
            if (desc.canBFrame) {
                try {
                    PFramesPerKey = Integer.parseInt(this.PFramesText.getText().trim());
                }
                catch (NumberFormatException numberFormatException) {
                    PFramesPerKey = -1;
                }
                if (PFramesPerKey < 0) {
                    this.errorMessage("\uff77\uff70\uff8c\uff9a\uff70\uff91\u6bce\u306eP\uff8c\uff9a\uff70\uff91\u306b\u306f0\u4ee5\u4e0a\u306e\u6574\u6570\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                    return;
                }
            }
            long bitRate = settings.bitRate;
            if (desc.canCrunch) {
                try {
                    bitRate = Integer.parseInt(this.bitRateText.getText().trim());
                }
                catch (NumberFormatException numberFormatException) {
                    bitRate = -1L;
                }
                if (bitRate < 0L) {
                    this.errorMessage("\u30c7\u30fc\u30bf\u30ec\u30fc\u30c8\u306b\u306f0\u4ee5\u4e0a\u306e\u6574\u6570\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                    return;
                }
                bitRate = Math.min(bitRate << 13, Integer.MAX_VALUE);
            }
            long windowSize = settings.windowSize;
            if (desc.canWindow) {
                try {
                    windowSize = Long.parseLong(this.windowSizeText.getText().trim());
                }
                catch (NumberFormatException numberFormatException) {
                    windowSize = 0L;
                }
                if (windowSize <= 0L) {
                    this.errorMessage("\u30a6\u30a4\u30f3\u30c9\u30a6\u30b5\u30a4\u30ba\u306b\u306f1\u4ee5\u4e0a\u306e\u6574\u6570\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                    return;
                }
            }
            settings.quality = quality;
            settings.keyFrameRate = keyFrameRate;
            settings.PFramesPerKey = PFramesPerKey;
            settings.bitRate = bitRate;
            settings.windowSize = windowSize;
            this.errorMessage(null);
            this.dialogComplete(true);
        }

        private void errorMessage(String message) {
            this.errorLabel.setText(message != null ? message : "");
        }

        private void dialogComplete(boolean complete) {
            Button okButton = this.getButton(0);
            okButton.setEnabled(complete);
        }

        private void reset() {
            WindowsDirectShowOutput.VideoCompressorDescriptor desc = this.compressors.get(this.selectedIndex);
            this.settingsCache.put(this.selectedIndex, new WindowsDirectShowOutput.VideoCompressorSettings(desc));
            this.updateControls();
        }

        private void config() {
            WindowsDirectShowOutput.VideoCompressorDescriptor desc = this.compressors.get(this.selectedIndex);
            WindowsDirectShowOutput.VideoCompressorSettings settings = this.settingsCache.get(this.selectedIndex);
            WindowsDirectShowOutput.openVideoCompressorConfigDialog((Composition)this.composition, (WindowsDirectShowOutput.VideoCompressorDescriptor)desc, (WindowsDirectShowOutput.VideoCompressorSettings)settings, (long)this.getHWND());
        }

        private void about() {
            WindowsDirectShowOutput.VideoCompressorDescriptor desc = this.compressors.get(this.selectedIndex);
            WindowsDirectShowOutput.openVideoCompressorAboutDialog((WindowsDirectShowOutput.VideoCompressorDescriptor)desc, (long)this.getHWND());
        }

        private long getHWND() {
            try {
                Shell shell = this.getShell();
                Class<?> clazz = shell.getClass();
                Field handleField = clazz.getField("handle");
                return ((Integer)handleField.get(shell)).intValue();
            }
            catch (NoSuchFieldException e) {
                throw new JavieRuntimeException((Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new JavieRuntimeException((Throwable)e);
            }
        }
    }
}

