/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.views.layercomp;

import ch.kuramo.javie.app.views.layercomp.Element;
import ch.kuramo.javie.app.views.layercomp.LayerAnimatableValueElement;
import ch.kuramo.javie.app.views.layercomp.LayerElement;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LightLayer;
import ch.kuramo.javie.core.LightType;
import ch.kuramo.javie.core.Util;
import java.util.List;

public class LightTransformElement
extends Element {
    private final LightLayer layer;
    private LightType type;
    private final List<LayerAnimatableValueElement> children = Util.newList();

    public LightTransformElement(LayerElement parent) {
        super(parent);
        this.layer = (LightLayer)parent.layer;
    }

    public String getColumnText(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "\u30c8\u30e9\u30f3\u30b9\u30d5\u30a9\u30fc\u30e0";
            }
        }
        return null;
    }

    public boolean hasChildren() {
        return true;
    }

    public Element[] getChildren() {
        LightType currentType = this.layer.getLightType();
        if (currentType == this.type && this.children.size() > 0) {
            return this.children.toArray(new Element[this.children.size()]);
        }
        this.children.clear();
        this.type = currentType;
        switch (this.type) {
            case PARALLEL: {
                this.createChildElement("pointOfInterest", "\u76ee\u6a19\u70b9");
                this.createChildElement("position", "\u4f4d\u7f6e");
                break;
            }
            case SPOT: {
                this.createChildElement("pointOfInterest", "\u76ee\u6a19\u70b9");
                this.createChildElement("position", "\u4f4d\u7f6e");
                this.createChildElement("orientation", "\u65b9\u5411", "\u00b0");
                this.createChildElement("rotationX", "X \u56de\u8ee2", "\u00b0");
                this.createChildElement("rotationY", "Y \u56de\u8ee2", "\u00b0");
                this.createChildElement("rotationZ", "Z \u56de\u8ee2", "\u00b0");
                break;
            }
            case POINT: {
                this.createChildElement("position", "\u4f4d\u7f6e");
                break;
            }
        }
        return this.children.toArray(new Element[this.children.size()]);
    }

    private void createChildElement(String property, String name) {
        this.children.add(LayerAnimatableValueElement.forSimpleProperty(this, (Layer)this.layer, property, name, null));
    }

    private void createChildElement(String property, String name, String unit) {
        this.children.add(LayerAnimatableValueElement.forSimpleProperty(this, (Layer)this.layer, property, name, unit));
    }
}

