/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.views.layercomp;

import ch.kuramo.javie.api.BlendMode;
import ch.kuramo.javie.app.EnumLabels;
import ch.kuramo.javie.app.ImageUtil;
import ch.kuramo.javie.app.project.ModifyLayerBlendModeOperation;
import ch.kuramo.javie.app.project.ModifyLayerParentOperation;
import ch.kuramo.javie.app.project.ModifyLayerTrackMatteOperation;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.project.RenameLayerOperation;
import ch.kuramo.javie.app.views.layercomp.AudioElement;
import ch.kuramo.javie.app.views.layercomp.AudioSwitch;
import ch.kuramo.javie.app.views.layercomp.CTCRSwitch;
import ch.kuramo.javie.app.views.layercomp.CameraOptionsElement;
import ch.kuramo.javie.app.views.layercomp.CameraTransformElement;
import ch.kuramo.javie.app.views.layercomp.EffectsElement;
import ch.kuramo.javie.app.views.layercomp.EffectsSwitch;
import ch.kuramo.javie.app.views.layercomp.Element;
import ch.kuramo.javie.app.views.layercomp.FrameBlendSwitch;
import ch.kuramo.javie.app.views.layercomp.LightOptionsElement;
import ch.kuramo.javie.app.views.layercomp.LightTransformElement;
import ch.kuramo.javie.app.views.layercomp.MaterialOptionsElement;
import ch.kuramo.javie.app.views.layercomp.MotionBlurSwitch;
import ch.kuramo.javie.app.views.layercomp.QualitySwitch;
import ch.kuramo.javie.app.views.layercomp.ShySwitch;
import ch.kuramo.javie.app.views.layercomp.SwitchGroup;
import ch.kuramo.javie.app.views.layercomp.TextElement;
import ch.kuramo.javie.app.views.layercomp.ThreeDSwitch;
import ch.kuramo.javie.app.views.layercomp.TimeRemapElement;
import ch.kuramo.javie.app.views.layercomp.TimelineManager;
import ch.kuramo.javie.app.views.layercomp.TransformElement;
import ch.kuramo.javie.app.views.layercomp.VideoSwitch;
import ch.kuramo.javie.app.widgets.WSWin32;
import ch.kuramo.javie.core.CameraLayer;
import ch.kuramo.javie.core.EffectableLayer;
import ch.kuramo.javie.core.ItemLayer;
import ch.kuramo.javie.core.JavieRuntimeException;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.LayerNature;
import ch.kuramo.javie.core.LightLayer;
import ch.kuramo.javie.core.LightType;
import ch.kuramo.javie.core.MediaLayer;
import ch.kuramo.javie.core.NullLayer;
import ch.kuramo.javie.core.TextLayer;
import ch.kuramo.javie.core.TrackMatte;
import ch.kuramo.javie.core.TransformableLayer;
import ch.kuramo.javie.core.Util;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayerElement
extends Element {
    private static final int[] UNDERLINE_DASH = new int[]{2, 2};
    private static final boolean COCOA = SWT.getPlatform().equals("cocoa");
    private static final boolean WIN32 = SWT.getPlatform().equals("win32");
    public final Layer layer;
    private final LayerComposition composition;
    private final List<Element> children = Util.newList();
    private final Map<Class<? extends Element>, Element> childrenMap = Util.newMap();
    private final SwitchGroup showHideColumnSwitches = new SwitchGroup();
    private final SwitchGroup switchesColumnSwitches = new SwitchGroup();
    private TextCellEditor nameEditor;
    private Rectangle modeArea;
    private Rectangle trackMatteArea;
    private Rectangle parentArea;

    public LayerElement(TreeViewer viewer, Layer layer) {
        super(viewer);
        this.layer = layer;
        this.composition = (LayerComposition)viewer.getData("LAYER_COMPOSITION");
        if (WSWin32.isXPThemed()) {
            this.showHideColumnSwitches.setMarginLeft(11);
            this.switchesColumnSwitches.setMarginLeft(11);
        }
    }

    public void createSwitches() {
        this.showHideColumnSwitches.removeAll();
        this.switchesColumnSwitches.removeAll();
        ProjectManager pm = (ProjectManager)this.viewer.getData("PROJECT_MANAGER");
        if (LayerNature.isVideoNature((Layer)this.layer)) {
            this.showHideColumnSwitches.add(new VideoSwitch(pm, this.layer));
        } else {
            this.showHideColumnSwitches.addPlaceholder();
        }
        if (LayerNature.isAudioNature((Layer)this.layer)) {
            this.showHideColumnSwitches.add(new AudioSwitch(pm, this.layer));
        } else {
            this.showHideColumnSwitches.addPlaceholder();
        }
        this.switchesColumnSwitches.add(new ShySwitch(pm, this.layer));
        if (LayerNature.isCTCRNature((Layer)this.layer)) {
            this.switchesColumnSwitches.add(new CTCRSwitch(pm, this.layer));
        } else {
            this.switchesColumnSwitches.addPlaceholder();
        }
        if (LayerNature.isQualityNature((Layer)this.layer)) {
            this.switchesColumnSwitches.add(new QualitySwitch(pm, this.layer));
        } else {
            this.switchesColumnSwitches.addPlaceholder();
        }
        if (this.layer instanceof EffectableLayer) {
            this.switchesColumnSwitches.add(new EffectsSwitch(pm, (EffectableLayer)this.layer));
        } else {
            this.switchesColumnSwitches.addPlaceholder();
        }
        if (LayerNature.isFrameBlendNature((Layer)this.layer)) {
            this.switchesColumnSwitches.add(new FrameBlendSwitch(pm, this.layer));
        } else {
            this.switchesColumnSwitches.addPlaceholder();
        }
        if (LayerNature.isMotionBlurNature((Layer)this.layer)) {
            this.switchesColumnSwitches.add(new MotionBlurSwitch(pm, this.layer));
        } else {
            this.switchesColumnSwitches.addPlaceholder();
        }
        if (this.layer instanceof TransformableLayer && LayerNature.isThreeDNature((Layer)this.layer)) {
            this.switchesColumnSwitches.add(new ThreeDSwitch(pm, (TransformableLayer)this.layer));
        } else {
            this.switchesColumnSwitches.addPlaceholder();
        }
    }

    @Override
    public Image getColumnImage(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                if (this.layer instanceof ItemLayer) {
                    return ImageUtil.getItemIcon(((ItemLayer)this.layer).getItem());
                }
                if (this.layer instanceof LightLayer) {
                    return ImageUtil.getLightIcon();
                }
                if (this.layer instanceof CameraLayer) {
                    return ImageUtil.getCameraIcon();
                }
                if (this.layer instanceof NullLayer) {
                    return ImageUtil.getNullIcon();
                }
                if (this.layer instanceof TextLayer) {
                    return ImageUtil.getTextIcon();
                }
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ELEMENTS");
            }
        }
        return null;
    }

    @Override
    public String getColumnText(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                String name;
                if (this.layer instanceof ItemLayer) {
                    String itemName = ((ItemLayer)this.layer).getItem().getName();
                    if (this.isLayerNameMode()) {
                        name = this.layer.getName();
                        if (name.equals(itemName)) {
                            name = String.format("[%s]", name);
                        }
                    } else {
                        name = itemName;
                    }
                } else {
                    name = this.layer.getName();
                }
                return name;
            }
        }
        return null;
    }

    private boolean isLayerNameMode() {
        return Boolean.TRUE.equals(this.viewer.getData("LAYER_NAME_MODE"));
    }

    private MediaLayer getTrackMatteLayer() {
        Layer matteLayer;
        List layers;
        int layerIndex;
        if (this.layer instanceof MediaLayer && (layerIndex = (layers = this.composition.getLayers()).indexOf(this.layer)) + 1 < layers.size() && (matteLayer = (Layer)layers.get(layerIndex + 1)) instanceof MediaLayer) {
            return (MediaLayer)matteLayer;
        }
        return null;
    }

    private <E extends Element> E getChildElement(Class<E> clazz) {
        Element element = this.childrenMap.get(clazz);
        if (element == null) {
            try {
                element = (Element)clazz.getConstructor(this.getClass()).newInstance(this);
            }
            catch (Exception e) {
                throw new JavieRuntimeException((Throwable)e);
            }
            this.childrenMap.put(clazz, element);
        }
        return (E)element;
    }

    private void prepareChildren() {
        this.children.clear();
        if (LayerNature.isTimeRemapEnabled((Layer)this.layer)) {
            this.children.add(this.getChildElement(TimeRemapElement.class));
        }
        if (this.layer instanceof TextLayer) {
            this.children.add(this.getChildElement(TextElement.class));
        }
        if (this.layer instanceof EffectableLayer) {
            this.children.add(this.getChildElement(EffectsElement.class));
        }
        if (this.layer instanceof TransformableLayer && LayerNature.isVideoNature((Layer)this.layer)) {
            this.children.add(this.getChildElement(TransformElement.class));
        } else if (this.layer instanceof LightLayer) {
            if (((LightLayer)this.layer).getLightType() != LightType.AMBIENT) {
                this.children.add(this.getChildElement(LightTransformElement.class));
            }
            this.children.add(this.getChildElement(LightOptionsElement.class));
        } else if (this.layer instanceof CameraLayer) {
            this.children.add(this.getChildElement(CameraTransformElement.class));
            this.children.add(this.getChildElement(CameraOptionsElement.class));
        }
        if (this.layer instanceof MediaLayer && LayerNature.isThreeD((Layer)this.layer)) {
            this.children.add(this.getChildElement(MaterialOptionsElement.class));
        }
        if (this.layer instanceof MediaLayer && LayerNature.isAudioNature((Layer)this.layer)) {
            this.children.add(this.getChildElement(AudioElement.class));
        }
        this.childrenMap.values().retainAll(this.children);
    }

    @Override
    public boolean hasChildren() {
        this.prepareChildren();
        return this.children.size() > 0;
    }

    @Override
    public Element[] getChildren() {
        this.prepareChildren();
        return this.children.toArray(new Element[this.children.size()]);
    }

    @Override
    public void paintColumn(Event event) {
        switch (event.index) {
            case 5: {
                this.showHideColumnSwitches.paint(event);
                break;
            }
            case 1: {
                this.switchesColumnSwitches.paint(event);
                break;
            }
            case 2: {
                if (!(this.layer instanceof MediaLayer)) break;
                this.modeArea = this.drawString(event, EnumLabels.getLabel(((MediaLayer)this.layer).getBlendMode()));
                break;
            }
            case 3: {
                if (this.layer instanceof MediaLayer && this.getTrackMatteLayer() != null) {
                    TrackMatte trackMatte = ((MediaLayer)this.layer).getTrackMatte();
                    this.trackMatteArea = this.drawString(event, trackMatte != TrackMatte.NONE ? EnumLabels.getLabel(trackMatte) : "      ");
                    break;
                }
                this.trackMatteArea = null;
                break;
            }
            case 4: {
                Layer parent = this.composition.getParentLayer(this.layer);
                String parentName = parent == null ? "      " : this.getName(parent);
                this.parentArea = this.drawString(event, parentName);
                break;
            }
            case 7: {
                TimelineManager tm = (TimelineManager)this.viewer.getData("TIMELINE_MANAGER");
                tm.drawLayer(event, this.layer);
                break;
            }
            default: {
                super.paintColumn(event);
            }
        }
    }

    private Rectangle drawString(Event event, String str) {
        GC gc = event.gc;
        int x = event.x + 5;
        int y = event.y;
        int height = ((TreeItem)event.item).getBounds((int)event.index).height;
        boolean focused = (event.detail & 2) != 0 && ((Control)event.widget).isFocusControl();
        gc.setForeground(gc.getDevice().getSystemColor(focused ? 1 : 10));
        Point extent = gc.textExtent(str, 1);
        gc.drawString(str, x, y += (height - extent.y) / 2, true);
        Rectangle area = new Rectangle(x, y, extent.x, extent.y);
        y += extent.y;
        gc.setLineDash(UNDERLINE_DASH);
        if (COCOA) {
            gc.drawLine(x, y - 1, x + extent.x, y - 1);
        } else if (WIN32) {
            gc.drawLine(x, y, x + extent.x - 2, y);
        } else {
            gc.drawLine(x, y, x + extent.x, y);
        }
        return area;
    }

    @Override
    public void updateCursor(MouseEvent event, int columnIndex) {
        Rectangle area;
        switch (columnIndex) {
            case 7: {
                TimelineManager tm = (TimelineManager)this.viewer.getData("TIMELINE_MANAGER");
                tm.updateCursor(event, this.layer);
                return;
            }
            default: {
                super.updateCursor(event, columnIndex);
                return;
            }
            case 2: {
                area = this.modeArea;
                break;
            }
            case 3: {
                area = this.trackMatteArea;
                break;
            }
            case 4: {
                area = this.parentArea;
            }
        }
        Cursor cursor = null;
        if (area != null && area.contains(event.x, event.y)) {
            cursor = event.display.getSystemCursor(21);
        }
        this.viewer.getTree().setCursor(cursor);
    }

    @Override
    public void mouseDown(MouseEvent event, int columnIndex) {
        switch (columnIndex) {
            case 5: {
                this.showHideColumnSwitches.mouseDown(event);
                break;
            }
            case 1: {
                this.switchesColumnSwitches.mouseDown(event);
                break;
            }
            case 2: {
                if (this.modeArea == null || !this.modeArea.contains(event.x, event.y)) break;
                this.showModeMenu();
                break;
            }
            case 3: {
                if (this.trackMatteArea == null || !this.trackMatteArea.contains(event.x, event.y)) break;
                this.showTrackMatteMenu();
                break;
            }
            case 4: {
                if (this.parentArea == null || !this.parentArea.contains(event.x, event.y)) break;
                this.showParentMenu();
                break;
            }
            case 7: {
                TimelineManager tm = (TimelineManager)this.viewer.getData("TIMELINE_MANAGER");
                tm.mouseDown(event, this.layer);
                break;
            }
            default: {
                super.mouseDown(event, columnIndex);
            }
        }
    }

    private Menu createPopUpMenu(Rectangle area) {
        return this.createPopUpMenu(area.x - 5, area.y + area.height + 2);
    }

    private void showModeMenu() {
        Menu menu = this.createPopUpMenu(this.modeArea);
        final BlendMode currentMode = ((MediaLayer)this.layer).getBlendMode();
        BlendMode[] blendModeArray = BlendMode.values();
        int n = blendModeArray.length;
        int n2 = 0;
        while (n2 < n) {
            final BlendMode mode = blendModeArray[n2];
            if (mode != BlendMode.NONE) {
                if (EnumLabels.insertSeparator(mode)) {
                    new MenuItem(menu, 2);
                }
                Action action = new Action(EnumLabels.getLabel(mode), 8){

                    public void run() {
                        if (currentMode != mode) {
                            ProjectManager pm = (ProjectManager)LayerElement.this.viewer.getData("PROJECT_MANAGER");
                            pm.postOperation(new ModifyLayerBlendModeOperation(pm, (MediaLayer)LayerElement.this.layer, mode));
                        }
                    }
                };
                action.setChecked(currentMode == mode);
                new ActionContributionItem((IAction)action).fill(menu, -1);
            }
            ++n2;
        }
        menu.setVisible(true);
    }

    private void showTrackMatteMenu() {
        Menu menu = this.createPopUpMenu(this.trackMatteArea);
        final TrackMatte current = ((MediaLayer)this.layer).getTrackMatte();
        TrackMatte[] trackMatteArray = TrackMatte.values();
        int n = trackMatteArray.length;
        int n2 = 0;
        while (n2 < n) {
            final TrackMatte tm = trackMatteArray[n2];
            if (EnumLabels.insertSeparator(tm)) {
                new MenuItem(menu, 2);
            }
            String label = tm == TrackMatte.NONE ? EnumLabels.getLabel(tm) : String.format("%s - %s", EnumLabels.getLabel(tm), this.getName((Layer)this.getTrackMatteLayer()));
            Action action = new Action(label.replaceAll("&", "&&"), 8){

                public void run() {
                    if (current != tm) {
                        ProjectManager pm = (ProjectManager)LayerElement.this.viewer.getData("PROJECT_MANAGER");
                        pm.postOperation(new ModifyLayerTrackMatteOperation(pm, (MediaLayer)LayerElement.this.layer, tm));
                    }
                }
            };
            action.setChecked(current == tm);
            new ActionContributionItem((IAction)action).fill(menu, -1);
            ++n2;
        }
        menu.setVisible(true);
    }

    private void showParentMenu() {
        Menu menu = this.createPopUpMenu(this.parentArea);
        final Layer currentParent = this.composition.getParentLayer(this.layer);
        Action action = new Action(this.getName(null), 8){

            public void run() {
                if (currentParent != null) {
                    ProjectManager pm = (ProjectManager)LayerElement.this.viewer.getData("PROJECT_MANAGER");
                    pm.postOperation(new ModifyLayerParentOperation(pm, LayerElement.this.layer, null));
                }
            }
        };
        action.setChecked(currentParent == null);
        new ActionContributionItem((IAction)action).fill(menu, -1);
        new MenuItem(menu, 2);
        for (final Layer otherLayer : this.composition.getLayers()) {
            action = new Action(this.getName(otherLayer).replaceAll("&", "&&"), 8){

                public void run() {
                    if (currentParent != otherLayer) {
                        ProjectManager pm = (ProjectManager)LayerElement.this.viewer.getData("PROJECT_MANAGER");
                        pm.postOperation(new ModifyLayerParentOperation(pm, LayerElement.this.layer, otherLayer));
                    }
                }
            };
            action.setEnabled(otherLayer != this.layer);
            action.setChecked(currentParent == otherLayer);
            new ActionContributionItem((IAction)action).fill(menu, 2);
        }
        menu.setVisible(true);
    }

    private String getName(Layer layer) {
        if (layer == null) {
            return "\u306a\u3057";
        }
        if (!(layer instanceof ItemLayer) || this.isLayerNameMode()) {
            return layer.getName();
        }
        return ((ItemLayer)layer).getItem().getName();
    }

    @Override
    public boolean canEdit(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return Boolean.TRUE.equals(this.viewer.getData("EDIT_ELEMENT_NAME"));
            }
        }
        return false;
    }

    @Override
    public CellEditor getCellEditor(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                if (this.nameEditor == null) {
                    this.nameEditor = new TextCellEditor((Composite)this.viewer.getTree(), 2052);
                    Control control = this.nameEditor.getControl();
                    control.setBackground(control.getDisplay().getSystemColor(1));
                }
                return this.nameEditor;
            }
        }
        return null;
    }

    @Override
    public Object getCellEditorValue(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.layer.getName();
            }
        }
        return null;
    }

    @Override
    public void setCellEditorValue(int columnIndex, Object value) {
        ProjectManager pm = (ProjectManager)this.viewer.getData("PROJECT_MANAGER");
        switch (columnIndex) {
            case 0: {
                String newName = (String)value;
                if (newName.length() == 0) {
                    if (this.layer instanceof ItemLayer) {
                        newName = ((ItemLayer)this.layer).getItem().getName();
                    } else if (this.layer instanceof TextLayer) {
                        newName = "\u30c6\u30ad\u30b9\u30c8";
                    } else if (this.layer instanceof NullLayer) {
                        newName = "\u30cc\u30eb";
                    } else if (this.layer instanceof CameraLayer) {
                        newName = "\u30ab\u30e1\u30e9";
                    } else if (this.layer instanceof LightLayer) {
                        newName = "\u30e9\u30a4\u30c8";
                    }
                }
                pm.postOperation(new RenameLayerOperation(pm, this.layer, newName));
            }
        }
    }
}

