/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.views.layercomp;

import ch.kuramo.javie.app.EnumLabels;
import ch.kuramo.javie.app.views.layercomp.AnimatableValueElement;
import ch.kuramo.javie.app.views.layercomp.AnimatableValueElementDelegate;
import ch.kuramo.javie.core.AnimatableEnum;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnimatableEnumElementDelegate<E extends Enum<E>>
extends AnimatableValueElementDelegate<E> {
    private final Class<E> enumType;

    public AnimatableEnumElementDelegate(AnimatableValueElement element, String name, AnimatableEnum<E> avalue) {
        super(element, name, avalue);
        this.enumType = avalue.getEnumType();
    }

    @Override
    protected void drawValue(GC gc, int x, int y, int height, boolean focused) {
        this.drawValue(gc, x, y, height, focused, EnumLabels.getLabel((Enum)this.value));
    }

    @Override
    protected boolean canDragGestureEdit() {
        return false;
    }

    @Override
    protected E dragGesture(double dx, double dy) {
        throw new UnsupportedOperationException("drag gesture edit is not supported");
    }

    @Override
    protected void openInPlaceEditor() {
        this.createMenu().setVisible(true);
    }

    protected Menu createMenu() {
        Rectangle r = (Rectangle)this.valueArea.get(this.valueIndex);
        Menu menu = this.element.createPopUpMenu(r.x - 5, r.y + r.height + 2);
        Enum[] enumArray = (Enum[])this.enumType.getEnumConstants();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            final Enum e = enumArray[n2];
            if (EnumLabels.insertSeparator(e)) {
                new MenuItem(menu, 2);
            }
            Action action = new Action(EnumLabels.getLabel(e).replaceAll("&", "&&"), 8){

                public void run() {
                    if (e != AnimatableEnumElementDelegate.this.value) {
                        AnimatableEnumElementDelegate.this.modifyValue(e);
                    }
                }
            };
            action.setChecked(e == this.value);
            ActionContributionItem item = new ActionContributionItem((IAction)action);
            item.fill(menu, -1);
            item.getWidget().setData((Object)e);
            ++n2;
        }
        return menu;
    }
}

