/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.project;

import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.project.ProjectOperation;
import ch.kuramo.javie.core.Effect;
import ch.kuramo.javie.core.EffectableLayer;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.Project;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class RenameEffectOperation
extends ProjectOperation {
    private final String _compId;
    private final String _layerId;
    private final int _effectIndex;
    private final String _oldName;
    private final String _newName;

    public RenameEffectOperation(ProjectManager pm, EffectableLayer layer, Effect effect, String newName) {
        super(pm, "\u30a8\u30d5\u30a7\u30af\u30c8\u540d\u306e\u5909\u66f4");
        LayerComposition comp = pm.checkLayer((Layer)layer);
        int index = layer.getEffects().indexOf(effect);
        if (index == -1) {
            throw new IllegalArgumentException("no such effect found in the layer");
        }
        this._compId = comp.getId();
        this._layerId = layer.getId();
        this._effectIndex = index;
        this._oldName = effect.getName();
        this._newName = newName;
        this._noEffect = newName.equals(this._oldName);
    }

    protected IStatus executeOrRedo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        this.setEffectName(this._newName, project, pm);
        return Status.OK_STATUS;
    }

    protected IStatus undo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        this.setEffectName(this._oldName, project, pm);
        return Status.OK_STATUS;
    }

    private void setEffectName(String name, Project project, ProjectManager pm) {
        LayerComposition comp = (LayerComposition)project.getComposition(this._compId);
        EffectableLayer layer = (EffectableLayer)comp.getLayer(this._layerId);
        Effect effect = (Effect)layer.getEffects().get(this._effectIndex);
        effect.setName(name);
        if (pm != null) {
            pm.fireEffectPropertyChange(layer, this._effectIndex, "name");
        }
    }
}

