/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.project;

import ch.kuramo.javie.api.Color;
import ch.kuramo.javie.api.Size2i;
import ch.kuramo.javie.app.InjectorHolder;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.project.ProjectOperation;
import ch.kuramo.javie.core.Folder;
import ch.kuramo.javie.core.Item;
import ch.kuramo.javie.core.Project;
import ch.kuramo.javie.core.ProjectDecodeException;
import ch.kuramo.javie.core.SolidColorItem;
import ch.kuramo.javie.core.services.ProjectDecoder;
import ch.kuramo.javie.core.services.ProjectElementFactory;
import ch.kuramo.javie.core.services.ProjectEncoder;
import com.google.inject.Inject;
import java.util.Collections;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class NewSolidColorItemOperation
extends ProjectOperation {
    private final String _itemId;
    private final String _data;
    @Inject
    private ProjectElementFactory _elementFactory;
    @Inject
    private ProjectEncoder _encoder;
    @Inject
    private ProjectDecoder _decoder;

    public NewSolidColorItemOperation(ProjectManager projectManager, Folder parent, String name, int width, int height, Color color) {
        super(projectManager, "\u65b0\u898f\u5e73\u9762");
        projectManager.checkItem((Item)parent);
        InjectorHolder.getInjector().injectMembers((Object)this);
        SolidColorItem item = this._elementFactory.newSolidColorItem(color, new Size2i(width, height));
        item.setName(name);
        item.setParent(parent);
        this._itemId = item.getId();
        this._data = this._encoder.encodeElement((Object)item);
    }

    protected IStatus executeOrRedo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        SolidColorItem item = null;
        try {
            item = (SolidColorItem)this._decoder.decodeElement((CharSequence)this._data, SolidColorItem.class);
            item.afterDecode(project);
        }
        catch (ProjectDecodeException e) {
            if (item != null) {
                item.dispose();
            }
            throw new ExecutionException("error decoding SolidColorItem data", (Throwable)e);
        }
        project.getItems().add(item);
        if (pm != null) {
            this.fireItemsAdd((Item)item, pm);
        }
        return Status.OK_STATUS;
    }

    protected IStatus undo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        Item item = project.getItem(this._itemId);
        project.getItems().remove(item);
        if (pm != null) {
            this.fireItemsRemove(item, pm);
        }
        item.dispose();
        return Status.OK_STATUS;
    }

    private void fireItemsAdd(Item item, ProjectManager pm) {
        Folder parent = item.getParent();
        if (parent != null) {
            pm.fireItemsAdd(Collections.singleton(item), Collections.singleton(parent));
        } else {
            pm.fireItemsAdd(Collections.singleton(item), null);
        }
    }

    private void fireItemsRemove(Item item, ProjectManager pm) {
        Folder parent = item.getParent();
        if (parent != null) {
            pm.fireItemsRemove(Collections.singleton(item), Collections.singleton(parent));
        } else {
            pm.fireItemsRemove(Collections.singleton(item), null);
        }
    }
}

