/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.project;

import ch.kuramo.javie.app.InjectorHolder;
import ch.kuramo.javie.app.PropertyUtil;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.project.ProjectOperation;
import ch.kuramo.javie.core.AnimatableLayerReference;
import ch.kuramo.javie.core.Effect;
import ch.kuramo.javie.core.EffectableLayer;
import ch.kuramo.javie.core.Keyframe;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.Project;
import ch.kuramo.javie.core.ProjectDecodeException;
import ch.kuramo.javie.core.PropertyDescriptor;
import ch.kuramo.javie.core.Util;
import ch.kuramo.javie.core.services.ProjectDecoder;
import com.google.inject.Inject;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NewLayersForPrecomposeOperation
extends ProjectOperation {
    private final String newCompId;
    private final List<String> data;
    private final Map<String, String> idMap;
    @Inject
    private ProjectDecoder decoder;

    public NewLayersForPrecomposeOperation(ProjectManager pm, String newCompId, List<String> data, Map<String, String> idMap) {
        super(pm, "NewLayersForPrecomposeOperation", true);
        InjectorHolder.getInjector().injectMembers((Object)this);
        this.newCompId = newCompId;
        this.data = data;
        this.idMap = idMap;
    }

    @Override
    protected IStatus executeOrRedo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        LayerComposition newComp = (LayerComposition)project.getComposition(this.newCompId);
        List newLayers = Util.newList();
        try {
            for (String d : this.data) {
                Layer layer = (Layer)this.decoder.decodeElement((CharSequence)d, Layer.class);
                this.setNewId(layer);
                newLayers.add(layer);
            }
            for (Layer layer : newLayers) {
                layer.afterDecode(project, newComp);
            }
        }
        catch (ProjectDecodeException e) {
            throw new ExecutionException("error decoding layer data", (Throwable)e);
        }
        newComp.getLayers().addAll(newLayers);
        if (pm != null) {
            pm.fireLayersAdd(newComp, newLayers);
        }
        return Status.OK_STATUS;
    }

    @Override
    protected IStatus undo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        LayerComposition newComp = (LayerComposition)project.getComposition(this.newCompId);
        List removedLayers = Util.newList();
        for (String id : this.idMap.values()) {
            removedLayers.add(newComp.getLayer(id));
        }
        newComp.getLayers().removeAll(removedLayers);
        if (pm != null) {
            pm.fireLayersRemove(newComp, removedLayers);
        }
        return Status.OK_STATUS;
    }

    private void setNewId(Layer layer) {
        String newId = this.idMap.get(layer.getId());
        PropertyUtil.setProperty(layer, "id", newId);
        layer.setParentId(this.idMap.get(layer.getParentId()));
        if (layer instanceof EffectableLayer) {
            for (Effect e : ((EffectableLayer)layer).getEffects()) {
                for (PropertyDescriptor pd : e.getEffectDescriptor().getPropertyDescriptors()) {
                    if (!AnimatableLayerReference.class.isAssignableFrom(pd.getPropertyClass())) continue;
                    AnimatableLayerReference alr = (AnimatableLayerReference)pd.get(e);
                    if (alr.hasKeyframe()) {
                        for (Keyframe kf : alr.getKeyframeMap().values()) {
                            String refId = this.idMap.get(kf.value);
                            alr.putKeyframe(kf.time, (Object)(refId != null ? refId : ""), kf.interpolation);
                        }
                        continue;
                    }
                    String refId = this.idMap.get(alr.getStaticValue());
                    alr.clearKeyframes((Object)(refId != null ? refId : ""));
                }
            }
        }
    }
}

