/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.project;

import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.app.InjectorHolder;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.project.ProjectOperation;
import ch.kuramo.javie.core.Folder;
import ch.kuramo.javie.core.ImageSequenceItem;
import ch.kuramo.javie.core.Item;
import ch.kuramo.javie.core.Project;
import ch.kuramo.javie.core.ProjectDecodeException;
import ch.kuramo.javie.core.services.ProjectDecoder;
import ch.kuramo.javie.core.services.ProjectElementFactory;
import ch.kuramo.javie.core.services.ProjectEncoder;
import com.google.inject.Inject;
import java.io.File;
import java.util.Collections;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class NewImageSequenceOperation
extends ProjectOperation {
    private final String _itemId;
    private final String _data;
    @Inject
    private ProjectElementFactory _elementFactory;
    @Inject
    private ProjectEncoder _encoder;
    @Inject
    private ProjectDecoder _decoder;

    public NewImageSequenceOperation(ProjectManager pm, Folder parent, File file, Time frameDuration) {
        super(pm, "\u30a4\u30e1\u30fc\u30b8\u30b7\u30fc\u30b1\u30f3\u30b9\u306e\u8aad\u307f\u8fbc\u307f");
        pm.checkItem((Item)parent);
        InjectorHolder.getInjector().injectMembers((Object)this);
        ImageSequenceItem item = this._elementFactory.newImageSequenceItem(file, frameDuration);
        item.setParent(parent);
        this._itemId = item.getId();
        this._data = this._encoder.encodeElement((Object)item);
    }

    protected IStatus executeOrRedo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        ImageSequenceItem item = null;
        try {
            item = (ImageSequenceItem)this._decoder.decodeElement((CharSequence)this._data, ImageSequenceItem.class);
            item.afterDecode(project);
        }
        catch (ProjectDecodeException e) {
            if (item != null) {
                item.dispose();
            }
            throw new ExecutionException("error decoding ImageSequenceItem data", (Throwable)e);
        }
        project.getItems().add(item);
        if (pm != null) {
            this.fireItemsAdd((Item)item, pm);
        }
        return Status.OK_STATUS;
    }

    protected IStatus undo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        Item item = project.getItem(this._itemId);
        project.getItems().remove(item);
        if (pm != null) {
            this.fireItemsRemove(item, pm);
        }
        item.dispose();
        return Status.OK_STATUS;
    }

    private void fireItemsAdd(Item item, ProjectManager pm) {
        Folder parent = item.getParent();
        if (parent != null) {
            pm.fireItemsAdd(Collections.singleton(item), Collections.singleton(parent));
        } else {
            pm.fireItemsAdd(Collections.singleton(item), null);
        }
    }

    private void fireItemsRemove(Item item, ProjectManager pm) {
        Folder parent = item.getParent();
        if (parent != null) {
            pm.fireItemsRemove(Collections.singleton(item), Collections.singleton(parent));
        } else {
            pm.fireItemsRemove(Collections.singleton(item), null);
        }
    }
}

