/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.project;

import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.project.ProjectOperation;
import ch.kuramo.javie.core.Composition;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.Project;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class LayerCompShyOperation
extends ProjectOperation {
    private final String _compId;
    private final boolean _oldValue;

    public LayerCompShyOperation(ProjectManager pm, LayerComposition comp, boolean enabled) {
        super(pm, "\u30b7\u30e3\u30a4\u306e\u6709\u52b9\uff0f\u7121\u52b9\u3092\u5909\u66f4");
        pm.checkComposition((Composition)comp);
        this._compId = comp.getId();
        this._oldValue = comp.isShyEnabled();
        this._noEffect = this._oldValue == enabled;
    }

    protected IStatus executeOrRedo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        this.setShyEnabled(project, pm, !this._oldValue);
        return Status.OK_STATUS;
    }

    protected IStatus undo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        this.setShyEnabled(project, pm, this._oldValue);
        return Status.OK_STATUS;
    }

    private void setShyEnabled(Project project, ProjectManager pm, boolean enabled) {
        LayerComposition comp = (LayerComposition)project.getComposition(this._compId);
        comp.setShyEnabled(enabled);
        if (pm != null) {
            pm.fireCompositionPropertyChange((Composition)comp, "shyEnabled");
        }
    }
}

