/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.player;

import ch.kuramo.javie.api.Resolution;
import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.app.Activator;
import ch.kuramo.javie.app.IntervalTask;
import ch.kuramo.javie.app.player.AudioThread;
import ch.kuramo.javie.app.player.PlayerLinkEvent;
import ch.kuramo.javie.app.player.PlayerLinkListener;
import ch.kuramo.javie.app.player.PlayerThreadEvent;
import ch.kuramo.javie.app.player.PlayerThreadListener;
import ch.kuramo.javie.app.player.TimeKeeper;
import ch.kuramo.javie.app.player.VideoCanvas;
import ch.kuramo.javie.app.project.ProjectEvent;
import ch.kuramo.javie.app.project.ProjectEventHub;
import ch.kuramo.javie.app.project.ProjectListener;
import ch.kuramo.javie.core.CompositionItem;
import ch.kuramo.javie.core.MediaInput;
import ch.kuramo.javie.core.MediaItem;
import ch.kuramo.javie.core.Project;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MediaPlayer
extends Composite
implements PlayerThreadListener,
PlayerLinkListener,
ProjectListener {
    private static final Logger _logger = LoggerFactory.getLogger(MediaPlayer.class);
    private static final Image IMG_PLAYER_PLAY;
    private static final Image IMG_PLAYER_PAUSE;
    private static final Image IMG_PLAYER_HEAD;
    private static final Image IMG_PLAYER_PREV;
    private static final Image IMG_PLAYER_NEXT;
    private static final Image IMG_PLAYER_LAST;
    private Scale _scale;
    private Button _playButton;
    private MediaItem _mediaItem;
    private TimeKeeper _timeKeeper;
    private AudioThread _audioThread;
    private VideoCanvas _videoCanvas;
    private Time _duration;
    private Time _frameDuration;
    private boolean _scrubbing;
    private boolean _audioScrubEnabled = true;
    private volatile boolean _hidden = true;
    private volatile boolean _dirty;
    private final IntervalTask _scaleUpdateTask = new IntervalTask(this.getDisplay(), 100){

        public void run() {
            MediaPlayer.this.updateScale();
        }
    };
    private final ListenerList _playerLinkListeners = new ListenerList();

    static {
        ImageRegistry reg = Activator.getDefault().getImageRegistry();
        IMG_PLAYER_PLAY = reg.get("IMG_PLAYER_PLAY");
        IMG_PLAYER_PAUSE = reg.get("IMG_PLAYER_PAUSE");
        IMG_PLAYER_HEAD = reg.get("IMG_PLAYER_HEAD");
        IMG_PLAYER_PREV = reg.get("IMG_PLAYER_PREV");
        IMG_PLAYER_NEXT = reg.get("IMG_PLAYER_NEXT");
        IMG_PLAYER_LAST = reg.get("IMG_PLAYER_LAST");
    }

    public MediaPlayer(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FormLayout());
        this.createControls();
    }

    private void createControls() {
        this._scale = new Scale((Composite)this, 256);
        Button headButton = new Button((Composite)this, 0x800008);
        headButton.setImage(IMG_PLAYER_HEAD);
        Button prevButton = new Button((Composite)this, 0x800008);
        prevButton.setImage(IMG_PLAYER_PREV);
        this._playButton = new Button((Composite)this, 0x800008);
        this._playButton.setImage(IMG_PLAYER_PLAY);
        Button nextButton = new Button((Composite)this, 0x800008);
        nextButton.setImage(IMG_PLAYER_NEXT);
        Button lastButton = new Button((Composite)this, 0x800008);
        lastButton.setImage(IMG_PLAYER_LAST);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 5);
        data.right = new FormAttachment(100, -5);
        data.top = new FormAttachment((Control)this._playButton, -30, 128);
        data.bottom = new FormAttachment((Control)this._playButton, 0, 128);
        this._scale.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)this._scale, 0, 0x1000000);
        data.right = new FormAttachment((Control)this._scale, 0, 0x1000000);
        data.top = new FormAttachment(100, -30);
        data.bottom = new FormAttachment(100, -5);
        this._playButton.setLayoutData((Object)data);
        data = new FormData();
        data.right = new FormAttachment((Control)this._playButton, 0, 16384);
        data.top = new FormAttachment((Control)this._playButton, 0, 128);
        data.bottom = new FormAttachment((Control)this._playButton, 0, 1024);
        prevButton.setLayoutData((Object)data);
        data = new FormData();
        data.right = new FormAttachment((Control)prevButton, 0, 16384);
        data.top = new FormAttachment((Control)this._playButton, 0, 128);
        data.bottom = new FormAttachment((Control)this._playButton, 0, 1024);
        headButton.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)this._playButton, 0, 131072);
        data.top = new FormAttachment((Control)this._playButton, 0, 128);
        data.bottom = new FormAttachment((Control)this._playButton, 0, 1024);
        nextButton.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)nextButton, 0, 131072);
        data.top = new FormAttachment((Control)this._playButton, 0, 128);
        data.bottom = new FormAttachment((Control)this._playButton, 0, 1024);
        lastButton.setLayoutData((Object)data);
        this._playButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MediaPlayer.this._timeKeeper != null) {
                    if (MediaPlayer.this._timeKeeper.isPaused()) {
                        MediaPlayer.this.resume();
                    } else {
                        MediaPlayer.this.pause();
                    }
                }
            }
        });
        headButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MediaPlayer.this.setFrameNumber(0);
            }
        });
        prevButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MediaPlayer.this.setFrameNumber(MediaPlayer.this._scale.getSelection() - 1);
            }
        });
        nextButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MediaPlayer.this.setFrameNumber(MediaPlayer.this._scale.getSelection() + 1);
            }
        });
        lastButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MediaPlayer.this.setFrameNumber(MediaPlayer.this._scale.getMaximum());
            }
        });
    }

    public void close() {
        if (this._audioThread != null) {
            this._audioThread.finish();
        }
        if (this._videoCanvas != null) {
            this._videoCanvas.finish();
        }
        if (this._timeKeeper != null) {
            this._timeKeeper.pause();
        }
        ProjectEventHub.getHub().removeProjectListener(this);
    }

    public void setMediaItem(MediaItem mediaItem) {
        if (this._mediaItem != null) {
            throw new IllegalStateException("MediaItem is already set");
        }
        MediaInput input = mediaItem.getMediaInput();
        if (input == null) {
            throw new IllegalArgumentException("no MediaInput is available");
        }
        this._mediaItem = mediaItem;
        if (input.isAudioAvailable()) {
            try {
                this._audioThread = new AudioThread(this._mediaItem);
            }
            catch (Exception e) {
                _logger.warn("error creating AudioThread", (Throwable)e);
            }
        }
        TimeKeeper timeKeeper = this._timeKeeper = this._audioThread != null ? this._audioThread.getTimeKeeper() : TimeKeeper.fromSystemTime();
        if (input.isVideoAvailable()) {
            this._videoCanvas = new VideoCanvas(this, this._mediaItem, this._timeKeeper);
            FormData data = new FormData();
            data.left = new FormAttachment(0, 0);
            data.right = new FormAttachment(100, 0);
            data.top = new FormAttachment(0, 0);
            data.bottom = new FormAttachment((Control)this._scale, 0, 128);
            Control control = this._videoCanvas.getControl();
            control.setLayoutData((Object)data);
            this.layout(new Control[]{control});
            this._videoCanvas.addPlayerThreadListener(this);
        } else if (this._audioThread != null) {
            this._audioThread.addPlayerThreadListener(this);
        }
        this._duration = input.getDuration();
        if (this._duration != null) {
            this._frameDuration = input.isVideoAvailable() && input.getVideoFrameDuration().timeValue > 0L ? input.getVideoFrameDuration() : new Time(1L, 48000);
            int nFrames = (int)this._duration.toFrameNumber(this._frameDuration);
            this._scale.setMaximum(nFrames - 1);
            this._scale.setIncrement(1);
            this._scale.setPageIncrement(nFrames / 10);
            this._scale.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (!MediaPlayer.this._timeKeeper.isPaused()) {
                        MediaPlayer.this._scrubbing = true;
                        MediaPlayer.this.pause();
                    }
                    MediaPlayer.this.setFrameNumber(MediaPlayer.this._scale.getSelection());
                }
            });
            this._scale.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    if (MediaPlayer.this._scrubbing) {
                        MediaPlayer.this._scrubbing = false;
                        MediaPlayer.this.resume();
                    }
                }
            });
            this._scale.addKeyListener((KeyListener)new KeyAdapter(){
                private boolean keyScrubbing;

                public void keyPressed(KeyEvent e) {
                    switch (e.keyCode) {
                        case 0x1000001: 
                        case 0x1000002: 
                        case 0x1000003: 
                        case 0x1000004: {
                            if (MediaPlayer.this._scrubbing || MediaPlayer.this._timeKeeper.isPaused()) break;
                            this.keyScrubbing = true;
                            break;
                        }
                        default: {
                            e.doit = false;
                        }
                    }
                }

                public void keyReleased(KeyEvent e) {
                    if (MediaPlayer.this._scrubbing && this.keyScrubbing) {
                        MediaPlayer.this._scrubbing = false;
                        this.keyScrubbing = false;
                        MediaPlayer.this.resume();
                    }
                }
            });
            this._scale.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    if (MediaPlayer.this._scrubbing) {
                        MediaPlayer.this._scrubbing = false;
                        MediaPlayer.this.resume();
                    }
                }
            });
        }
        if (this._mediaItem instanceof CompositionItem) {
            ProjectEventHub.getHub().addProjectListener(this);
        }
        if (this._videoCanvas != null) {
            this._videoCanvas.start();
        }
        if (this._audioThread != null) {
            this._audioThread.start();
        }
    }

    private void setFrameNumber(int frameNumber) {
        if (this._timeKeeper == null || this._frameDuration == null) {
            return;
        }
        frameNumber = Math.max(0, Math.min(this._scale.getMaximum(), frameNumber));
        this._scale.setSelection(frameNumber);
        Time time = Time.fromFrameNumber((long)frameNumber, (Time)this._frameDuration);
        this._timeKeeper.setTime(time);
        if (this._audioThread != null) {
            if (!this._timeKeeper.isPaused()) {
                this._audioThread.setTime(time);
            } else if (this._audioScrubEnabled) {
                this._audioThread.scrub(time);
            }
        }
        if (this._videoCanvas != null && this._timeKeeper.isPaused()) {
            this._videoCanvas.forceRender();
        }
    }

    private void updateScale() {
        if (!this._scale.isDisposed() && this._frameDuration != null) {
            Time time = this._timeKeeper.getTime();
            this._scale.setSelection((int)time.toFrameNumber(this._frameDuration));
        }
    }

    public void threadRender(PlayerThreadEvent event) {
        this._scaleUpdateTask.schedule();
        this.notifyPlayerTime(event.time);
    }

    public void threadEndOfDuration(PlayerThreadEvent event) {
        this.getDisplay().asyncExec(new Runnable(){

            public void run() {
                MediaPlayer.this.pause();
            }
        });
    }

    private void resume() {
        this._timeKeeper.resume(null);
        if (this._audioThread != null) {
            this._audioThread.setTime(this._timeKeeper.getTime());
            this._audioThread.play(true);
        }
        if (this._videoCanvas != null) {
            this._videoCanvas.play(true);
        }
        this._playButton.setImage(IMG_PLAYER_PAUSE);
    }

    private void pause() {
        if (this._audioThread != null) {
            this._audioThread.play(false);
        }
        if (this._videoCanvas != null) {
            this._videoCanvas.play(false);
        }
        this._timeKeeper.pause();
        if (this._duration != null) {
            Time maxTime = this._duration.subtract(this._frameDuration);
            if (this._timeKeeper.getTime().after(maxTime)) {
                this._timeKeeper.setTime(maxTime);
            }
        }
        if (this._videoCanvas != null) {
            this._videoCanvas.forceRender();
        }
        if (!this._playButton.isDisposed()) {
            this._playButton.setImage(IMG_PLAYER_PLAY);
        }
    }

    public boolean hasVideo() {
        return this._videoCanvas != null;
    }

    public boolean hasAudio() {
        return this._audioThread != null;
    }

    public Resolution getVideoResolution() {
        return this._videoCanvas != null ? this._videoCanvas.getResolution() : null;
    }

    public void setVideoResolution(Resolution resolution) {
        if (this._videoCanvas != null) {
            this._videoCanvas.setResolution(resolution);
        }
    }

    public double getVideoZoom() {
        return this._videoCanvas != null ? this._videoCanvas.getZoom() : 0.0;
    }

    public void setVideoZoom(double zoom) {
        if (this._videoCanvas != null) {
            this._videoCanvas.setZoom(zoom);
        }
    }

    public boolean isAudioMuted() {
        return this._audioThread != null ? this._audioThread.isMuted() : false;
    }

    public void setAudioMuted(boolean mute) {
        if (this._audioThread != null) {
            this._audioThread.setMuted(mute);
        }
    }

    public boolean isAudioScrubEnabled() {
        return this._audioScrubEnabled;
    }

    public void setAudioScrubEnabled(boolean audioScrubEnabled) {
        this._audioScrubEnabled = audioScrubEnabled;
    }

    public boolean isShowInfo() {
        return this._videoCanvas != null ? this._videoCanvas.isShowInfo() : false;
    }

    public void setShowInfo(boolean showInfo) {
        if (this._videoCanvas != null) {
            this._videoCanvas.setShowInfo(showInfo);
        }
    }

    public void setHidden(boolean hidden) {
        if (this._hidden != hidden) {
            this._hidden = hidden;
            if (hidden && !this._timeKeeper.isPaused()) {
                this.pause();
            } else if (!hidden && this._dirty) {
                this._dirty = false;
                if (this._videoCanvas != null) {
                    this._videoCanvas.forceRender();
                }
            }
        }
    }

    public void addPlayerLinkListener(PlayerLinkListener listener) {
        this._playerLinkListeners.add((Object)listener);
    }

    public void removePlayerLinkListener(PlayerLinkListener listener) {
        this._playerLinkListeners.remove((Object)listener);
    }

    private void notifyPlayerTime(Time time) {
        PlayerLinkEvent event = new PlayerLinkEvent(this, time);
        Object[] objectArray = this._playerLinkListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object l = objectArray[n2];
            ((PlayerLinkListener)l).handlePlayerLinkEvent(event);
            ++n2;
        }
    }

    public void handlePlayerLinkEvent(PlayerLinkEvent event) {
        Time time = event.time;
        if (this._hidden) {
            this._timeKeeper.setTime(time);
            this.notifyPlayerTime(time);
            this._dirty = true;
        } else {
            if (event.isScrubbing()) {
                if (!this._timeKeeper.isPaused()) {
                    this._scrubbing = true;
                    this.pause();
                }
            } else if (event.isEndScrubbing()) {
                if (this._scrubbing) {
                    this._scrubbing = false;
                    this.resume();
                }
            } else if (this._scrubbing) {
                _logger.warn("event is neither scrubbing nor endScrubbing, but scrubbing flag of player is true.");
                this._scrubbing = false;
            }
            Time oldTime = this._timeKeeper.getTime();
            this._timeKeeper.setTime(time);
            if (this._audioThread != null) {
                if (!this._timeKeeper.isPaused()) {
                    this._audioThread.setTime(time);
                } else if (this._audioScrubEnabled && !time.equals((Object)oldTime)) {
                    this._audioThread.scrub(time);
                }
            }
            if (this._videoCanvas != null && this._timeKeeper.isPaused()) {
                this._videoCanvas.forceRender();
            }
        }
    }

    public void handleProjectEvent(ProjectEvent event) {
        switch (event.type) {
            case ITEM_UPDATE: 
            case COMPOSITION_SETTINGS_CHANGE: 
            case COMPOSITION_PROPERTY_CHANGE: 
            case LAYER_PROPERTY_CHANGE: 
            case LAYER_ITEM_CHANGE: 
            case LAYERS_ADD: 
            case LAYERS_REMOVE: 
            case LAYERS_REORDER: 
            case TEXT_ANIMATORS_ADD: 
            case TEXT_ANIMATORS_REMOVE: 
            case TA_SELECTORS_ADD: 
            case TA_SELECTORS_REMOVE: 
            case TA_PROPERTIES_ADD: 
            case TA_PROPERTIES_REMOVE: 
            case EFFECT_PROPERTY_CHANGE: 
            case EFFECTS_ADD: 
            case EFFECTS_REMOVE: 
            case LAYER_EXPRESSION_CHANGE: 
            case EFFECT_EXPRESSION_CHANGE: 
            case LAYER_TIMES_CHANGE: 
            case KEYFRAMES_CHANGE: 
            case LAYER_SLIP_EDIT: {
                if (!this.isSameProject(event.getProjectManager().getProject())) break;
                this._dirty = true;
                break;
            }
            case SHADOW_OPERATION_EXECUTION: {
                if (!this.isSameProject(event.getProjectManager().getShadow()) || this._hidden || !this._dirty) break;
                this._dirty = false;
                if (this._videoCanvas == null || !this._timeKeeper.isPaused()) break;
                this._videoCanvas.forceRender();
            }
        }
    }

    private boolean isSameProject(Project project) {
        String compId = ((CompositionItem)this._mediaItem).getComposition().getId();
        return project != null && project.getComposition(compId) != null;
    }
}

