/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app;

import ch.kuramo.javie.core.JavieRuntimeException;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.TASelector;
import ch.kuramo.javie.core.TextAnimator;
import ch.kuramo.javie.core.TextLayer;
import ch.kuramo.javie.core.Util;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyUtil {
    public static Collection<String> getPropertyNames(Object object) {
        List names = Util.newList();
        Class<?> clazz = object.getClass();
        Method[] methodArray = clazz.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            String name = m.getName();
            boolean is = name.startsWith("is");
            if ((is || name.startsWith("get")) && m.getParameterTypes().length == 0 && (!is || m.getReturnType().equals(Boolean.TYPE))) {
                name = name.substring(is ? 2 : 3);
                name = String.valueOf(Character.toLowerCase(name.charAt(0))) + name.substring(1);
                names.add(name);
            }
            ++n2;
        }
        return names;
    }

    public static Collection<String> getLayerPropertyNames(Layer layer) {
        return layer instanceof TextLayer ? PropertyUtil.getTextLayerPropertyNames((TextLayer)layer) : PropertyUtil.getPropertyNames(layer);
    }

    public static Collection<String> getTextLayerPropertyNames(TextLayer layer) {
        List names = Util.newList();
        List animators = layer.getTextAnimators();
        ListIterator it1 = animators.listIterator();
        while (it1.hasNext()) {
            int i = it1.nextIndex();
            TextAnimator animator = (TextAnimator)it1.next();
            List selectors = animator.getSelectors();
            ListIterator it2 = selectors.listIterator();
            while (it2.hasNext()) {
                int j = it2.nextIndex();
                TASelector selector = (TASelector)it2.next();
                for (String p : PropertyUtil.getPropertyNames(selector)) {
                    names.add(String.format("textAnimators[%d].selectors[%d].%s", i, j, p));
                }
            }
            for (String p : PropertyUtil.getPropertyNames(animator)) {
                if (p.equals("selectors")) continue;
                names.add(String.format("textAnimators[%d].%s", i, p));
            }
        }
        for (String p : PropertyUtil.getPropertyNames(layer)) {
            if (p.equals("textAnimators")) continue;
            names.add(p);
        }
        return names;
    }

    public static <T> T getProperty(Object object, String property) {
        String p;
        int index2;
        int index = property.indexOf(46);
        if (index != -1) {
            String p0 = property.substring(0, index);
            String p1 = property.substring(index + 1);
            return PropertyUtil.getProperty(PropertyUtil.getProperty(object, p0), p1);
        }
        index = property.indexOf(91);
        if (index != -1 && (index2 = property.indexOf(93, index + 1)) != -1) {
            p = property.substring(0, index);
            int n = Integer.parseInt(property.substring(index + 1, index2));
            T listOrArray = PropertyUtil.getProperty(object, p);
            if (listOrArray instanceof List) {
                Object value = ((List)listOrArray).get(n);
                return (T)value;
            }
            if (listOrArray.getClass().isArray()) {
                Object value = Array.get(listOrArray, n);
                return (T)value;
            }
        }
        if ((index = property.indexOf(40)) != -1 && (index2 = property.indexOf(41, index + 1)) != -1) {
            p = property.substring(0, index);
            String key = property.substring(index + 1, index2);
            Map map = (Map)PropertyUtil.getProperty(object, p);
            return (T)map.get(key);
        }
        Class<?> clazz = object.getClass();
        String upperCamelCase = String.valueOf(Character.toUpperCase(property.charAt(0))) + property.substring(1);
        Method method = null;
        try {
            method = clazz.getMethod("get" + upperCamelCase, new Class[0]);
            if (method.getReturnType().equals(Void.TYPE)) {
                method = null;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        if (method == null) {
            try {
                method = clazz.getMethod("is" + upperCamelCase, new Class[0]);
                if (!method.getReturnType().equals(Boolean.TYPE)) {
                    method = null;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format("no such property found: class=%s, property=%s", clazz.getName(), property));
        }
        try {
            Object value = method.invoke(object, new Object[0]);
            return (T)value;
        }
        catch (IllegalAccessException e) {
            throw new JavieRuntimeException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new JavieRuntimeException((Throwable)e);
        }
    }

    public static <T> void setProperty(Object object, String property, T newValue) {
        String p;
        int index2;
        int index = property.indexOf(46);
        if (index != -1) {
            String p0 = property.substring(0, index);
            String p1 = property.substring(index + 1);
            PropertyUtil.setProperty(PropertyUtil.getProperty(object, p0), p1, newValue);
            return;
        }
        index = property.indexOf(91);
        if (index != -1 && (index2 = property.indexOf(93, index + 1)) != -1) {
            p = property.substring(0, index);
            int n = Integer.parseInt(property.substring(index + 1, index2));
            T listOrArray = PropertyUtil.getProperty(object, p);
            if (listOrArray instanceof List) {
                List list = (List)listOrArray;
                list.set(n, newValue);
                return;
            }
            if (listOrArray.getClass().isArray()) {
                Array.set(listOrArray, n, newValue);
                return;
            }
        }
        if ((index = property.indexOf(40)) != -1 && (index2 = property.indexOf(41, index + 1)) != -1) {
            p = property.substring(0, index);
            String key = property.substring(index + 1, index2);
            Map map = (Map)PropertyUtil.getProperty(object, p);
            map.put(key, newValue);
            return;
        }
        Class<?> clazz = object.getClass();
        String methodName = "set" + Character.toUpperCase(property.charAt(0)) + property.substring(1);
        Method method = null;
        Method[] methodArray = clazz.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> paramType;
            Method m = methodArray[n2];
            if (m.getName().equals(methodName) && m.getParameterTypes().length == 1 && m.getReturnType().equals(Void.TYPE) && (paramType = PropertyUtil.toWrapperType(m.getParameterTypes()[0])).isAssignableFrom(newValue.getClass())) {
                method = m;
                break;
            }
            ++n2;
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format("no such property found: class=%s, property=%s", clazz.getName(), property));
        }
        try {
            method.invoke(object, newValue);
        }
        catch (IllegalAccessException e) {
            throw new JavieRuntimeException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new JavieRuntimeException((Throwable)e);
        }
    }

    private static Class<?> toWrapperType(Class<?> type) {
        return type.equals(Boolean.TYPE) ? Boolean.class : (type.equals(Character.TYPE) ? Character.class : (type.equals(Byte.TYPE) ? Byte.class : (type.equals(Short.TYPE) ? Short.class : (type.equals(Integer.TYPE) ? Integer.class : (type.equals(Long.TYPE) ? Long.class : (type.equals(Float.TYPE) ? Float.class : (type.equals(Double.TYPE) ? Double.class : (type.equals(Void.TYPE) ? Void.class : type))))))));
    }
}

