/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.director;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.equinox.internal.p2.core.helpers.Tracing;
import org.eclipse.equinox.internal.p2.director.ApplicablePatchQuery;
import org.eclipse.equinox.internal.p2.director.DirectorActivator;
import org.eclipse.equinox.internal.p2.director.Explanation;
import org.eclipse.equinox.internal.p2.director.InfiniteProgress;
import org.eclipse.equinox.internal.p2.director.Messages;
import org.eclipse.equinox.internal.p2.director.QueryableArray;
import org.eclipse.equinox.internal.p2.director.TwoTierMap;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnitFragment;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnitPatch;
import org.eclipse.equinox.internal.provisional.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.internal.provisional.p2.metadata.IRequirementChange;
import org.eclipse.equinox.internal.provisional.p2.metadata.query.CapabilityQuery;
import org.eclipse.equinox.internal.provisional.p2.metadata.query.InstallableUnitQuery;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.IQueryable;
import org.eclipse.equinox.internal.provisional.p2.query.Query;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.InvalidSyntaxException;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.SolverFactory;
import org.sat4j.pb.tools.DependencyHelper;
import org.sat4j.pb.tools.WeightedObject;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IVec;
import org.sat4j.specs.TimeoutException;

public class Projector {
    static boolean DEBUG = Tracing.DEBUG_PLANNER_PROJECTOR;
    private static boolean DEBUG_ENCODING = false;
    private IQueryable picker;
    private QueryableArray patches;
    private Map noopVariables;
    private List abstractVariables;
    private TwoTierMap slice;
    private Dictionary selectionContext;
    DependencyHelper dependencyHelper;
    private Collection solution;
    private Collection assumptions;
    private MultiStatus result;
    private Collection alreadyInstalledIUs;
    private boolean considerMetaRequirements;
    private IInstallableUnit entryPoint;
    private Map fragments = new HashMap();
    static /* synthetic */ Class class$0;

    public Projector(IQueryable q, Dictionary context, boolean considerMetaRequirements) {
        this.picker = q;
        this.noopVariables = new HashMap();
        this.slice = new TwoTierMap();
        this.selectionContext = context;
        this.abstractVariables = new ArrayList();
        this.result = new MultiStatus("org.eclipse.equinox.p2.director", 0, Messages.Planner_Problems_resolving_plan, null);
        this.assumptions = new ArrayList();
        this.considerMetaRequirements = considerMetaRequirements;
    }

    public void encode(IInstallableUnit entryPointIU, IInstallableUnit[] alreadyExistingRoots, IInstallableUnit[] newRoots, IProgressMonitor monitor) {
        this.alreadyInstalledIUs = Arrays.asList(alreadyExistingRoots);
        this.entryPoint = entryPointIU;
        try {
            long start = 0L;
            if (DEBUG) {
                start = System.currentTimeMillis();
                Tracing.debug((String)("Start projection: " + start));
            }
            IPBSolver solver = DEBUG_ENCODING ? SolverFactory.newOPBStringSolver() : SolverFactory.newEclipseP2();
            solver.setTimeoutOnConflicts(1000);
            Collector collector = this.picker.query((Query)InstallableUnitQuery.ANY, new Collector(), null);
            this.dependencyHelper = new DependencyHelper(solver);
            Iterator iusToEncode = collector.iterator();
            if (DEBUG) {
                ArrayList iusToOrder = new ArrayList();
                while (iusToEncode.hasNext()) {
                    iusToOrder.add(iusToEncode.next());
                }
                Collections.sort(iusToOrder);
                iusToEncode = iusToOrder.iterator();
            }
            while (iusToEncode.hasNext()) {
                if (monitor.isCanceled()) {
                    this.result.merge(Status.CANCEL_STATUS);
                    throw new OperationCanceledException();
                }
                IInstallableUnit iuToEncode = (IInstallableUnit)iusToEncode.next();
                if (iuToEncode == entryPointIU) continue;
                this.processIU(iuToEncode, false);
            }
            this.createConstraintsForSingleton();
            this.createMustHave(entryPointIU, alreadyExistingRoots, newRoots);
            this.createOptimizationFunction(entryPointIU);
            if (DEBUG) {
                long stop = System.currentTimeMillis();
                Tracing.debug((String)("Projection complete: " + (stop - start)));
            }
            if (DEBUG_ENCODING) {
                System.out.println(solver.toString());
            }
        }
        catch (IllegalStateException e) {
            this.result.add((IStatus)new Status(4, "org.eclipse.equinox.p2.director", e.getMessage(), (Throwable)e));
        }
        catch (ContradictionException contradictionException) {
            this.result.add((IStatus)new Status(4, "org.eclipse.equinox.p2.director", Messages.Planner_Unsatisfiable_problem));
        }
    }

    private void createOptimizationFunction(IInstallableUnit metaIu) {
        BigInteger POWER;
        ArrayList<WeightedObject> weightedObjects = new ArrayList<WeightedObject>();
        Set s = this.slice.entrySet();
        BigInteger maxWeight = POWER = BigInteger.valueOf(2L);
        Iterator<Object> iterator = s.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            HashMap conflictingEntries = (HashMap)entry.getValue();
            if (conflictingEntries.size() == 1) continue;
            ArrayList toSort = new ArrayList(conflictingEntries.values());
            Collections.sort(toSort, Collections.reverseOrder());
            BigInteger weight = BigInteger.ONE;
            int count = toSort.size();
            int i = 0;
            while (i < count) {
                weightedObjects.add(WeightedObject.newWO(toSort.get(i), (BigInteger)weight));
                weight = weight.multiply(POWER);
                ++i;
            }
            if (weight.compareTo(maxWeight) <= 0) continue;
            maxWeight = weight;
        }
        maxWeight = maxWeight.multiply(POWER);
        iterator = this.noopVariables.values().iterator();
        while (iterator.hasNext()) {
            weightedObjects.add(WeightedObject.newWO((Object)iterator.next(), (BigInteger)maxWeight));
        }
        maxWeight = maxWeight.multiply(POWER);
        BigInteger abstractWeight = maxWeight.negate();
        Iterator iterator2 = this.abstractVariables.iterator();
        while (iterator2.hasNext()) {
            weightedObjects.add(WeightedObject.newWO(iterator2.next(), (BigInteger)abstractWeight));
        }
        maxWeight = maxWeight.multiply(POWER);
        BigInteger optionalWeight = maxWeight.negate();
        long countOptional = 1L;
        ArrayList<IInstallableUnit> requestedPatches = new ArrayList<IInstallableUnit>();
        IRequiredCapability[] reqs = metaIu.getRequiredCapabilities();
        int j = 0;
        while (j < reqs.length) {
            if (reqs[j].isOptional()) {
                Collector matches = this.picker.query((Query)new CapabilityQuery(reqs[j]), new Collector(), null);
                Iterator iterator3 = matches.iterator();
                while (iterator3.hasNext()) {
                    IInstallableUnit match = (IInstallableUnit)iterator3.next();
                    if (match instanceof IInstallableUnitPatch) {
                        requestedPatches.add(match);
                        ++countOptional;
                        continue;
                    }
                    weightedObjects.add(WeightedObject.newWO((Object)match, (BigInteger)optionalWeight));
                }
            }
            ++j;
        }
        BigInteger patchWeight = maxWeight.multiply(POWER).multiply(BigInteger.valueOf(countOptional)).negate();
        Iterator iterator4 = requestedPatches.iterator();
        while (iterator4.hasNext()) {
            weightedObjects.add(WeightedObject.newWO(iterator4.next(), (BigInteger)patchWeight));
        }
        if (!weightedObjects.isEmpty()) {
            this.createObjectiveFunction(weightedObjects);
        }
    }

    private void createObjectiveFunction(List weightedObjects) {
        if (DEBUG) {
            StringBuffer b = new StringBuffer();
            Iterator i = weightedObjects.iterator();
            while (i.hasNext()) {
                WeightedObject object = (WeightedObject)i.next();
                if (b.length() > 0) {
                    b.append(", ");
                }
                b.append(object.getWeight());
                b.append(' ');
                b.append(object.thing);
            }
            Tracing.debug((String)("objective function: " + b));
        }
        this.dependencyHelper.setObjectiveFunction(weightedObjects.toArray(new WeightedObject[weightedObjects.size()]));
    }

    private void createMustHave(IInstallableUnit iu, IInstallableUnit[] alreadyExistingRoots, IInstallableUnit[] newRoots) throws ContradictionException {
        this.processIU(iu, true);
        if (DEBUG) {
            Tracing.debug((String)(iu + "=1"));
        }
        this.assumptions.add(iu);
    }

    private void createNegation(IInstallableUnit iu, IRequiredCapability req) throws ContradictionException {
        if (DEBUG) {
            Tracing.debug((String)(iu + "=0"));
        }
        this.dependencyHelper.setFalse((Object)iu, (Object)new Explanation.MissingIU(iu, req));
    }

    private boolean isApplicable(IRequiredCapability req) {
        String filter = req.getFilter();
        if (filter == null) {
            return true;
        }
        try {
            return DirectorActivator.context.createFilter(filter).match(this.selectionContext);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            return false;
        }
    }

    private boolean isApplicable(IInstallableUnit iu) {
        String enablementFilter = iu.getFilter();
        if (enablementFilter == null) {
            return true;
        }
        try {
            return DirectorActivator.context.createFilter(enablementFilter).match(this.selectionContext);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            return false;
        }
    }

    private void expandRequirement(IRequiredCapability req, IInstallableUnit iu, List optionalAbstractRequirements, boolean isRootIu) throws ContradictionException {
        if (!this.isApplicable(req)) {
            return;
        }
        List matches = this.getApplicableMatches(req);
        if (this.isHostRequirement(iu, req)) {
            this.rememberHostMatches(iu, matches);
        }
        if (!req.isOptional()) {
            if (matches.isEmpty()) {
                this.missingRequirement(iu, req);
            } else {
                IInstallableUnit reqIu = (IInstallableUnit)this.picker.query((Query)new CapabilityQuery(req), new Collector(), null).iterator().next();
                Explanation explanation = isRootIu ? (this.alreadyInstalledIUs.contains(reqIu) ? new Explanation.IUInstalled(reqIu) : new Explanation.IUToInstall(reqIu)) : new Explanation.HardRequirement(iu, req);
                this.createImplication(iu, matches, explanation);
            }
        } else if (!matches.isEmpty()) {
            AbstractVariable abs = this.getAbstractVariable();
            this.createImplication(new Object[]{abs, iu}, matches, Explanation.OPTIONAL_REQUIREMENT);
            optionalAbstractRequirements.add(abs);
        }
    }

    private void expandRequirements(IRequiredCapability[] reqs, IInstallableUnit iu, boolean isRootIu) throws ContradictionException {
        if (reqs.length == 0) {
            return;
        }
        ArrayList optionalAbstractRequirements = new ArrayList();
        int i = 0;
        while (i < reqs.length) {
            this.expandRequirement(reqs[i], iu, optionalAbstractRequirements, isRootIu);
            ++i;
        }
        this.createOptionalityExpression(iu, optionalAbstractRequirements);
    }

    public void processIU(IInstallableUnit iu, boolean isRootIU) throws ContradictionException {
        iu = iu.unresolved();
        this.slice.put(iu.getId(), iu.getVersion(), iu);
        if (!this.isApplicable(iu)) {
            this.createNegation(iu, null);
            return;
        }
        Collector applicablePatches = this.getApplicablePatches(iu);
        this.expandLifeCycle(iu, isRootIU);
        if (applicablePatches.size() == 0) {
            this.expandRequirements(this.getRequiredCapabilities(iu), iu, isRootIU);
        } else {
            this.expandRequirementsWithPatches(iu, applicablePatches, isRootIU);
        }
    }

    private IRequiredCapability[] getRequiredCapabilities(IInstallableUnit iu) {
        if (!this.considerMetaRequirements || iu.getMetaRequiredCapabilities().length == 0) {
            return iu.getRequiredCapabilities();
        }
        IRequiredCapability[] aggregatedCapabilities = new IRequiredCapability[iu.getRequiredCapabilities().length + iu.getMetaRequiredCapabilities().length];
        System.arraycopy(iu.getRequiredCapabilities(), 0, aggregatedCapabilities, 0, iu.getRequiredCapabilities().length);
        System.arraycopy(iu.getMetaRequiredCapabilities(), 0, aggregatedCapabilities, iu.getRequiredCapabilities().length, iu.getMetaRequiredCapabilities().length);
        return aggregatedCapabilities;
    }

    private void expandRequirementsWithPatches(IInstallableUnit iu, Collector applicablePatches, boolean isRootIu) throws ContradictionException {
        AbstractVariable abs;
        Explanation explanation;
        IInstallableUnit reqIu;
        List matches;
        HashMap<IRequiredCapability, ArrayList<IInstallableUnitPatch>> unchangedRequirements = new HashMap<IRequiredCapability, ArrayList<IInstallableUnitPatch>>(this.getRequiredCapabilities(iu).length);
        HashMap<IRequiredCapability, Pending> nonPatchedRequirements = new HashMap<IRequiredCapability, Pending>(this.getRequiredCapabilities(iu).length);
        Iterator iterator = applicablePatches.iterator();
        while (iterator.hasNext()) {
            IInstallableUnitPatch patch = (IInstallableUnitPatch)iterator.next();
            IRequiredCapability[][] reqs = this.mergeRequirements(iu, patch);
            if (reqs.length == 0) {
                return;
            }
            ArrayList<AbstractVariable> optionalAbstractRequirements = new ArrayList<AbstractVariable>();
            int i = 0;
            while (i < reqs.length) {
                if (reqs[i][0] == reqs[i][1]) {
                    if (this.isApplicable(reqs[i][0])) {
                        ArrayList<IInstallableUnitPatch> patchesAppliedElseWhere = (ArrayList<IInstallableUnitPatch>)unchangedRequirements.get(reqs[i][0]);
                        if (patchesAppliedElseWhere == null) {
                            patchesAppliedElseWhere = new ArrayList<IInstallableUnitPatch>();
                            unchangedRequirements.put(reqs[i][0], patchesAppliedElseWhere);
                        }
                        patchesAppliedElseWhere.add(patch);
                    }
                } else {
                    IRequiredCapability req;
                    if (this.isApplicable(reqs[i][1])) {
                        req = reqs[i][1];
                        List matches2 = this.getApplicableMatches(req);
                        if (this.isHostRequirement(iu, req)) {
                            this.rememberHostMatches(iu, matches2);
                        }
                        if (!req.isOptional()) {
                            if (matches2.isEmpty()) {
                                this.missingRequirement((IInstallableUnit)patch, req);
                            } else {
                                IInstallableUnit reqIu2 = (IInstallableUnit)this.picker.query((Query)new CapabilityQuery(req), new Collector(), null).iterator().next();
                                Explanation explanation2 = isRootIu ? (this.alreadyInstalledIUs.contains(reqIu2) ? new Explanation.IUInstalled(reqIu2) : new Explanation.IUToInstall(reqIu2)) : new Explanation.PatchedHardRequirement(iu, req, patch);
                                this.createImplication(new Object[]{patch, iu}, matches2, explanation2);
                            }
                        } else if (!matches2.isEmpty()) {
                            AbstractVariable abs2 = this.getAbstractVariable();
                            this.createImplication(new Object[]{patch, abs2, iu}, matches2, Explanation.OPTIONAL_REQUIREMENT);
                            optionalAbstractRequirements.add(abs2);
                        }
                    }
                    if (this.isApplicable(reqs[i][0])) {
                        req = reqs[i][0];
                        Pending pending = (Pending)nonPatchedRequirements.get(req);
                        if (pending != null) {
                            pending.matches.add(patch);
                        } else {
                            matches = this.getApplicableMatches(req);
                            if (this.isHostRequirement(iu, req)) {
                                this.rememberHostMatches(iu, matches);
                            }
                            if (!req.isOptional()) {
                                if (matches.isEmpty()) {
                                    this.dependencyHelper.implication(new Object[]{iu}).implies((Object)patch).named((Object)new Explanation.HardRequirement(iu, null));
                                } else {
                                    matches.add(patch);
                                    reqIu = (IInstallableUnit)this.picker.query((Query)new CapabilityQuery(req), new Collector(), null).iterator().next();
                                    explanation = isRootIu ? (this.alreadyInstalledIUs.contains(reqIu) ? new Explanation.IUInstalled(reqIu) : new Explanation.IUToInstall(reqIu)) : new Explanation.HardRequirement(iu, req);
                                    pending = new Pending();
                                    pending.left = iu;
                                    pending.explanation = explanation;
                                    pending.matches = matches;
                                    nonPatchedRequirements.put(req, pending);
                                }
                            } else if (!matches.isEmpty()) {
                                abs = this.getAbstractVariable();
                                matches.add(patch);
                                pending = new Pending();
                                pending.left = new Object[]{abs, iu};
                                pending.explanation = Explanation.OPTIONAL_REQUIREMENT;
                                pending.matches = matches;
                                nonPatchedRequirements.put(req, pending);
                                optionalAbstractRequirements.add(abs);
                            }
                        }
                    }
                }
                ++i;
            }
            this.createOptionalityExpression(iu, optionalAbstractRequirements);
        }
        iterator = nonPatchedRequirements.values().iterator();
        while (iterator.hasNext()) {
            Pending pending = (Pending)iterator.next();
            this.createImplication(pending.left, pending.matches, pending.explanation);
        }
        ArrayList<AbstractVariable> optionalAbstractRequirements = new ArrayList<AbstractVariable>();
        Iterator iterator2 = unchangedRequirements.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry entry = iterator2.next();
            List patchesApplied = (List)entry.getValue();
            ArrayList allPatches = new ArrayList(applicablePatches.toCollection());
            allPatches.removeAll(patchesApplied);
            ArrayList<IInstallableUnitPatch> requiredPatches = new ArrayList<IInstallableUnitPatch>();
            Iterator iterator22 = allPatches.iterator();
            while (iterator22.hasNext()) {
                IInstallableUnitPatch patch = (IInstallableUnitPatch)iterator22.next();
                requiredPatches.add(patch);
            }
            IRequiredCapability req = (IRequiredCapability)entry.getKey();
            matches = this.getApplicableMatches(req);
            if (this.isHostRequirement(iu, req)) {
                this.rememberHostMatches(iu, matches);
            }
            if (!req.isOptional()) {
                if (matches.isEmpty()) {
                    if (requiredPatches.isEmpty()) {
                        this.missingRequirement(iu, req);
                        continue;
                    }
                    this.createImplication(iu, requiredPatches, (Explanation)new Explanation.HardRequirement(iu, req));
                    continue;
                }
                if (!requiredPatches.isEmpty()) {
                    matches.addAll(requiredPatches);
                }
                reqIu = (IInstallableUnit)this.picker.query((Query)new CapabilityQuery(req), new Collector(), null).iterator().next();
                explanation = isRootIu ? (this.alreadyInstalledIUs.contains(reqIu) ? new Explanation.IUInstalled(reqIu) : new Explanation.IUToInstall(reqIu)) : new Explanation.HardRequirement(iu, req);
                this.createImplication(iu, matches, explanation);
                continue;
            }
            if (matches.isEmpty()) continue;
            if (!requiredPatches.isEmpty()) {
                matches.addAll(requiredPatches);
            }
            abs = this.getAbstractVariable();
            this.createImplication(new Object[]{abs, iu}, matches, Explanation.OPTIONAL_REQUIREMENT);
            optionalAbstractRequirements.add(abs);
        }
        this.createOptionalityExpression(iu, optionalAbstractRequirements);
    }

    private void expandLifeCycle(IInstallableUnit iu, boolean isRootIu) throws ContradictionException {
        if (!(iu instanceof IInstallableUnitPatch)) {
            return;
        }
        IInstallableUnitPatch patch = (IInstallableUnitPatch)iu;
        IRequiredCapability req = patch.getLifeCycle();
        if (req == null) {
            return;
        }
        this.expandRequirement(req, iu, Collections.EMPTY_LIST, isRootIu);
    }

    private void missingRequirement(IInstallableUnit iu, IRequiredCapability req) throws ContradictionException {
        this.result.add((IStatus)new Status(2, "org.eclipse.equinox.p2.director", NLS.bind((String)Messages.Planner_Unsatisfied_dependency, (Object)iu, (Object)req)));
        this.createNegation(iu, req);
    }

    private List getApplicableMatches(IRequiredCapability req) {
        ArrayList<IInstallableUnit> target = new ArrayList<IInstallableUnit>();
        Collector matches = this.picker.query((Query)new CapabilityQuery(req), new Collector(), null);
        Iterator iterator = matches.iterator();
        while (iterator.hasNext()) {
            IInstallableUnit match = (IInstallableUnit)iterator.next();
            if (!this.isApplicable(match)) continue;
            target.add(match);
        }
        return target;
    }

    private IRequiredCapability[][] mergeRequirements(IInstallableUnit iu, IInstallableUnitPatch patch) {
        if (patch == null) {
            return null;
        }
        IRequirementChange[] changes = patch.getRequirementsChange();
        IRequiredCapability[] originalRequirements = new IRequiredCapability[iu.getRequiredCapabilities().length];
        System.arraycopy(iu.getRequiredCapabilities(), 0, originalRequirements, 0, originalRequirements.length);
        ArrayList<IRequiredCapability[]> rrr = new ArrayList<IRequiredCapability[]>();
        boolean found = false;
        int i = 0;
        while (i < changes.length) {
            int j = 0;
            while (j < originalRequirements.length) {
                if (originalRequirements[j] != null && changes[i].matches(originalRequirements[j])) {
                    found = true;
                    if (changes[i].newValue() != null) {
                        rrr.add(new IRequiredCapability[]{originalRequirements[j], changes[i].newValue()});
                    } else {
                        IRequiredCapability[] iRequiredCapabilityArray = new IRequiredCapability[2];
                        iRequiredCapabilityArray[0] = originalRequirements[j];
                        rrr.add(iRequiredCapabilityArray);
                    }
                    originalRequirements[j] = null;
                }
                ++j;
            }
            if (!found && changes[i].applyOn() == null && changes[i].newValue() != null) {
                IRequiredCapability[] iRequiredCapabilityArray = new IRequiredCapability[2];
                iRequiredCapabilityArray[1] = changes[i].newValue();
                rrr.add(iRequiredCapabilityArray);
            }
            ++i;
        }
        i = 0;
        while (i < originalRequirements.length) {
            if (originalRequirements[i] != null) {
                rrr.add(new IRequiredCapability[]{originalRequirements[i], originalRequirements[i]});
            }
            ++i;
        }
        return (IRequiredCapability[][])rrr.toArray((T[])new IRequiredCapability[rrr.size()][]);
    }

    private void createOptionalityExpression(IInstallableUnit iu, List optionalRequirements) throws ContradictionException {
        if (optionalRequirements.isEmpty()) {
            return;
        }
        AbstractVariable noop = this.getNoOperationVariable(iu);
        Iterator i = optionalRequirements.iterator();
        while (i.hasNext()) {
            AbstractVariable abs = (AbstractVariable)i.next();
            this.createIncompatibleValues(abs, noop);
        }
        optionalRequirements.add(noop);
        this.createImplication(iu, optionalRequirements, Explanation.OPTIONAL_REQUIREMENT);
    }

    private void createImplication(Object left, List right, Explanation name) throws ContradictionException {
        if (DEBUG) {
            Tracing.debug((String)(name + ": " + left + "->" + right));
        }
        this.dependencyHelper.implication(new Object[]{left}).implies(right.toArray()).named((Object)name);
    }

    private void createImplication(Object[] left, List right, Explanation name) throws ContradictionException {
        if (DEBUG) {
            Tracing.debug((String)(name + ": " + Arrays.asList(left) + "->" + right));
        }
        this.dependencyHelper.implication(left).implies(right.toArray()).named((Object)name);
    }

    private Collector getApplicablePatches(IInstallableUnit iu) {
        if (this.patches == null) {
            Collector collector = this.picker.query(ApplicablePatchQuery.ANY, new Collector(), null);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.patches = new QueryableArray((IInstallableUnit[])collector.toArray((Class)clazz));
        }
        return this.patches.query((Query)new ApplicablePatchQuery(iu), new Collector(), null);
    }

    private void createConstraintsForSingleton() throws ContradictionException {
        Set s = this.slice.entrySet();
        Iterator iterator = s.iterator();
        while (iterator.hasNext()) {
            IInstallableUnit[] singletonArray;
            Map.Entry entry = (Map.Entry)iterator.next();
            HashMap conflictingEntries = (HashMap)entry.getValue();
            if (conflictingEntries.size() < 2) continue;
            Collection conflictingVersions = conflictingEntries.values();
            ArrayList<IInstallableUnit> singletons = new ArrayList<IInstallableUnit>();
            ArrayList<IInstallableUnit> nonSingletons = new ArrayList<IInstallableUnit>();
            Iterator conflictIterator = conflictingVersions.iterator();
            while (conflictIterator.hasNext()) {
                IInstallableUnit iu = (IInstallableUnit)conflictIterator.next();
                if (iu.isSingleton()) {
                    singletons.add(iu);
                    continue;
                }
                nonSingletons.add(iu);
            }
            if (singletons.isEmpty()) continue;
            if (nonSingletons.isEmpty()) {
                singletonArray = singletons.toArray(new IInstallableUnit[singletons.size()]);
                this.createAtMostOne(singletonArray);
                continue;
            }
            singletonArray = singletons.toArray(new IInstallableUnit[singletons.size() + 1]);
            Iterator iterator2 = nonSingletons.iterator();
            while (iterator2.hasNext()) {
                singletonArray[singletonArray.length - 1] = (IInstallableUnit)iterator2.next();
                this.createAtMostOne(singletonArray);
            }
        }
    }

    private void createAtMostOne(IInstallableUnit[] ius) throws ContradictionException {
        if (DEBUG) {
            StringBuffer b = new StringBuffer();
            int i = 0;
            while (i < ius.length) {
                b.append(ius[i].toString());
                ++i;
            }
            Tracing.debug((String)("At most 1 of " + b));
        }
        this.dependencyHelper.atMost(1, (Object[])ius).named((Object)new Explanation.Singleton(ius));
    }

    private void createIncompatibleValues(AbstractVariable v1, AbstractVariable v2) throws ContradictionException {
        Object[] vars = new AbstractVariable[]{v1, v2};
        if (DEBUG) {
            StringBuffer b = new StringBuffer();
            int i = 0;
            while (i < vars.length) {
                b.append(((AbstractVariable)vars[i]).toString());
                ++i;
            }
            Tracing.debug((String)("At most 1 of " + b));
        }
        this.dependencyHelper.atMost(1, vars).named((Object)Explanation.OPTIONAL_REQUIREMENT);
    }

    private AbstractVariable getAbstractVariable() {
        AbstractVariable abstractVariable = new AbstractVariable();
        this.abstractVariables.add(abstractVariable);
        return abstractVariable;
    }

    private AbstractVariable getNoOperationVariable(IInstallableUnit iu) {
        AbstractVariable v = (AbstractVariable)this.noopVariables.get(iu);
        if (v == null) {
            v = new AbstractVariable();
            this.noopVariables.put(iu, v);
        }
        return v;
    }

    public IStatus invokeSolver(IProgressMonitor monitor) {
        if (this.result.getSeverity() == 4) {
            return this.result;
        }
        long start = System.currentTimeMillis();
        if (DEBUG) {
            Tracing.debug((String)("Invoking solver: " + start));
        }
        try {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            if (this.dependencyHelper.hasASolution(this.assumptions)) {
                if (DEBUG) {
                    Tracing.debug((String)"Satisfiable !");
                }
                this.backToIU();
                long stop = System.currentTimeMillis();
                if (DEBUG) {
                    Tracing.debug((String)("Solver solution found: " + (stop - start)));
                }
            } else {
                long stop = System.currentTimeMillis();
                if (DEBUG) {
                    Tracing.debug((String)"Unsatisfiable !");
                    Tracing.debug((String)("Solver solution NOT found: " + (stop - start)));
                }
                this.result.merge((IStatus)new Status(4, "org.eclipse.equinox.p2.director", Messages.Planner_Unsatisfiable_problem));
            }
        }
        catch (TimeoutException timeoutException) {
            this.result.merge((IStatus)new Status(4, "org.eclipse.equinox.p2.director", Messages.Planner_Timeout));
        }
        catch (Exception e) {
            this.result.merge((IStatus)new Status(4, "org.eclipse.equinox.p2.director", Messages.Planner_Unexpected_problem, (Throwable)e));
        }
        if (DEBUG) {
            System.out.println();
        }
        return this.result;
    }

    private void backToIU() {
        this.solution = new ArrayList();
        IVec sat4jSolution = this.dependencyHelper.getSolution();
        Iterator i = sat4jSolution.iterator();
        while (i.hasNext()) {
            IInstallableUnit iu;
            Object var = i.next();
            if (!(var instanceof IInstallableUnit) || (iu = (IInstallableUnit)var) == this.entryPoint) continue;
            this.solution.add(iu);
        }
    }

    private void printSolution(Collection state) {
        ArrayList l = new ArrayList(state);
        Collections.sort(l);
        Tracing.debug((String)"Solution:");
        Tracing.debug((String)("Numbers of IUs selected: " + l.size()));
        Iterator iterator = l.iterator();
        while (iterator.hasNext()) {
            Tracing.debug((String)iterator.next().toString());
        }
    }

    public Collection extractSolution() {
        if (DEBUG) {
            this.printSolution(this.solution);
        }
        return this.solution;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Set getExplanation(IProgressMonitor monitor) {
        ExplanationJob job = new ExplanationJob();
        job.schedule();
        monitor.setTaskName(Messages.Planner_NoSolution);
        InfiniteProgress pm = new InfiniteProgress(monitor);
        pm.beginTask(Messages.Planner_NoSolution, 1000);
        try {
            ExplanationJob explanationJob = job;
            synchronized (explanationJob) {
                while (job.getExplanationResult() == null) {
                    if (job.getState() == 0) {
                        return job.getExplanationResult();
                    }
                    if (monitor.isCanceled()) {
                        job.cancel();
                        throw new OperationCanceledException();
                    }
                    pm.worked(1);
                    try {
                        ((Object)((Object)job)).wait(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        if (!DEBUG) continue;
                        Tracing.debug((String)"Interrupted while computing explanations");
                    }
                }
                return job.getExplanationResult();
            }
        }
        finally {
            monitor.done();
        }
    }

    public Map getFragmentAssociation() {
        HashMap resolvedFragments = new HashMap(this.fragments.size());
        Iterator iterator = this.fragments.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry fragment = iterator.next();
            if (!this.dependencyHelper.getBooleanValueFor(fragment.getKey())) continue;
            Set potentialHosts = (Set)fragment.getValue();
            ArrayList resolvedHost = new ArrayList(potentialHosts.size());
            Iterator iterator2 = potentialHosts.iterator();
            while (iterator2.hasNext()) {
                Object host = iterator2.next();
                if (!this.dependencyHelper.getBooleanValueFor(host)) continue;
                resolvedHost.add(host);
            }
            if (resolvedHost.size() == 0) continue;
            resolvedFragments.put(fragment.getKey(), resolvedHost);
        }
        return resolvedFragments;
    }

    private void rememberHostMatches(IInstallableUnit fragment, List matches) {
        HashSet existingMatches = (HashSet)this.fragments.get(fragment);
        if (existingMatches == null) {
            existingMatches = new HashSet();
            this.fragments.put(fragment, existingMatches);
            existingMatches.addAll(matches);
        }
        existingMatches.retainAll(matches);
    }

    private boolean isHostRequirement(IInstallableUnit iu, IRequiredCapability req) {
        if (!(iu instanceof IInstallableUnitFragment)) {
            return false;
        }
        IInstallableUnitFragment fragment = (IInstallableUnitFragment)iu;
        IRequiredCapability[] reqs = fragment.getHost();
        int i = 0;
        while (i < reqs.length) {
            if (req.equals((Object)reqs[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    static class AbstractVariable {
        AbstractVariable() {
        }

        public String toString() {
            return "AbstractVariable: " + this.hashCode();
        }
    }

    class ExplanationJob
    extends Job {
        private Set explanation;

        public ExplanationJob() {
            super(Messages.Planner_NoSolution);
            this.setSystem(true);
        }

        public boolean belongsTo(Object family) {
            return family == this;
        }

        protected void canceling() {
            super.canceling();
            Projector.this.dependencyHelper.stopExplanation();
        }

        public Set getExplanationResult() {
            return this.explanation;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            block15: {
                long start = 0L;
                if (DEBUG) {
                    start = System.currentTimeMillis();
                    Tracing.debug((String)("Determining cause of failure: " + start));
                }
                try {
                    try {
                        this.explanation = Projector.this.dependencyHelper.why();
                        if (DEBUG) {
                            long stop = System.currentTimeMillis();
                            Tracing.debug((String)("Explanation found: " + (stop - start)));
                            Tracing.debug((String)"Explanation:");
                            Iterator i = this.explanation.iterator();
                            while (i.hasNext()) {
                                Tracing.debug((String)i.next().toString());
                            }
                        }
                    }
                    catch (TimeoutException timeoutException) {
                        if (DEBUG) {
                            Tracing.debug((String)"Timeout while computing explanations");
                        }
                        if (this.explanation == null) {
                            this.explanation = Collections.EMPTY_SET;
                        }
                        break block15;
                    }
                }
                catch (Throwable throwable) {
                    if (this.explanation == null) {
                        this.explanation = Collections.EMPTY_SET;
                    }
                    throw throwable;
                }
                if (this.explanation == null) {
                    this.explanation = Collections.EMPTY_SET;
                }
            }
            ExplanationJob explanationJob = this;
            synchronized (explanationJob) {
                ((Object)((Object)this)).notify();
            }
            return Status.OK_STATUS;
        }
    }

    static final class Pending {
        List matches;
        Explanation explanation;
        Object left;

        Pending() {
        }
    }
}

