/*
 * Decompiled with CFR 0.152.
 */
package javax.media.opengl;

import com.jogamp.common.GlueGenVersion;
import com.jogamp.common.jvm.JVMUtil;
import com.jogamp.common.util.ReflectionUtil;
import com.jogamp.common.util.VersionUtil;
import com.jogamp.nativewindow.NativeWindowVersion;
import com.jogamp.opengl.JoglVersion;
import com.jogamp.opengl.impl.Debug;
import com.jogamp.opengl.impl.DesktopGLDynamicLookupHelper;
import com.jogamp.opengl.impl.GLDrawableFactoryImpl;
import com.jogamp.opengl.impl.GLDynamicLookupHelper;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Iterator;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.NativeWindowFactory;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLException;

public class GLProfile {
    public static final boolean DEBUG = Debug.debug("GLProfile");
    public static final String GL4bc = "GL4bc";
    public static final String GL4 = "GL4";
    public static final String GL3bc = "GL3bc";
    public static final String GL3 = "GL3";
    public static final String GL2 = "GL2";
    public static final String GLES1 = "GLES1";
    public static final String GLES2 = "GLES2";
    public static final String GL2ES1 = "GL2ES1";
    public static final String GL2ES2 = "GL2ES2";
    public static final String GL2GL3 = "GL2GL3";
    private static final String GL_DEFAULT = "GL_DEFAULT";
    public static final String[] GL_PROFILE_LIST_ALL = new String[]{"GL2", "GL3bc", "GL4bc", "GL2GL3", "GL3", "GL4", "GL2ES2", "GLES2", "GL2ES1", "GLES1"};
    public static final String[] GL_PROFILE_LIST_MAX_FIXEDFUNC = new String[]{"GL4bc", "GL3bc", "GL2", "GL2ES1", "GLES1"};
    public static final String[] GL_PROFILE_LIST_MAX_PROGSHADER = new String[]{"GL4", "GL4bc", "GL3", "GL3bc", "GL2", "GL2ES2", "GLES2"};
    public static final String[] GL_PROFILE_LIST_GL2ES2 = new String[]{"GL2ES2", "GL2", "GL3", "GL4", "GLES2"};
    public static final String[] GL_PROFILE_LIST_GL2ES1 = new String[]{"GL2ES1", "GL2", "GL3bc", "GL4bc", "GLES1"};
    public static final String[] GL_PROFILE_LIST_GLES = new String[]{"GLES2", "GLES1"};
    private static boolean isAWTAvailable;
    private static boolean hasDesktopGL;
    private static boolean hasGL234Impl;
    private static boolean hasGLES2Impl;
    private static boolean hasGLES1Impl;
    private static GLDrawableFactoryImpl eglFactory;
    private static GLDrawableFactoryImpl desktopFactory;
    private static AbstractGraphicsDevice defaultDevice;
    private static AbstractGraphicsDevice defaultDesktopDevice;
    private static AbstractGraphicsDevice defaultEGLDevice;
    static boolean initialized;
    private static HashMap deviceConn2ProfileMap;
    private String profileImpl = null;
    private String profile = null;

    public static synchronized void initSingleton(final boolean bl) {
        if (!initialized) {
            initialized = true;
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    GLProfile.initProfilesForDefaultDevices(bl);
                    return null;
                }
            });
        }
    }

    public static void initProfiles(AbstractGraphicsDevice abstractGraphicsDevice) {
        GLProfile.getProfileMap(abstractGraphicsDevice);
    }

    public static synchronized void shutdown() {
        if (initialized) {
            initialized = false;
            GLDrawableFactory.shutdown();
        }
    }

    public static boolean isGL4bcAvailable(AbstractGraphicsDevice abstractGraphicsDevice) {
        return null != GLProfile.getProfileMap(abstractGraphicsDevice).get(GL4bc);
    }

    public static boolean isGL4Available(AbstractGraphicsDevice abstractGraphicsDevice) {
        return null != GLProfile.getProfileMap(abstractGraphicsDevice).get(GL4);
    }

    public static boolean isGL3bcAvailable(AbstractGraphicsDevice abstractGraphicsDevice) {
        return null != GLProfile.getProfileMap(abstractGraphicsDevice).get(GL3bc);
    }

    public static boolean isGL3Available(AbstractGraphicsDevice abstractGraphicsDevice) {
        return null != GLProfile.getProfileMap(abstractGraphicsDevice).get(GL3);
    }

    public static boolean isGL2Available(AbstractGraphicsDevice abstractGraphicsDevice) {
        return null != GLProfile.getProfileMap(abstractGraphicsDevice).get(GL2);
    }

    public static boolean isGLES2Available(AbstractGraphicsDevice abstractGraphicsDevice) {
        return null != GLProfile.getProfileMap(abstractGraphicsDevice).get(GLES2);
    }

    public static boolean isGLES1Available(AbstractGraphicsDevice abstractGraphicsDevice) {
        return null != GLProfile.getProfileMap(abstractGraphicsDevice).get(GLES1);
    }

    public static boolean isGL2ES1Available(AbstractGraphicsDevice abstractGraphicsDevice) {
        return null != GLProfile.getProfileMap(abstractGraphicsDevice).get(GL2ES1);
    }

    public static boolean isGL2ES2Available(AbstractGraphicsDevice abstractGraphicsDevice) {
        return null != GLProfile.getProfileMap(abstractGraphicsDevice).get(GL2ES2);
    }

    public static boolean isGL4bcAvailable() {
        return GLProfile.isGL4bcAvailable(null);
    }

    public static boolean isGL4Available() {
        return GLProfile.isGL4Available(null);
    }

    public static boolean isGL3bcAvailable() {
        return GLProfile.isGL3bcAvailable(null);
    }

    public static boolean isGL3Available() {
        return GLProfile.isGL3Available(null);
    }

    public static boolean isGL2Available() {
        return GLProfile.isGL2Available(null);
    }

    public static boolean isGLES2Available() {
        return GLProfile.isGLES2Available(null);
    }

    public static boolean isGLES1Available() {
        return GLProfile.isGLES1Available(null);
    }

    public static boolean isGL2ES1Available() {
        return GLProfile.isGL2ES1Available(null);
    }

    public static boolean isGL2ES2Available() {
        return GLProfile.isGL2ES2Available(null);
    }

    public static String glAvailabilityToString(AbstractGraphicsDevice abstractGraphicsDevice) {
        StringBuffer stringBuffer = new StringBuffer();
        GLProfile.validateInitialization();
        if (null == abstractGraphicsDevice) {
            abstractGraphicsDevice = defaultDevice;
        }
        stringBuffer.append("GLAvailability[Native[GL4bc ");
        boolean bl = GLProfile.isGL4bcAvailable(abstractGraphicsDevice);
        stringBuffer.append(bl);
        if (bl) {
            GLProfile.glAvailabilityToString(abstractGraphicsDevice, stringBuffer, 4, 2);
        }
        stringBuffer.append(", GL4 ");
        bl = GLProfile.isGL4Available(abstractGraphicsDevice);
        stringBuffer.append(bl);
        if (bl) {
            GLProfile.glAvailabilityToString(abstractGraphicsDevice, stringBuffer, 4, 4);
        }
        stringBuffer.append(", GL3bc ");
        bl = GLProfile.isGL3bcAvailable(abstractGraphicsDevice);
        stringBuffer.append(bl);
        if (bl) {
            GLProfile.glAvailabilityToString(abstractGraphicsDevice, stringBuffer, 3, 2);
        }
        stringBuffer.append(", GL3 ");
        bl = GLProfile.isGL3Available(abstractGraphicsDevice);
        stringBuffer.append(bl);
        if (bl) {
            GLProfile.glAvailabilityToString(abstractGraphicsDevice, stringBuffer, 3, 4);
        }
        stringBuffer.append(", GL2 ");
        bl = GLProfile.isGL2Available(abstractGraphicsDevice);
        stringBuffer.append(bl);
        if (bl) {
            GLProfile.glAvailabilityToString(abstractGraphicsDevice, stringBuffer, 2, 2);
        }
        stringBuffer.append(", GL2ES1 ");
        stringBuffer.append(GLProfile.isGL2ES1Available(abstractGraphicsDevice));
        stringBuffer.append(", GLES1 ");
        bl = GLProfile.isGLES1Available(abstractGraphicsDevice);
        stringBuffer.append(bl);
        if (bl) {
            GLProfile.glAvailabilityToString(abstractGraphicsDevice, stringBuffer, 1, 8);
        }
        stringBuffer.append(", GL2ES2 ");
        stringBuffer.append(GLProfile.isGL2ES2Available(abstractGraphicsDevice));
        stringBuffer.append(", GLES2 ");
        bl = GLProfile.isGLES2Available(abstractGraphicsDevice);
        stringBuffer.append(bl);
        if (bl) {
            GLProfile.glAvailabilityToString(abstractGraphicsDevice, stringBuffer, 2, 8);
        }
        stringBuffer.append("], Profiles[");
        Iterator iterator = GLProfile.getProfileMap(abstractGraphicsDevice).values().iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(((GLProfile)iterator.next()).toString());
            stringBuffer.append(", ");
        }
        stringBuffer.append(", default ");
        stringBuffer.append(GLProfile.getDefault(abstractGraphicsDevice));
        stringBuffer.append("]]");
        return stringBuffer.toString();
    }

    public static String glAvailabilityToString() {
        return GLProfile.glAvailabilityToString(null);
    }

    public static GLProfile getDefault(AbstractGraphicsDevice abstractGraphicsDevice) {
        GLProfile gLProfile = GLProfile.get(abstractGraphicsDevice, GL_DEFAULT);
        return gLProfile;
    }

    public static GLProfile getDefault() {
        return GLProfile.getDefault(defaultDevice);
    }

    public static GLProfile getMaxFixedFunc(AbstractGraphicsDevice abstractGraphicsDevice) throws GLException {
        return GLProfile.get(abstractGraphicsDevice, GL_PROFILE_LIST_MAX_FIXEDFUNC);
    }

    public static GLProfile getMaxFixedFunc() throws GLException {
        return GLProfile.get(GL_PROFILE_LIST_MAX_FIXEDFUNC);
    }

    public static GLProfile getMaxProgrammable(AbstractGraphicsDevice abstractGraphicsDevice) throws GLException {
        return GLProfile.get(abstractGraphicsDevice, GL_PROFILE_LIST_MAX_PROGSHADER);
    }

    public static GLProfile getMaxProgrammable() throws GLException {
        return GLProfile.get(GL_PROFILE_LIST_MAX_PROGSHADER);
    }

    public static GLProfile getGL2ES1(AbstractGraphicsDevice abstractGraphicsDevice) throws GLException {
        return GLProfile.get(abstractGraphicsDevice, GL_PROFILE_LIST_GL2ES1);
    }

    public static GLProfile getGL2ES1() throws GLException {
        return GLProfile.get(GL_PROFILE_LIST_GL2ES1);
    }

    public static GLProfile getGL2ES2(AbstractGraphicsDevice abstractGraphicsDevice) throws GLException {
        return GLProfile.get(abstractGraphicsDevice, GL_PROFILE_LIST_GL2ES2);
    }

    public static GLProfile getGL2ES2() throws GLException {
        return GLProfile.get(GL_PROFILE_LIST_GL2ES2);
    }

    public static GLProfile get(AbstractGraphicsDevice abstractGraphicsDevice, String string) throws GLException {
        if (null == string || string.equals("GL")) {
            string = GL_DEFAULT;
        }
        return (GLProfile)GLProfile.getProfileMap(abstractGraphicsDevice).get(string);
    }

    public static GLProfile get(String string) throws GLException {
        return GLProfile.get(defaultDevice, string);
    }

    public static GLProfile get(AbstractGraphicsDevice abstractGraphicsDevice, String[] stringArray) throws GLException {
        HashMap hashMap = GLProfile.getProfileMap(abstractGraphicsDevice);
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            GLProfile gLProfile = (GLProfile)hashMap.get(string);
            if (null == gLProfile) continue;
            return gLProfile;
        }
        throw new GLException("Profiles " + GLProfile.array2String(stringArray) + " not available on device " + abstractGraphicsDevice);
    }

    public static GLProfile get(String[] stringArray) throws GLException {
        return GLProfile.get(defaultDevice, stringArray);
    }

    public static boolean usesNativeGLES1(String string) {
        return GLES1.equals(string);
    }

    public static boolean usesNativeGLES2(String string) {
        return GLES2.equals(string);
    }

    public static boolean usesNativeGLES(String string) {
        return GLProfile.usesNativeGLES2(string) || GLProfile.usesNativeGLES1(string);
    }

    public static boolean isAWTAvailable() {
        return isAWTAvailable;
    }

    public static String getGLTypeName(int n) {
        switch (n) {
            case 5121: {
                return "GL_UNSIGNED_BYTE";
            }
            case 5120: {
                return "GL_BYTE";
            }
            case 5123: {
                return "GL_UNSIGNED_SHORT";
            }
            case 5122: {
                return "GL_SHORT";
            }
            case 5126: {
                return "GL_FLOAT";
            }
            case 5132: {
                return "GL_FIXED";
            }
            case 5124: {
                return "GL_INT";
            }
            case 5125: {
                return "GL_UNSIGNED_INT";
            }
            case 5130: {
                return "GL_DOUBLE";
            }
            case 5127: {
                return "GL_2_BYTES";
            }
            case 5128: {
                return "GL_3_BYTES";
            }
            case 5129: {
                return "GL_4_BYTES";
            }
        }
        return null;
    }

    public static String getGLArrayName(int n) {
        switch (n) {
            case 32884: {
                return "GL_VERTEX_ARRAY";
            }
            case 32885: {
                return "GL_NORMAL_ARRAY";
            }
            case 32886: {
                return "GL_COLOR_ARRAY";
            }
            case 32888: {
                return "GL_TEXTURE_COORD_ARRAY";
            }
        }
        return null;
    }

    public final String getGLImplBaseClassName() {
        return GLProfile.getGLImplBaseClassName(this.profileImpl);
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof GLProfile) {
            GLProfile gLProfile = (GLProfile)object;
            return this.profile.equals(gLProfile.getName()) && this.profileImpl.equals(gLProfile.getImplName());
        }
        return false;
    }

    public int hashCode() {
        int n = 5;
        n = 97 * n + (this.profileImpl != null ? this.profileImpl.hashCode() : 0);
        n = 97 * n + (this.profile != null ? this.profile.hashCode() : 0);
        return n;
    }

    public final void verifyEquality(GLProfile gLProfile) throws GLException {
        if (!this.equals(gLProfile)) {
            throw new GLException("GLProfiles are not equal: " + this + " != " + gLProfile);
        }
    }

    public final String getName() {
        return this.profile;
    }

    public final String getImplName() {
        return this.profileImpl;
    }

    public final boolean isGL4bc() {
        return GL4bc.equals(this.profile);
    }

    public final boolean isGL4() {
        return this.isGL4bc() || GL4.equals(this.profile);
    }

    public final boolean isGL3bc() {
        return this.isGL4bc() || GL3bc.equals(this.profile);
    }

    public final boolean isGL3() {
        return this.isGL4() || this.isGL3bc() || GL3.equals(this.profile);
    }

    public final boolean isGL2() {
        return this.isGL3bc() || GL2.equals(this.profile);
    }

    public final boolean isGLES1() {
        return GLES1.equals(this.profile);
    }

    public final boolean isGLES2() {
        return GLES2.equals(this.profile);
    }

    public final boolean isGL2ES1() {
        return GL2ES1.equals(this.profile) || this.isGL2() || this.isGLES1();
    }

    public final boolean isGL2ES2() {
        return GL2ES2.equals(this.profile) || this.isGL2() || this.isGL3() || this.isGLES2();
    }

    public final boolean isGL2GL3() {
        return GL2GL3.equals(this.profile) || this.isGL2() || this.isGL3();
    }

    public final boolean hasGLSL() {
        return this.isGL2ES2();
    }

    public final boolean usesNativeGLES1() {
        return GLES1.equals(this.profileImpl);
    }

    public final boolean usesNativeGLES2() {
        return GLES2.equals(this.profileImpl);
    }

    public final boolean usesNativeGLES() {
        return this.usesNativeGLES2() || this.usesNativeGLES1();
    }

    public boolean isValidDataType(int n, boolean bl) {
        switch (n) {
            case 5120: 
            case 5121: 
            case 5122: 
            case 5123: 
            case 5126: 
            case 5132: {
                return true;
            }
            case 5124: 
            case 5125: {
                if (this.isGL2ES2()) {
                    return true;
                }
            }
            case 5130: {
                if (this.isGL3()) {
                    return true;
                }
            }
            case 5127: 
            case 5128: 
            case 5129: {
                if (!this.isGL2()) break;
                return true;
            }
        }
        if (bl) {
            throw new GLException("Illegal data type on profile " + this + ": " + n);
        }
        return false;
    }

    public boolean isValidArrayDataType(int n, int n2, int n3, boolean bl, boolean bl2) {
        block86: {
            String string;
            block88: {
                block87: {
                    block85: {
                        string = GLProfile.getGLArrayName(n);
                        if (!this.isGLES1()) break block85;
                        if (bl) {
                            if (bl2) {
                                throw new GLException("Illegal array type for " + string + " on profile GLES1: VertexAttribPointer");
                            }
                            return false;
                        }
                        block0 : switch (n) {
                            case 32884: 
                            case 32888: {
                                switch (n3) {
                                    case 5120: 
                                    case 5122: 
                                    case 5126: 
                                    case 5132: {
                                        break;
                                    }
                                    default: {
                                        if (bl2) {
                                            throw new GLException("Illegal data type for " + string + " on profile GLES1: " + n3);
                                        }
                                        return false;
                                    }
                                }
                                switch (n2) {
                                    case 0: 
                                    case 2: 
                                    case 3: 
                                    case 4: {
                                        break block0;
                                    }
                                }
                                if (bl2) {
                                    throw new GLException("Illegal component number for " + string + " on profile GLES1: " + n2);
                                }
                                return false;
                            }
                            case 32885: {
                                switch (n3) {
                                    case 5120: 
                                    case 5122: 
                                    case 5126: 
                                    case 5132: {
                                        break;
                                    }
                                    default: {
                                        if (bl2) {
                                            throw new GLException("Illegal data type for " + string + " on profile GLES1: " + n3);
                                        }
                                        return false;
                                    }
                                }
                                switch (n2) {
                                    case 0: 
                                    case 3: {
                                        break block0;
                                    }
                                }
                                if (bl2) {
                                    throw new GLException("Illegal component number for " + string + " on profile GLES1: " + n2);
                                }
                                return false;
                            }
                            case 32886: {
                                switch (n3) {
                                    case 5121: 
                                    case 5126: 
                                    case 5132: {
                                        break;
                                    }
                                    default: {
                                        if (bl2) {
                                            throw new GLException("Illegal data type for " + string + " on profile GLES1: " + n3);
                                        }
                                        return false;
                                    }
                                }
                                switch (n2) {
                                    case 0: 
                                    case 4: {
                                        break block0;
                                    }
                                }
                                if (bl2) {
                                    throw new GLException("Illegal component number for " + string + " on profile GLES1: " + n2);
                                }
                                return false;
                            }
                        }
                        break block86;
                    }
                    if (!this.isGLES2()) break block87;
                    switch (n3) {
                        case 5120: 
                        case 5121: 
                        case 5122: 
                        case 5123: 
                        case 5126: 
                        case 5132: {
                            break;
                        }
                        default: {
                            if (bl2) {
                                throw new GLException("Illegal data type for " + string + " on profile GLES2: " + n3);
                            }
                            return false;
                        }
                    }
                    switch (n2) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: {
                            break block86;
                        }
                        default: {
                            if (bl2) {
                                throw new GLException("Illegal component number for " + string + " on profile GLES1: " + n2);
                            }
                            return false;
                        }
                    }
                }
                if (!this.isGL2ES2()) break block86;
                if (!bl) break block88;
                switch (n3) {
                    case 5120: 
                    case 5121: 
                    case 5122: 
                    case 5123: 
                    case 5124: 
                    case 5125: 
                    case 5126: 
                    case 5130: {
                        break;
                    }
                    default: {
                        if (bl2) {
                            throw new GLException("Illegal data type for " + string + " on profile GL2: " + n3);
                        }
                        return false;
                    }
                }
                switch (n2) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        break block86;
                    }
                    default: {
                        if (bl2) {
                            throw new GLException("Illegal component number for " + string + " on profile GL2: " + n2);
                        }
                        return false;
                    }
                }
            }
            block35 : switch (n) {
                case 32884: {
                    switch (n3) {
                        case 5122: 
                        case 5124: 
                        case 5126: 
                        case 5130: {
                            break;
                        }
                        default: {
                            if (bl2) {
                                throw new GLException("Illegal data type for " + string + " on profile GL2: " + n3);
                            }
                            return false;
                        }
                    }
                    switch (n2) {
                        case 0: 
                        case 2: 
                        case 3: 
                        case 4: {
                            break block35;
                        }
                    }
                    if (bl2) {
                        throw new GLException("Illegal component number for " + string + " on profile GL2: " + n2);
                    }
                    return false;
                }
                case 32885: {
                    switch (n3) {
                        case 5120: 
                        case 5122: 
                        case 5124: 
                        case 5126: 
                        case 5130: {
                            break;
                        }
                        default: {
                            if (bl2) {
                                throw new GLException("Illegal data type for " + string + " on profile GL2: " + n3);
                            }
                            return false;
                        }
                    }
                    switch (n2) {
                        case 0: 
                        case 3: {
                            break block35;
                        }
                    }
                    if (bl2) {
                        throw new GLException("Illegal component number for " + string + " on profile GLES1: " + n2);
                    }
                    return false;
                }
                case 32886: {
                    switch (n3) {
                        case 5120: 
                        case 5121: 
                        case 5122: 
                        case 5123: 
                        case 5124: 
                        case 5125: 
                        case 5126: 
                        case 5130: {
                            break;
                        }
                        default: {
                            if (bl2) {
                                throw new GLException("Illegal data type for " + string + " on profile GL2: " + n3);
                            }
                            return false;
                        }
                    }
                    switch (n2) {
                        case 0: 
                        case 3: 
                        case 4: {
                            break block35;
                        }
                    }
                    if (bl2) {
                        throw new GLException("Illegal component number for " + string + " on profile GL2: " + n2);
                    }
                    return false;
                }
                case 32888: {
                    switch (n3) {
                        case 5122: 
                        case 5124: 
                        case 5126: 
                        case 5130: {
                            break;
                        }
                        default: {
                            if (bl2) {
                                throw new GLException("Illegal data type for " + string + " on profile GL2: " + n3);
                            }
                            return false;
                        }
                    }
                    switch (n2) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: {
                            break block35;
                        }
                    }
                    if (bl2) {
                        throw new GLException("Illegal component number for " + string + " on profile GL2: " + n2);
                    }
                    return false;
                }
            }
        }
        return true;
    }

    public String toString() {
        return "GLProfile[" + this.profile + "/" + this.profileImpl + "]";
    }

    private static void initProfilesForDefaultDevices(boolean bl) {
        boolean bl2;
        GLDynamicLookupHelper gLDynamicLookupHelper;
        if (DEBUG) {
            System.err.println("GLProfile.init firstUIActionOnProcess: " + bl + ", thread: " + Thread.currentThread().getName());
            System.err.println(VersionUtil.getPlatformInfo());
            System.err.println(GlueGenVersion.getInstance());
            System.err.println(NativeWindowVersion.getInstance());
            System.err.println((Object)JoglVersion.getInstance());
        }
        NativeWindowFactory.initSingleton((boolean)bl);
        ClassLoader classLoader = GLProfile.class.getClassLoader();
        isAWTAvailable = NativeWindowFactory.isAWTAvailable() && ReflectionUtil.isClassAvailable((String)"javax.media.opengl.awt.GLCanvas", (ClassLoader)classLoader);
        hasGL234Impl = ReflectionUtil.isClassAvailable((String)"com.jogamp.opengl.impl.gl4.GL4bcImpl", (ClassLoader)classLoader);
        Throwable throwable = null;
        try {
            desktopFactory = (GLDrawableFactoryImpl)GLDrawableFactory.getFactoryImpl(GL2);
            if (null != desktopFactory && null != (gLDynamicLookupHelper = (DesktopGLDynamicLookupHelper)desktopFactory.getGLDynamicLookupHelper(0))) {
                hasDesktopGL = gLDynamicLookupHelper.hasGLBinding();
            }
        }
        catch (LinkageError linkageError) {
            throwable = linkageError;
        }
        catch (RuntimeException runtimeException) {
            throwable = runtimeException;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
        }
        if (DEBUG) {
            if (null != throwable) {
                throwable.printStackTrace();
            }
            if (null == desktopFactory) {
                System.err.println("Info: GLProfile.init - Desktop GLDrawable factory not available");
            }
        }
        if (null == desktopFactory) {
            hasDesktopGL = false;
            hasGL234Impl = false;
        } else {
            defaultDevice = defaultDesktopDevice = desktopFactory.getDefaultDevice();
        }
        if (ReflectionUtil.isClassAvailable((String)"com.jogamp.opengl.impl.egl.EGLDrawableFactory", (ClassLoader)classLoader)) {
            throwable = null;
            try {
                eglFactory = (GLDrawableFactoryImpl)GLDrawableFactory.getFactoryImpl(GLES2);
                if (null != eglFactory) {
                    gLDynamicLookupHelper = eglFactory.getGLDynamicLookupHelper(2);
                    if (null != gLDynamicLookupHelper) {
                        hasGLES2Impl = gLDynamicLookupHelper.isLibComplete();
                    }
                    if (null != (gLDynamicLookupHelper = eglFactory.getGLDynamicLookupHelper(1))) {
                        hasGLES1Impl = gLDynamicLookupHelper.isLibComplete();
                    }
                }
            }
            catch (LinkageError linkageError) {
                throwable = linkageError;
            }
            catch (SecurityException securityException) {
                throwable = securityException;
            }
            catch (NullPointerException nullPointerException) {
                throwable = nullPointerException;
            }
            catch (RuntimeException runtimeException) {
                throwable = runtimeException;
            }
            if (DEBUG) {
                if (null != throwable) {
                    throwable.printStackTrace();
                }
                if (null == eglFactory) {
                    System.err.println("Info: GLProfile.init - EGL GLDrawable factory not available");
                }
            }
        }
        if (null == eglFactory) {
            hasGLES2Impl = false;
            hasGLES1Impl = false;
        } else {
            defaultEGLDevice = eglFactory.getDefaultDevice();
            if (null == defaultDevice) {
                defaultDevice = defaultEGLDevice;
            }
        }
        boolean bl3 = bl2 = GLProfile.initProfilesForDevice(defaultDesktopDevice) || GLProfile.initProfilesForDevice(defaultEGLDevice);
        if (DEBUG) {
            System.err.println("GLProfile.init isAWTAvailable       " + isAWTAvailable);
            System.err.println("GLProfile.init has desktopFactory   " + (null != desktopFactory));
            System.err.println("GLProfile.init hasDesktopGL         " + hasDesktopGL);
            System.err.println("GLProfile.init hasGL234Impl         " + hasGL234Impl);
            System.err.println("GLProfile.init has eglFactory       " + (null != eglFactory));
            System.err.println("GLProfile.init hasGLES1Impl         " + hasGLES1Impl);
            System.err.println("GLProfile.init hasGLES2Impl         " + hasGLES2Impl);
            System.err.println("GLProfile.init defaultDesktopDevice " + defaultDevice);
            System.err.println("GLProfile.init defaultEGLDevice     " + defaultDevice);
            System.err.println("GLProfile.init defaultDevice        " + defaultDevice);
        }
        if (!bl2) {
            throw new GLException("No profile available: " + GLProfile.array2String(GL_PROFILE_LIST_ALL) + ", " + GLProfile.glAvailabilityToString());
        }
    }

    private static synchronized boolean initProfilesForDevice(AbstractGraphicsDevice abstractGraphicsDevice) {
        boolean bl;
        boolean bl2 = GLContext.getAvailableGLVersionsSet(abstractGraphicsDevice);
        if (DEBUG) {
            String string = "Info: GLProfile.initProfilesForDevice: " + abstractGraphicsDevice.getConnection() + ", isSet " + bl2;
            Throwable throwable = new Throwable(string);
            throwable.printStackTrace();
        }
        if (bl2) {
            return null != GLProfile.getDefault(abstractGraphicsDevice);
        }
        boolean bl3 = false;
        boolean bl4 = false;
        if (hasDesktopGL && desktopFactory.getIsDeviceCompatible(abstractGraphicsDevice)) {
            GLProfile.computeProfileMap(abstractGraphicsDevice, true, true);
            bl = desktopFactory.getIsSharedContextAvailable(abstractGraphicsDevice);
            if (DEBUG) {
                System.err.println("GLProfile.initProfilesForDevice: " + abstractGraphicsDevice.getConnection() + ": desktop Shared Ctx " + bl);
            }
            if (null == GLContext.getAvailableGLVersion(abstractGraphicsDevice, 2, 2)) {
                GLContext.mapAvailableGLVersion(abstractGraphicsDevice, 2, 2, 1, 5, 34);
            }
            GLProfile.computeProfileMap(abstractGraphicsDevice, false, false);
            bl3 = null != GLProfile.getDefault(abstractGraphicsDevice);
        } else if (DEBUG) {
            System.err.println("GLProfile: DesktopFactory - Device is not available: " + abstractGraphicsDevice.getConnection());
        }
        if (null != eglFactory && (hasGLES2Impl || hasGLES1Impl) && eglFactory.getIsDeviceCompatible(abstractGraphicsDevice)) {
            GLProfile.computeProfileMap(abstractGraphicsDevice, false, true);
            bl = eglFactory.getIsSharedContextAvailable(abstractGraphicsDevice);
            if (DEBUG) {
                System.err.println("GLProfile.initProfilesForDevice: " + abstractGraphicsDevice.getConnection() + ": egl Shared Ctx " + bl);
            }
            if (hasGLES2Impl && null == GLContext.getAvailableGLVersion(abstractGraphicsDevice, 2, 8)) {
                GLContext.mapAvailableGLVersion(abstractGraphicsDevice, 2, 8, 2, 0, 40);
            }
            if (hasGLES1Impl && null == GLContext.getAvailableGLVersion(abstractGraphicsDevice, 1, 8)) {
                GLContext.mapAvailableGLVersion(abstractGraphicsDevice, 1, 8, 1, 0, 40);
            }
            GLProfile.computeProfileMap(abstractGraphicsDevice, false, false);
            bl4 = null != GLProfile.get(abstractGraphicsDevice, GL_PROFILE_LIST_GLES);
        } else if (DEBUG) {
            System.err.println("GLProfile: EGLFactory - Device is not available: " + abstractGraphicsDevice.getConnection());
        }
        if (!GLContext.getAvailableGLVersionsSet(abstractGraphicsDevice)) {
            GLContext.setAvailableGLVersionsSet(abstractGraphicsDevice);
        }
        if (DEBUG) {
            System.err.println("GLProfile.initProfilesForDevice: " + abstractGraphicsDevice.getConnection() + ": added profile(s): desktop " + bl3 + ", egl " + bl4);
            System.err.println("GLProfile.initProfilesForDevice: " + abstractGraphicsDevice.getConnection() + ": " + GLProfile.glAvailabilityToString(abstractGraphicsDevice));
            if (bl3) {
                GLProfile.dumpGLInfo(desktopFactory, abstractGraphicsDevice);
            }
            if (bl4) {
                GLProfile.dumpGLInfo(eglFactory, abstractGraphicsDevice);
            }
        }
        return bl3 || bl4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dumpGLInfo(GLDrawableFactoryImpl gLDrawableFactoryImpl, AbstractGraphicsDevice abstractGraphicsDevice) {
        GLContext gLContext = gLDrawableFactoryImpl.getOrCreateSharedContext(abstractGraphicsDevice);
        AbstractGraphicsDevice abstractGraphicsDevice2 = gLContext.getGLDrawable().getNativeSurface().getGraphicsConfiguration().getNativeGraphicsConfiguration().getScreen().getDevice();
        abstractGraphicsDevice2.lock();
        try {
            gLContext.makeCurrent();
            System.err.println(JoglVersion.getGLInfo(gLContext.getGL(), null));
            gLContext.release();
        }
        finally {
            abstractGraphicsDevice2.unlock();
        }
    }

    public static AbstractGraphicsDevice getDefaultDevice() {
        GLProfile.validateInitialization();
        return defaultDevice;
    }

    public static AbstractGraphicsDevice getDefaultDesktopDevice() {
        GLProfile.validateInitialization();
        return defaultDesktopDevice;
    }

    public static AbstractGraphicsDevice getDefaultEGLDevice() {
        GLProfile.validateInitialization();
        return defaultEGLDevice;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void validateInitialization() {
        if (!initialized) {
            Class clazz = GLProfile.class;
            synchronized (clazz) {
                if (!initialized) {
                    GLProfile.initSingleton(false);
                }
            }
        }
    }

    private static String array2String(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(stringArray[i]);
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private static void glAvailabilityToString(AbstractGraphicsDevice abstractGraphicsDevice, StringBuffer stringBuffer, int n, int n2) {
        String string = GLContext.getAvailableGLVersionAsString(abstractGraphicsDevice, n, n2);
        if (null == string) {
            throw new GLException("Internal Error");
        }
        stringBuffer.append("[");
        stringBuffer.append(string);
        stringBuffer.append("]");
    }

    private static void computeProfileMap(AbstractGraphicsDevice abstractGraphicsDevice, boolean bl, boolean bl2) {
        if (DEBUG) {
            System.err.println("GLProfile.init map " + abstractGraphicsDevice.getConnection() + ", desktopCtxUndef " + bl + ", eglCtxUndef " + bl2);
        }
        GLProfile gLProfile = null;
        HashMap<String, GLProfile> hashMap = new HashMap<String, GLProfile>(GL_PROFILE_LIST_ALL.length + 1);
        for (int i = 0; i < GL_PROFILE_LIST_ALL.length; ++i) {
            String string = GL_PROFILE_LIST_ALL[i];
            String string2 = GLProfile.computeProfileImpl(abstractGraphicsDevice, string, bl, bl2);
            if (null != string2) {
                GLProfile gLProfile2 = new GLProfile(string, string2);
                hashMap.put(string, gLProfile2);
                if (DEBUG) {
                    System.err.println("GLProfile.init map " + gLProfile2 + " on devide " + abstractGraphicsDevice.getConnection());
                }
                if (null != gLProfile) continue;
                gLProfile = gLProfile2;
                if (!DEBUG) continue;
                System.err.println("GLProfile.init map default " + gLProfile2 + " on device " + abstractGraphicsDevice.getConnection());
                continue;
            }
            if (!DEBUG) continue;
            System.err.println("GLProfile.init map *** no mapping for " + string + " on device " + abstractGraphicsDevice.getConnection());
        }
        if (null != gLProfile) {
            hashMap.put(GL_DEFAULT, gLProfile);
        }
        GLProfile.setProfileMap(abstractGraphicsDevice, hashMap);
    }

    private static String computeProfileImpl(AbstractGraphicsDevice abstractGraphicsDevice, String string, boolean bl, boolean bl2) {
        if (GL2ES1.equals(string)) {
            if (hasGL234Impl) {
                if (bl || GLContext.isGL2Available(abstractGraphicsDevice)) {
                    return GL2;
                }
                if (GLContext.isGL3bcAvailable(abstractGraphicsDevice)) {
                    return GL3bc;
                }
                if (GLContext.isGL4bcAvailable(abstractGraphicsDevice)) {
                    return GL4bc;
                }
            }
            if (hasGLES1Impl && (bl2 || GLContext.isGLES1Available(abstractGraphicsDevice))) {
                return GLES1;
            }
        } else if (GL2ES2.equals(string)) {
            if (hasGL234Impl) {
                if (bl || GLContext.isGL2Available(abstractGraphicsDevice)) {
                    return GL2;
                }
                if (GLContext.isGL3Available(abstractGraphicsDevice)) {
                    return GL3;
                }
                if (GLContext.isGL4Available(abstractGraphicsDevice)) {
                    return GL4;
                }
            }
            if (hasGLES2Impl && (bl2 || GLContext.isGLES2Available(abstractGraphicsDevice))) {
                return GLES2;
            }
        } else if (GL2GL3.equals(string)) {
            if (hasGL234Impl) {
                if (bl || GLContext.isGL2Available(abstractGraphicsDevice)) {
                    return GL2;
                }
                if (GLContext.isGL3bcAvailable(abstractGraphicsDevice)) {
                    return GL3bc;
                }
                if (GLContext.isGL4bcAvailable(abstractGraphicsDevice)) {
                    return GL4bc;
                }
                if (GLContext.isGL3Available(abstractGraphicsDevice)) {
                    return GL3;
                }
                if (GLContext.isGL4Available(abstractGraphicsDevice)) {
                    return GL4;
                }
            }
        } else {
            if (GL4bc.equals(string) && hasGL234Impl && (bl || GLContext.isGL4bcAvailable(abstractGraphicsDevice))) {
                return GL4bc;
            }
            if (GL4.equals(string) && hasGL234Impl && (bl || GLContext.isGL4Available(abstractGraphicsDevice))) {
                return GL4;
            }
            if (GL3bc.equals(string) && hasGL234Impl && (bl || GLContext.isGL3bcAvailable(abstractGraphicsDevice))) {
                return GL3bc;
            }
            if (GL3.equals(string) && hasGL234Impl && (bl || GLContext.isGL3Available(abstractGraphicsDevice))) {
                return GL3;
            }
            if (GL2.equals(string) && hasGL234Impl && (bl || GLContext.isGL2Available(abstractGraphicsDevice))) {
                return GL2;
            }
            if (GLES2.equals(string) && hasGLES2Impl && (bl2 || GLContext.isGLES2Available(abstractGraphicsDevice))) {
                return GLES2;
            }
            if (GLES1.equals(string) && hasGLES1Impl && (bl2 || GLContext.isGLES1Available(abstractGraphicsDevice))) {
                return GLES1;
            }
        }
        return null;
    }

    private static String getGLImplBaseClassName(String string) {
        if (GL4bc.equals(string) || GL4.equals(string) || GL3bc.equals(string) || GL3.equals(string) || GL2.equals(string)) {
            return "com.jogamp.opengl.impl.gl4.GL4bc";
        }
        if (GLES1.equals(string) || GL2ES1.equals(string)) {
            return "com.jogamp.opengl.impl.es1.GLES1";
        }
        if (GLES2.equals(string) || GL2ES2.equals(string)) {
            return "com.jogamp.opengl.impl.es2.GLES2";
        }
        throw new GLException("unsupported profile \"" + string + "\"");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HashMap getProfileMap(AbstractGraphicsDevice abstractGraphicsDevice) {
        String string;
        HashMap hashMap;
        GLProfile.validateInitialization();
        if (null == abstractGraphicsDevice) {
            abstractGraphicsDevice = defaultDevice;
        }
        if (null == (hashMap = (HashMap)deviceConn2ProfileMap.get(string = abstractGraphicsDevice.getUniqueID()))) {
            hashMap = new HashMap();
            HashMap hashMap2 = deviceConn2ProfileMap;
            synchronized (hashMap2) {
                deviceConn2ProfileMap.put(string, hashMap);
            }
            GLProfile.initProfilesForDevice(abstractGraphicsDevice);
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setProfileMap(AbstractGraphicsDevice abstractGraphicsDevice, HashMap hashMap) {
        GLProfile.validateInitialization();
        HashMap hashMap2 = deviceConn2ProfileMap;
        synchronized (hashMap2) {
            deviceConn2ProfileMap.put(abstractGraphicsDevice.getUniqueID(), hashMap);
        }
    }

    private GLProfile(String string, String string2) {
        this.profile = string;
        this.profileImpl = string2;
    }

    static {
        JVMUtil.initSingleton();
        initialized = false;
        deviceConn2ProfileMap = new HashMap();
    }
}

