/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util.glsl;

import com.jogamp.opengl.impl.Debug;
import com.jogamp.opengl.util.glsl.ShaderProgram;
import java.security.AccessController;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.media.opengl.GL2ES2;
import javax.media.opengl.GLArrayData;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLException;
import javax.media.opengl.GLUniformData;

public class ShaderState {
    public static final boolean DEBUG = Debug.isPropertyDefined("jogl.debug.GLSLState", true, AccessController.getContext());
    protected boolean verbose = false;
    protected ShaderProgram shaderProgram = null;
    protected HashMap attribMap2Idx = new HashMap();
    protected HashSet enabledVertexAttribArraySet = new HashSet();
    protected HashMap vertexAttribMap2Data = new HashMap();
    protected HashMap uniformMap2Idx = new HashMap();
    protected HashMap uniformMap2Data = new HashMap();

    public boolean verbose() {
        return this.verbose;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public static synchronized ShaderState getCurrent() {
        GLContext gLContext = GLContext.getCurrent();
        if (null == gLContext) {
            throw new GLException("No context is current on this thread");
        }
        return (ShaderState)gLContext.getAttachedObject(ShaderState.class.getName());
    }

    public synchronized void glUseProgram(GL2ES2 gL2ES2, boolean bl) {
        if (bl) {
            if (null == this.shaderProgram) {
                throw new GLException("No program is attached");
            }
            this.shaderProgram.glUseProgram(gL2ES2, true);
            gL2ES2.getContext().putAttachedObject(ShaderState.class.getName(), (Object)this);
        } else if (null != this.shaderProgram) {
            this.shaderProgram.glUseProgram(gL2ES2, false);
        }
    }

    public boolean linked() {
        return null != this.shaderProgram ? this.shaderProgram.linked() : false;
    }

    public boolean inUse() {
        return null != this.shaderProgram ? this.shaderProgram.inUse() : false;
    }

    public synchronized void attachShaderProgram(GL2ES2 gL2ES2, ShaderProgram shaderProgram) {
        boolean bl = false;
        if (DEBUG) {
            int n = null != this.shaderProgram ? this.shaderProgram.id() : -1;
            int n2 = null != shaderProgram ? shaderProgram.id() : -1;
            System.err.println("Info: attachShaderProgram: " + n + " -> " + n2 + "\n\t" + this.shaderProgram + "\n\t" + shaderProgram);
            if (this.verbose) {
                Throwable throwable = new Throwable("Info: attachShaderProgram: Trace");
                throwable.printStackTrace();
            }
        }
        if (null != this.shaderProgram) {
            if (this.shaderProgram.equals(shaderProgram)) {
                if (DEBUG) {
                    System.err.println("Info: attachShaderProgram: NOP: equal id: " + this.shaderProgram.id());
                }
                return;
            }
            bl = this.shaderProgram.inUse();
            this.shaderProgram.glUseProgram(gL2ES2, false);
        }
        this.shaderProgram = shaderProgram;
        if (null != this.shaderProgram) {
            this.shaderProgram.glUseProgram(gL2ES2, true);
            this.glResetAllVertexAttributes(gL2ES2);
            this.glResetAllUniforms(gL2ES2);
            if (!bl) {
                this.shaderProgram.glUseProgram(gL2ES2, false);
            }
        }
        if (DEBUG) {
            System.err.println("Info: attachShaderProgram: END");
        }
    }

    public ShaderProgram shaderProgram() {
        return this.shaderProgram;
    }

    public synchronized void destroy(GL2ES2 gL2ES2) {
        this.release(gL2ES2, true, true);
    }

    public synchronized void releaseAllData(GL2ES2 gL2ES2) {
        this.release(gL2ES2, false, false);
    }

    public synchronized void release(GL2ES2 gL2ES2, boolean bl, boolean bl2) {
        boolean bl3 = false;
        if (null != this.shaderProgram && !(bl3 = this.shaderProgram.inUse())) {
            this.shaderProgram.glUseProgram(gL2ES2, true);
        }
        this.glReleaseAllVertexAttributes(gL2ES2);
        this.glReleaseAllUniforms(gL2ES2);
        if (null != this.shaderProgram) {
            if (bl) {
                this.shaderProgram.release(gL2ES2, bl2);
            } else if (!bl3) {
                this.shaderProgram.glUseProgram(gL2ES2, false);
            }
        }
    }

    public void glBindAttribLocation(GL2ES2 gL2ES2, int n, String string) {
        if (null == this.shaderProgram) {
            throw new GLException("No program is attached");
        }
        if (this.shaderProgram.linked()) {
            throw new GLException("Program is already linked");
        }
        Integer n2 = new Integer(n);
        if (!this.attribMap2Idx.containsKey(string)) {
            this.attribMap2Idx.put(string, n2);
            gL2ES2.glBindAttribLocation(this.shaderProgram.program(), n, string);
        }
    }

    public int glGetAttribLocation(GL2ES2 gL2ES2, String string) {
        if (!this.shaderProgram.linked()) {
            throw new GLException("Program is not linked");
        }
        int n = this.getAttribLocation(string);
        if (0 > n) {
            n = gL2ES2.glGetAttribLocation(this.shaderProgram.program(), string);
            if (0 <= n) {
                Integer n2 = new Integer(n);
                this.attribMap2Idx.put(string, n2);
                if (DEBUG) {
                    System.err.println("Info: glGetAttribLocation: " + string + ", loc: " + n);
                }
            } else if (this.verbose) {
                Throwable throwable = new Throwable("Info: glGetAttribLocation failed, no location for: " + string + ", index: " + n);
                throwable.printStackTrace();
            }
        }
        return n;
    }

    protected int getAttribLocation(String string) {
        Integer n = (Integer)this.attribMap2Idx.get(string);
        return null != n ? n : -1;
    }

    public boolean glEnableVertexAttribArray(GL2ES2 gL2ES2, String string) {
        if (!this.shaderProgram.inUse()) {
            throw new GLException("Program is not in use");
        }
        this.enabledVertexAttribArraySet.add(string);
        int n = this.glGetAttribLocation(gL2ES2, string);
        if (0 > n) {
            if (this.verbose) {
                Throwable throwable = new Throwable("Info: glEnableVertexAttribArray failed, no index for: " + string);
                throwable.printStackTrace();
            }
            return false;
        }
        if (DEBUG) {
            System.err.println("Info: glEnableVertexAttribArray: " + string + ", loc: " + n);
        }
        gL2ES2.glEnableVertexAttribArray(n);
        return true;
    }

    public boolean isVertexAttribArrayEnabled(String string) {
        if (!this.shaderProgram.inUse()) {
            throw new GLException("Program is not in use");
        }
        return this.enabledVertexAttribArraySet.contains(string);
    }

    public boolean glDisableVertexAttribArray(GL2ES2 gL2ES2, String string) {
        if (!this.shaderProgram.inUse()) {
            throw new GLException("Program is not in use");
        }
        this.enabledVertexAttribArraySet.remove(string);
        int n = this.glGetAttribLocation(gL2ES2, string);
        if (0 > n) {
            if (this.verbose) {
                Throwable throwable = new Throwable("Info: glDisableVertexAttribArray failed, no index for: " + string);
                throwable.printStackTrace();
            }
            return false;
        }
        if (DEBUG) {
            System.err.println("Info: glDisableVertexAttribArray: " + string);
        }
        gL2ES2.glDisableVertexAttribArray(n);
        return true;
    }

    public boolean glVertexAttribPointer(GL2ES2 gL2ES2, GLArrayData gLArrayData) {
        int n;
        if (!this.shaderProgram.inUse()) {
            throw new GLException("Program is not in use");
        }
        if (!this.enabledVertexAttribArraySet.contains(gLArrayData.getName()) && !this.glEnableVertexAttribArray(gL2ES2, gLArrayData.getName()) && this.verbose) {
            Throwable throwable = new Throwable("Info: glVertexAttribPointer: couldn't enable: " + gLArrayData);
            throwable.printStackTrace();
        }
        if (0 > (n = this.getAttribLocation(gLArrayData.getName())) && this.verbose) {
            Throwable throwable = new Throwable("Info: glVertexAttribPointer failed, no index for: " + gLArrayData);
            throwable.printStackTrace();
        }
        gLArrayData.setLocation(n);
        this.vertexAttribMap2Data.put(gLArrayData.getName(), gLArrayData);
        if (0 <= n) {
            if (DEBUG) {
                System.err.println("Info: glVertexAttribPointer: " + gLArrayData);
            }
            gL2ES2.glVertexAttribPointer(gLArrayData);
            return true;
        }
        return false;
    }

    public GLArrayData getVertexAttribPointer(String string) {
        return (GLArrayData)this.vertexAttribMap2Data.get(string);
    }

    public void glReleaseAllVertexAttributes(GL2ES2 gL2ES2) {
        if (null != this.shaderProgram) {
            if (!this.shaderProgram.inUse()) {
                throw new GLException("Program is not in use");
            }
            Iterator<Object> iterator = this.vertexAttribMap2Data.keySet().iterator();
            while (iterator.hasNext()) {
                if (this.glDisableVertexAttribArray(gL2ES2, (String)iterator.next())) continue;
                throw new GLException("Internal Error: mapped vertex attribute couldn't be disabled");
            }
            iterator = this.enabledVertexAttribArraySet.iterator();
            while (iterator.hasNext()) {
                if (this.glDisableVertexAttribArray(gL2ES2, (String)iterator.next())) continue;
                throw new GLException("Internal Error: prev enabled vertex attribute couldn't be disabled");
            }
        }
        this.vertexAttribMap2Data.clear();
        this.enabledVertexAttribArraySet.clear();
        this.attribMap2Idx.clear();
    }

    public void glDisableAllVertexAttributeArrays(GL2ES2 gL2ES2, boolean bl) {
        if (!this.shaderProgram.inUse()) {
            throw new GLException("Program is not in use");
        }
        Iterator iterator = this.enabledVertexAttribArraySet.iterator();
        while (iterator.hasNext()) {
            int n;
            String string = (String)iterator.next();
            if (bl) {
                this.enabledVertexAttribArraySet.remove(string);
            }
            if (0 > (n = this.glGetAttribLocation(gL2ES2, string))) continue;
            gL2ES2.glDisableVertexAttribArray(n);
        }
    }

    public void glResetAllVertexAttributes(GL2ES2 gL2ES2) {
        if (!this.shaderProgram.inUse()) {
            throw new GLException("Program is not in use");
        }
        this.attribMap2Idx.clear();
        Iterator iterator = this.enabledVertexAttribArraySet.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            int n = this.glGetAttribLocation(gL2ES2, string);
            GLArrayData gLArrayData = this.getVertexAttribPointer(string);
            gLArrayData.setLocation(n);
            this.vertexAttribMap2Data.put(string, gLArrayData);
            if (0 > n) continue;
            gL2ES2.glEnableVertexAttribArray(n);
            if (gLArrayData.isVBO()) {
                gL2ES2.glBindBuffer(34962, gLArrayData.getVBOName());
            }
            gL2ES2.glVertexAttribPointer(gLArrayData);
        }
    }

    protected int glGetUniformLocation(GL2ES2 gL2ES2, String string) {
        if (!this.shaderProgram.inUse()) {
            throw new GLException("Program is not in use");
        }
        int n = this.getUniformLocation(string);
        if (0 > n) {
            n = gL2ES2.glGetUniformLocation(this.shaderProgram.program(), string);
            if (0 <= n) {
                Integer n2 = new Integer(n);
                this.uniformMap2Idx.put(string, n2);
            } else if (this.verbose) {
                Throwable throwable = new Throwable("Info: glUniform failed, no location for: " + string + ", index: " + n);
                throwable.printStackTrace();
            }
        }
        return n;
    }

    protected int getUniformLocation(String string) {
        Integer n = (Integer)this.uniformMap2Idx.get(string);
        return null != n ? n : -1;
    }

    public boolean glUniform(GL2ES2 gL2ES2, GLUniformData gLUniformData) {
        if (!this.shaderProgram.inUse()) {
            throw new GLException("Program is not in use");
        }
        int n = this.glGetUniformLocation(gL2ES2, gLUniformData.getName());
        gLUniformData.setLocation(n);
        this.uniformMap2Data.put(gLUniformData.getName(), gLUniformData);
        if (0 <= n) {
            if (DEBUG) {
                System.err.println("Info: glUniform: " + gLUniformData);
            }
            gL2ES2.glUniform(gLUniformData);
        }
        return true;
    }

    public GLUniformData getUniform(String string) {
        return (GLUniformData)this.uniformMap2Data.get(string);
    }

    public void glReleaseAllUniforms(GL2ES2 gL2ES2) {
        this.uniformMap2Data.clear();
        this.uniformMap2Idx.clear();
    }

    public void glResetAllUniforms(GL2ES2 gL2ES2) {
        if (!this.shaderProgram.inUse()) {
            throw new GLException("Program is not in use");
        }
        this.uniformMap2Idx.clear();
        Iterator iterator = this.uniformMap2Data.values().iterator();
        while (iterator.hasNext()) {
            this.glUniform(gL2ES2, (GLUniformData)iterator.next());
        }
    }

    public String toString() {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ShaderState[");
        stringBuffer.append(this.shaderProgram.toString());
        stringBuffer.append(",EnabledStates: [");
        Iterator<Object> iterator = this.enabledVertexAttribArraySet.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append("\n  ");
            stringBuffer.append((String)iterator.next());
        }
        stringBuffer.append("], [");
        iterator = this.vertexAttribMap2Data.values().iterator();
        while (iterator.hasNext()) {
            object = (GLArrayData)iterator.next();
            if (object.getLocation() < 0) continue;
            stringBuffer.append("\n  ");
            stringBuffer.append(object);
        }
        stringBuffer.append("], [");
        iterator = this.uniformMap2Data.values().iterator();
        while (iterator.hasNext()) {
            object = (GLUniformData)iterator.next();
            if (((GLUniformData)object).getLocation() < 0) continue;
            stringBuffer.append("\n  ");
            stringBuffer.append(object);
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

