/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.impl.x11.glx.awt;

import com.jogamp.nativewindow.impl.jawt.x11.X11SunJDKReflection;
import com.jogamp.nativewindow.impl.x11.X11Util;
import com.jogamp.opengl.impl.Debug;
import com.jogamp.opengl.impl.GLGraphicsConfigurationFactoryImpl;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.AbstractGraphicsScreen;
import javax.media.nativewindow.CapabilitiesChooser;
import javax.media.nativewindow.CapabilitiesImmutable;
import javax.media.nativewindow.GraphicsConfigurationFactory;
import javax.media.nativewindow.awt.AWTGraphicsConfiguration;
import javax.media.nativewindow.awt.AWTGraphicsDevice;
import javax.media.nativewindow.awt.AWTGraphicsScreen;
import javax.media.nativewindow.x11.X11GraphicsConfiguration;
import javax.media.nativewindow.x11.X11GraphicsDevice;
import javax.media.nativewindow.x11.X11GraphicsScreen;
import javax.media.opengl.GLCapabilitiesChooser;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLException;

public class X11AWTGLXGraphicsConfigurationFactory
extends GLGraphicsConfigurationFactoryImpl {
    protected static final boolean DEBUG = Debug.debug("GraphicsConfiguration");

    public X11AWTGLXGraphicsConfigurationFactory() {
        GraphicsConfigurationFactory.registerFactory((Class)AWTGraphicsDevice.class, (GraphicsConfigurationFactory)this);
    }

    protected AbstractGraphicsConfiguration chooseGraphicsConfigurationImpl(CapabilitiesImmutable capabilitiesImmutable, CapabilitiesImmutable capabilitiesImmutable2, CapabilitiesChooser capabilitiesChooser, AbstractGraphicsScreen abstractGraphicsScreen) {
        String string;
        GraphicsDevice graphicsDevice = null;
        if (abstractGraphicsScreen != null && !(abstractGraphicsScreen instanceof AWTGraphicsScreen)) {
            throw new IllegalArgumentException("This GraphicsConfigurationFactory accepts only AWTGraphicsScreen objects");
        }
        if (null == abstractGraphicsScreen) {
            abstractGraphicsScreen = AWTGraphicsScreen.createScreenDevice((int)-1, (int)0);
        }
        AWTGraphicsScreen aWTGraphicsScreen = (AWTGraphicsScreen)abstractGraphicsScreen;
        graphicsDevice = ((AWTGraphicsDevice)aWTGraphicsScreen.getDevice()).getGraphicsDevice();
        if (!(capabilitiesImmutable instanceof GLCapabilitiesImmutable)) {
            throw new IllegalArgumentException("This GraphicsConfigurationFactory accepts only GLCapabilities objects - chosen");
        }
        if (!(capabilitiesImmutable2 instanceof GLCapabilitiesImmutable)) {
            throw new IllegalArgumentException("This GraphicsConfigurationFactory accepts only GLCapabilities objects - requested");
        }
        if (capabilitiesChooser != null && !(capabilitiesChooser instanceof GLCapabilitiesChooser)) {
            throw new IllegalArgumentException("This GraphicsConfigurationFactory accepts only GLCapabilitiesChooser objects");
        }
        if (DEBUG) {
            System.err.println("X11AWTGLXGraphicsConfigurationFactory: got " + abstractGraphicsScreen);
        }
        long l = X11SunJDKReflection.graphicsDeviceGetDisplay((GraphicsDevice)graphicsDevice);
        boolean bl = false;
        if (0L == l) {
            l = X11Util.createDisplay(null);
            bl = true;
            if (DEBUG) {
                System.err.println("X11AWTGLXGraphicsConfigurationFactory: using a thread local X11 display");
            }
        } else {
            if (DEBUG) {
                System.err.println("X11AWTGLXGraphicsConfigurationFactory: using AWT X11 display 0x" + Long.toHexString(l));
            }
            string = X11Util.XDisplayString((long)l);
            l = X11Util.createDisplay((String)string);
            bl = true;
        }
        ((AWTGraphicsDevice)aWTGraphicsScreen.getDevice()).setSubType("X11", l);
        string = new X11GraphicsDevice(l, 0);
        string.setCloseDisplay(bl);
        X11GraphicsScreen x11GraphicsScreen = new X11GraphicsScreen((X11GraphicsDevice)string, aWTGraphicsScreen.getIndex());
        if (DEBUG) {
            System.err.println("X11AWTGLXGraphicsConfigurationFactory: made " + x11GraphicsScreen);
        }
        GraphicsConfigurationFactory graphicsConfigurationFactory = GraphicsConfigurationFactory.getFactory((AbstractGraphicsDevice)string);
        GraphicsConfiguration[] graphicsConfigurationArray = graphicsDevice.getConfigurations();
        X11GraphicsConfiguration x11GraphicsConfiguration = (X11GraphicsConfiguration)graphicsConfigurationFactory.chooseGraphicsConfiguration(capabilitiesImmutable, capabilitiesImmutable2, capabilitiesChooser, (AbstractGraphicsScreen)x11GraphicsScreen);
        if (x11GraphicsConfiguration == null) {
            throw new GLException("Unable to choose a GraphicsConfiguration (1): " + capabilitiesImmutable + ",\n\t" + capabilitiesChooser + "\n\t" + x11GraphicsScreen);
        }
        long l2 = x11GraphicsConfiguration.getVisualID();
        for (int i = 0; i < graphicsConfigurationArray.length; ++i) {
            GraphicsConfiguration graphicsConfiguration = graphicsConfigurationArray[i];
            if (graphicsConfiguration == null || (long)X11SunJDKReflection.graphicsConfigurationGetVisualID((GraphicsConfiguration)graphicsConfiguration) != l2) continue;
            if (DEBUG) {
                System.err.println("Found matching AWT visual: 0x" + Long.toHexString(l2) + " -> " + x11GraphicsConfiguration);
            }
            return new AWTGraphicsConfiguration(aWTGraphicsScreen, x11GraphicsConfiguration.getChosenCapabilities(), x11GraphicsConfiguration.getRequestedCapabilities(), graphicsConfiguration, (AbstractGraphicsConfiguration)x11GraphicsConfiguration);
        }
        GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
        x11GraphicsConfiguration = (X11GraphicsConfiguration)graphicsConfigurationFactory.chooseGraphicsConfiguration(capabilitiesImmutable = AWTGraphicsConfiguration.setupCapabilitiesRGBABits((CapabilitiesImmutable)capabilitiesImmutable, (GraphicsConfiguration)graphicsConfiguration), capabilitiesImmutable2, capabilitiesChooser, (AbstractGraphicsScreen)x11GraphicsScreen);
        if (x11GraphicsConfiguration == null) {
            throw new GLException("Unable to choose a GraphicsConfiguration (2): " + capabilitiesImmutable + ",\n\t" + capabilitiesChooser + "\n\t" + x11GraphicsScreen);
        }
        l2 = x11GraphicsConfiguration.getVisualID();
        for (int i = 0; i < graphicsConfigurationArray.length; ++i) {
            graphicsConfiguration = graphicsConfigurationArray[i];
            if ((long)X11SunJDKReflection.graphicsConfigurationGetVisualID((GraphicsConfiguration)graphicsConfiguration) != l2) continue;
            if (DEBUG) {
                System.err.println("Found matching default AWT visual: 0x" + Long.toHexString(l2) + " -> " + x11GraphicsConfiguration);
            }
            return new AWTGraphicsConfiguration(aWTGraphicsScreen, x11GraphicsConfiguration.getChosenCapabilities(), x11GraphicsConfiguration.getRequestedCapabilities(), graphicsConfiguration, (AbstractGraphicsConfiguration)x11GraphicsConfiguration);
        }
        if (DEBUG) {
            System.err.println("!!! Using default configuration");
        }
        graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
        return new AWTGraphicsConfiguration(aWTGraphicsScreen, x11GraphicsConfiguration.getChosenCapabilities(), x11GraphicsConfiguration.getRequestedCapabilities(), graphicsConfiguration, (AbstractGraphicsConfiguration)x11GraphicsConfiguration);
    }
}

