/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.updatesite.metadata;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URI;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.filetransfer.UserCancelledException;
import org.eclipse.equinox.internal.p2.metadata.repository.LocalMetadataRepository;
import org.eclipse.equinox.internal.p2.repository.AuthenticationFailedException;
import org.eclipse.equinox.internal.p2.updatesite.Activator;
import org.eclipse.equinox.internal.p2.updatesite.RemoteUpdateSiteAction;
import org.eclipse.equinox.internal.p2.updatesite.UpdateSite;
import org.eclipse.equinox.internal.p2.updatesite.metadata.Messages;
import org.eclipse.equinox.internal.p2.updatesite.metadata.UpdateSiteMetadataRepository;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepository;
import org.eclipse.equinox.internal.provisional.spi.p2.metadata.repository.MetadataRepositoryFactory;
import org.eclipse.equinox.internal.provisional.spi.p2.metadata.repository.SimpleMetadataRepositoryFactory;
import org.eclipse.equinox.p2.publisher.IPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.Publisher;
import org.eclipse.equinox.p2.publisher.PublisherInfo;
import org.eclipse.osgi.util.NLS;

public class UpdateSiteMetadataRepositoryFactory
extends MetadataRepositoryFactory {
    private static final String PROP_SITE_CHECKSUM = "site.checksum";

    public static URI getLocalRepositoryLocation(URI location) {
        String stateDirName = Integer.toString(location.hashCode());
        File bundleData = Activator.getBundleContext().getDataFile(null);
        File stateDir = new File(bundleData, stateDirName);
        return stateDir.toURI();
    }

    public IMetadataRepository create(URI location, String name, String type, Map properties) {
        return null;
    }

    public IStatus validate(URI location, IProgressMonitor monitor) {
        try {
            UpdateSite.validate(location, monitor);
        }
        catch (ProvisionException e) {
            return e.getStatus();
        }
        catch (UserCancelledException userCancelledException) {
            return Status.CANCEL_STATUS;
        }
        catch (AuthenticationFailedException e) {
            return new Status(4, Activator.ID, 1007, NLS.bind((String)Messages.AuthenticationFailedFor_0, (Object)location.toString()), (Throwable)e);
        }
        catch (FileNotFoundException e) {
            return new Status(4, Activator.ID, 1000, NLS.bind((String)Messages.RepositoryNotFound_0, (Object)location.toString()), (Throwable)e);
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        return Status.OK_STATUS;
    }

    public IMetadataRepository load(URI location, int flags, IProgressMonitor monitor) throws ProvisionException {
        if ((flags & 1) > 0) {
            return null;
        }
        IMetadataRepository repository = this.loadRepository(location, monitor);
        try {
            this.initializeRepository(repository, location, monitor);
        }
        catch (Exception e) {
            this.resetCache(repository);
            if (e instanceof ProvisionException) {
                throw (ProvisionException)((Object)e);
            }
            if (e instanceof OperationCanceledException) {
                throw (OperationCanceledException)((Object)e);
            }
            throw new ProvisionException((IStatus)new Status(4, Activator.ID, NLS.bind((String)Messages.Unexpected_exception, (Object)location.toString()), (Throwable)e));
        }
        return new UpdateSiteMetadataRepository(location, repository);
    }

    private void resetCache(IMetadataRepository repository) {
        repository.setProperty(PROP_SITE_CHECKSUM, "0");
        repository.removeAll();
    }

    public IMetadataRepository loadRepository(URI location, IProgressMonitor monitor) {
        URI localRepositoryURL = UpdateSiteMetadataRepositoryFactory.getLocalRepositoryLocation(location);
        SimpleMetadataRepositoryFactory factory = new SimpleMetadataRepositoryFactory();
        try {
            return factory.load(localRepositoryURL, 0, monitor);
        }
        catch (ProvisionException provisionException) {
            String repositoryName = "update site: " + location;
            return factory.create(localRepositoryURL, repositoryName, null, null);
        }
    }

    public void initializeRepository(IMetadataRepository repository, URI location, IProgressMonitor monitor) throws ProvisionException {
        UpdateSite updateSite = UpdateSite.load(location, monitor);
        String savedChecksum = (String)repository.getProperties().get(PROP_SITE_CHECKSUM);
        if (savedChecksum != null && savedChecksum.equals(updateSite.getChecksum())) {
            return;
        }
        repository.setProperty(PROP_SITE_CHECKSUM, updateSite.getChecksum());
        repository.removeAll();
        IStatus status = this.generateMetadata(updateSite, repository, monitor);
        if (repository instanceof LocalMetadataRepository) {
            ((LocalMetadataRepository)repository).publishRepositoryReferences();
        }
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (!status.isOK()) {
            throw new ProvisionException(status);
        }
    }

    private IStatus generateMetadata(UpdateSite updateSite, IMetadataRepository repository, IProgressMonitor monitor) {
        PublisherInfo info = new PublisherInfo();
        info.setMetadataRepository(repository);
        IPublisherAction[] actions = new IPublisherAction[]{new RemoteUpdateSiteAction(updateSite, null)};
        Publisher publisher = new Publisher((IPublisherInfo)info);
        return publisher.publish(actions, monitor);
    }
}

