/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects.time;

import ch.kuramo.javie.api.IAnimatableDouble;
import ch.kuramo.javie.api.IAnimatableEnum;
import ch.kuramo.javie.api.IAnimatableValue;
import ch.kuramo.javie.api.IAudioBuffer;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.api.annotations.Effect;
import ch.kuramo.javie.api.annotations.Property;
import ch.kuramo.javie.api.services.IAudioEffectContext;
import ch.kuramo.javie.api.services.IEffectContext;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import com.google.inject.Inject;

@Effect(id="ch.kuramo.javie.TimeShift", category="ch.kuramo.javie.api.effectCategory.time")
public class TimeShift {
    @Property
    private IAnimatableDouble timeShift;
    @Property(value="VIDEO_AND_AUDIO")
    private IAnimatableEnum<Track> track;
    private final IVideoEffectContext videoContext;
    private final IAudioEffectContext audioContext;

    @Inject
    public TimeShift(IVideoEffectContext videoContext, IAudioEffectContext audioContext) {
        this.videoContext = videoContext;
        this.audioContext = audioContext;
    }

    private void shiftTime(IEffectContext context) {
        Time time = context.getTime();
        double timeShift = (Double)context.value((IAnimatableValue)this.timeShift);
        long timeValue = (long)((double)time.timeValue + timeShift * (double)time.timeScale);
        context.setTime(new Time(timeValue, time.timeScale));
    }

    public IVideoBuffer doVideoEffect() {
        if (this.videoContext.value(this.track) != Track.AUDIO) {
            this.shiftTime((IEffectContext)this.videoContext);
        }
        return this.videoContext.doPreviousEffect();
    }

    public IAudioBuffer doAudioEffect() {
        if (this.audioContext.value(this.track) != Track.VIDEO) {
            this.shiftTime((IEffectContext)this.audioContext);
        }
        return this.audioContext.doPreviousEffect();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Track {
        BOTH,
        VIDEO,
        AUDIO;

    }
}

