/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects.generate;

import ch.kuramo.javie.api.BlendMode;
import ch.kuramo.javie.api.Color;
import ch.kuramo.javie.api.ColorMode;
import ch.kuramo.javie.api.IAnimatableBoolean;
import ch.kuramo.javie.api.IAnimatableColor;
import ch.kuramo.javie.api.IAnimatableDouble;
import ch.kuramo.javie.api.IAnimatableEnum;
import ch.kuramo.javie.api.IAnimatableValue;
import ch.kuramo.javie.api.IAnimatableVec2d;
import ch.kuramo.javie.api.IArray;
import ch.kuramo.javie.api.IShaderProgram;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.Quality;
import ch.kuramo.javie.api.Resolution;
import ch.kuramo.javie.api.Vec2d;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.annotations.Effect;
import ch.kuramo.javie.api.annotations.Property;
import ch.kuramo.javie.api.annotations.ShaderSource;
import ch.kuramo.javie.api.services.IArrayPools;
import ch.kuramo.javie.api.services.IBlendSupport;
import ch.kuramo.javie.api.services.IShaderRegistry;
import ch.kuramo.javie.api.services.ITexture1DSupport;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import ch.kuramo.javie.api.services.IVideoRenderSupport;
import com.google.inject.Inject;
import java.nio.FloatBuffer;
import java.util.HashSet;
import javax.media.opengl.GL2;
import javax.media.opengl.GLUniformData;
import javax.media.opengl.glu.GLU;
import javax.media.opengl.glu.GLUquadric;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Effect(id="ch.kuramo.javie.Circle", category="ch.kuramo.javie.api.effectCategory.generate")
public class Circle {
    @Property
    private IAnimatableVec2d location;
    @Property(value="75", min="0")
    private IAnimatableDouble radius;
    @Property(value="0.5")
    private IAnimatableVec2d anchor;
    @Property
    private IAnimatableEnum<Edge> edge;
    @Property(value="10", min="0")
    private IAnimatableDouble edgeRadius;
    @Property(value="10", min="0", max="4000")
    private IAnimatableDouble thickness;
    @Property(min="0", max="4000")
    private IAnimatableDouble outerFeather;
    @Property(min="0", max="4000")
    private IAnimatableDouble innerFeather;
    @Property
    private IAnimatableBoolean invert;
    @Property(value="1,1,1")
    private IAnimatableColor color;
    @Property(value="100", min="0", max="100")
    private IAnimatableDouble opacity;
    @Property
    private IAnimatableEnum<BlendMode> blendMode;
    private final IVideoEffectContext context;
    private final IVideoRenderSupport support;
    private final IBlendSupport blendSupport;
    private final ITexture1DSupport tex1DSupport;
    private final IArrayPools arrayPools;
    private final IShaderProgram circleSamplerProgram;
    private final IShaderProgram invertSamplerProgram;
    @ShaderSource
    public static final String[] CIRCLE_SAMPLER = Circle.createSamplerProgram(false);
    @ShaderSource
    public static final String[] INVERT_SAMPLER = Circle.createSamplerProgram(true);

    @Inject
    public Circle(IVideoEffectContext context, IVideoRenderSupport support, IBlendSupport blendSupport, ITexture1DSupport tex1DSupport, IArrayPools arrayPools, IShaderRegistry shaders) {
        this.context = context;
        this.support = support;
        this.blendSupport = blendSupport;
        this.tex1DSupport = tex1DSupport;
        this.arrayPools = arrayPools;
        this.circleSamplerProgram = shaders.getProgram(Circle.class, "CIRCLE_SAMPLER");
        this.invertSamplerProgram = shaders.getProgram(Circle.class, "INVERT_SAMPLER");
    }

    public IVideoBuffer doVideoEffect() {
        IVideoBuffer original;
        VideoBounds bounds;
        BlendMode blendMode = (BlendMode)this.context.value(this.blendMode);
        if (blendMode == BlendMode.NONE) {
            bounds = this.context.getPreviousBounds();
            original = this.context.createVideoBuffer(bounds);
        } else {
            original = this.context.doPreviousEffect();
            bounds = original.getBounds();
        }
        if (bounds.isEmpty()) {
            return original;
        }
        CircleParams params = null;
        IVideoBuffer circle = null;
        try {
            final CircleParams p = params = new CircleParams();
            circle = this.context.createVideoBuffer(bounds);
            if (p.invert) {
                circle.clear(p.color);
            } else {
                circle.clear();
            }
            IShaderProgram program = p.invert ? this.invertSamplerProgram : this.circleSamplerProgram;
            HashSet<GLUniformData> uniforms = new HashSet<GLUniformData>();
            uniforms.add(new GLUniformData("texInner", 0));
            uniforms.add(new GLUniformData("texOuter", 1));
            uniforms.add(new GLUniformData("texSize", 2, FloatBuffer.wrap(new float[]{p.texSize[0], p.texSize[1]})));
            uniforms.add(new GLUniformData("texOffset", 2, FloatBuffer.wrap(new float[]{(float)((double)p.texSize[0] * 0.5 - p.innerMiddle), (float)((double)p.texSize[1] * 0.5 - p.outerMiddle)})));
            uniforms.add(new GLUniformData("center", 2, FloatBuffer.wrap(new float[]{(float)(((CircleParams)p).center.x - bounds.x), (float)(((CircleParams)p).center.y - bounds.y)})));
            uniforms.add(new GLUniformData("color", 4, FloatBuffer.wrap(new float[]{(float)((CircleParams)p).color.r, (float)((CircleParams)p).color.g, (float)((CircleParams)p).color.b, (float)((CircleParams)p).color.a})));
            Runnable operation = new Runnable(){

                public void run() {
                    GL2 gl = Circle.this.context.getGL().getGL2();
                    GLU glu = Circle.this.context.getGLU();
                    Circle.this.support.ortho2D(bounds);
                    gl.glMatrixMode(5888);
                    gl.glTranslatef((float)((CircleParams)p).center.x, (float)((CircleParams)p).center.y, 0.0f);
                    gl.glActiveTexture(33984);
                    gl.glBindTexture(3552, p.texture[0]);
                    gl.glActiveTexture(33985);
                    gl.glBindTexture(3552, p.texture[1]);
                    GLUquadric quadric = glu.gluNewQuadric();
                    try {
                        glu.gluQuadricDrawStyle(quadric, 100012);
                        glu.gluQuadricNormals(quadric, 100002);
                        int slices = (int)Math.ceil(Math.PI * 2 * p.outerRadius);
                        glu.gluDisk(quadric, Math.max(0.0, p.innerRadius - 2.0), p.outerRadius + 2.0, slices, 1);
                    }
                    finally {
                        glu.gluDeleteQuadric(quadric);
                    }
                }
            };
            this.support.useShaderProgram(program, uniforms, operation, 262144, circle, new IVideoBuffer[0]);
            if (blendMode == BlendMode.NONE && p.opacity == 1.0) {
                IVideoBuffer result = circle;
                circle = null;
                IVideoBuffer iVideoBuffer = result;
                return iVideoBuffer;
            }
            IVideoBuffer iVideoBuffer = this.blendSupport.blend(circle, original, null, blendMode, p.opacity, this.context);
            return iVideoBuffer;
        }
        finally {
            if (original != null) {
                original.dispose();
            }
            if (circle != null) {
                circle.dispose();
            }
            if (params != null) {
                this.deleteTextures(params.texture);
            }
        }
    }

    private int[] createCircleTextures(double innerMiddle, double innerFeather, double outerFeather, int[] texSize) {
        int[] nArray;
        IArray<float[]> data1;
        int tex1;
        int tex0;
        block11: {
            Quality quality = this.context.getQuality();
            Resolution resolution = this.context.getVideoResolution();
            ColorMode colorMode = this.context.getColorMode();
            int internalFormat = quality == Quality.DRAFT || resolution.scale < 1.0 ? 32828 : (colorMode == ColorMode.RGBA32_FLOAT ? 34838 : (colorMode == ColorMode.RGBA16_FLOAT ? 34844 : (quality == Quality.BEST ? 34844 : 32828)));
            tex0 = 0;
            tex1 = 0;
            IArray<float[]> data0 = null;
            data1 = null;
            try {
                if (innerMiddle <= 0.0 && innerFeather == 0.0) {
                    tex0 = this.tex1DSupport.texture1DFromArray(new float[]{1.0f, 1.0f}, 6406, 32828);
                    texSize[0] = 2;
                } else {
                    data0 = this.createCircleData(true, innerFeather);
                    tex0 = this.tex1DSupport.texture1DFromArray(data0, 6406, internalFormat);
                    texSize[0] = data0.getLength();
                }
                data1 = this.createCircleData(false, outerFeather);
                tex1 = this.tex1DSupport.texture1DFromArray(data1, 6406, internalFormat);
                texSize[1] = data1.getLength();
                int[] result = new int[]{tex0, tex1};
                tex1 = 0;
                tex0 = 0;
                nArray = result;
                if (data0 == null) break block11;
            }
            catch (Throwable throwable) {
                if (data0 != null) {
                    data0.release();
                }
                if (data1 != null) {
                    data1.release();
                }
                if (tex0 != 0) {
                    this.deleteTextures(tex0);
                }
                if (tex1 != 0) {
                    this.deleteTextures(tex1);
                }
                throw throwable;
            }
            data0.release();
        }
        if (data1 != null) {
            data1.release();
        }
        if (tex0 != 0) {
            this.deleteTextures(tex0);
        }
        if (tex1 != 0) {
            this.deleteTextures(tex1);
        }
        return nArray;
    }

    private IArray<float[]> createCircleData(boolean inner, double feather) {
        int halfLen = (int)Math.ceil(feather) + 1;
        IArray data = this.arrayPools.getFloatArray(halfLen * 2);
        float[] array = (float[])data.getArray();
        int arrayLen = data.getLength();
        double lowerOutside = !inner ? 1 : 0;
        double upperOutside = inner ? 1 : 0;
        double offset = (double)halfLen + (inner ? -feather : feather);
        int i = 0;
        while (i < arrayLen) {
            double r = (double)i + 0.5;
            double d = r <= (double)halfLen - feather ? lowerOutside : (r >= (double)halfLen + feather ? upperOutside : 0.5 * (1.0 - Math.cos(Math.PI * 2 * (r - offset) / (4.0 * feather))));
            array[i] = (float)d;
            ++i;
        }
        return data;
    }

    private void deleteTextures(int ... texture) {
        GL2 gl = this.context.getGL().getGL2();
        gl.glDeleteTextures(texture.length, texture, 0);
    }

    private static final String[] createSamplerProgram(boolean invert) {
        return new String[]{"uniform sampler1D texInner;", "uniform sampler1D texOuter;", "uniform vec2 texSize;", "uniform vec2 texOffset;", "uniform vec2 center;", "uniform vec4 color;", "", "void main(void)", "{", "\tfloat d = distance(center, gl_FragCoord.st);", "\tvec2 texCoord = (vec2(d, d) + texOffset) / texSize;", "", "\tfloat inner = texture1D(texInner, texCoord.x).a;", "\tfloat outer = texture1D(texOuter, texCoord.y).a;", "", invert ? "\tgl_FragColor = color * (1.0-inner*outer);" : "\tgl_FragColor = color * (inner*outer);", "}"};
    }

    private class CircleParams {
        private final Vec2d center;
        private final boolean invert;
        private final Color color;
        private final double opacity;
        private final double innerRadius;
        private final double outerRadius;
        private final double innerMiddle;
        private final double outerMiddle;
        private final int[] texture;
        private final int[] texSize = new int[2];

        private CircleParams() {
            Resolution resolution = Circle.this.context.getVideoResolution();
            Vec2d location = (Vec2d)Circle.this.context.value((IAnimatableValue)Circle.this.location);
            double radius = (Double)Circle.this.context.value((IAnimatableValue)Circle.this.radius);
            Vec2d anchor = (Vec2d)Circle.this.context.value((IAnimatableValue)Circle.this.anchor);
            this.center = resolution.scale(new Vec2d(location.x - radius * (anchor.x - 0.5) * 2.0, location.y - radius * (anchor.y - 0.5) * 2.0));
            radius = resolution.scale(radius);
            Edge edge = (Edge)((Object)Circle.this.context.value((IAnimatableValue)Circle.this.edge));
            this.invert = (Boolean)Circle.this.context.value((IAnimatableValue)Circle.this.invert);
            this.opacity = (Double)Circle.this.context.value((IAnimatableValue)Circle.this.opacity) / 100.0;
            Color color = (Color)Circle.this.context.value((IAnimatableValue)Circle.this.color);
            double a = color.a;
            this.color = new Color(color.r * a, color.g * a, color.b * a, a);
            double edgeRadius = 0.0;
            double thickness = 0.0;
            double innerFeather = 0.0;
            double outerFeather = 0.0;
            switch (edge) {
                case NONE: {
                    outerFeather = resolution.scale(((Double)Circle.this.context.value((IAnimatableValue)Circle.this.outerFeather)).doubleValue());
                    break;
                }
                case EDGE_RADIUS: {
                    edgeRadius = resolution.scale(((Double)Circle.this.context.value((IAnimatableValue)Circle.this.edgeRadius)).doubleValue());
                    if (edgeRadius > radius) {
                        double tmp = edgeRadius;
                        edgeRadius = radius;
                        radius = tmp;
                    }
                    innerFeather = resolution.scale(((Double)Circle.this.context.value((IAnimatableValue)Circle.this.innerFeather)).doubleValue());
                    outerFeather = resolution.scale(((Double)Circle.this.context.value((IAnimatableValue)Circle.this.outerFeather)).doubleValue());
                    break;
                }
                case THICKNESS: {
                    thickness = resolution.scale(((Double)Circle.this.context.value((IAnimatableValue)Circle.this.thickness)).doubleValue());
                    innerFeather = resolution.scale(((Double)Circle.this.context.value((IAnimatableValue)Circle.this.innerFeather)).doubleValue());
                    outerFeather = resolution.scale(((Double)Circle.this.context.value((IAnimatableValue)Circle.this.outerFeather)).doubleValue());
                    break;
                }
                case P_THICKNESS: {
                    thickness = (Double)Circle.this.context.value((IAnimatableValue)Circle.this.thickness) * radius / 100.0;
                    innerFeather = resolution.scale(((Double)Circle.this.context.value((IAnimatableValue)Circle.this.innerFeather)).doubleValue());
                    outerFeather = resolution.scale(((Double)Circle.this.context.value((IAnimatableValue)Circle.this.outerFeather)).doubleValue());
                    break;
                }
                case P_THICKNESS_P_FEATHER: {
                    thickness = (Double)Circle.this.context.value((IAnimatableValue)Circle.this.thickness) * radius / 100.0;
                    innerFeather = (Double)Circle.this.context.value((IAnimatableValue)Circle.this.innerFeather) * radius / 100.0;
                    outerFeather = (Double)Circle.this.context.value((IAnimatableValue)Circle.this.outerFeather) * radius / 100.0;
                }
            }
            switch (edge) {
                case NONE: {
                    this.innerRadius = 0.0;
                    this.outerRadius = radius + outerFeather;
                    this.innerMiddle = 0.0;
                    this.outerMiddle = radius;
                    break;
                }
                case EDGE_RADIUS: {
                    this.innerRadius = Math.max(0.0, edgeRadius - innerFeather);
                    this.outerRadius = radius + outerFeather;
                    this.innerMiddle = edgeRadius;
                    this.outerMiddle = radius;
                    break;
                }
                default: {
                    this.innerRadius = Math.max(0.0, radius - thickness * 0.5 - innerFeather);
                    this.outerRadius = radius + thickness * 0.5 + outerFeather;
                    this.innerMiddle = radius - thickness * 0.5;
                    this.outerMiddle = radius + thickness * 0.5;
                }
            }
            this.texture = Circle.this.createCircleTextures(this.innerMiddle, innerFeather, outerFeather, this.texSize);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Edge {
        NONE,
        EDGE_RADIUS,
        THICKNESS,
        P_THICKNESS,
        P_THICKNESS_P_FEATHER;

    }
}

