/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.publisher;

import java.net.URI;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.core.helpers.Tracing;
import org.eclipse.equinox.internal.p2.metadata.repository.Messages;
import org.eclipse.equinox.internal.p2.publisher.Activator;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepository;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepository;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.publisher.IPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.IPublisherResult;
import org.eclipse.equinox.p2.publisher.PublisherResult;
import org.osgi.framework.BundleContext;

public class Publisher {
    public static final String PUBLISH_PACK_FILES_AS_SIBLINGS = "publishPackFilesAsSiblings";
    private IPublisherInfo info;
    private IPublisherResult results;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static IMetadataRepository createMetadataRepository(URI location, String name, boolean append, boolean compress) throws ProvisionException {
        String repositoryName;
        IMetadataRepositoryManager manager;
        IMetadataRepository result;
        Class<?> clazz;
        try {
            IMetadataRepository result2 = Publisher.loadMetadataRepository(location, true, true);
            if (result2 != null && result2.isModifiable()) {
                result2.setProperty("p2.compressed", compress ? "true" : "false");
                if (!append) {
                    result2.removeAll();
                }
                return result2;
            }
        }
        catch (ProvisionException provisionException) {}
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((result = (manager = (IMetadataRepositoryManager)ServiceHelper.getService((BundleContext)Activator.context, (String)clazz.getName())).createRepository(location, repositoryName = name == null ? location + " - metadata" : name, "org.eclipse.equinox.p2.metadata.repository.simpleRepository", null)) != null) {
            manager.removeRepository(result.getLocation());
            result.setProperty("p2.compressed", compress ? "true" : "false");
            return result;
        }
        String msg = Messages.repoMan_internalError;
        throw new ProvisionException((IStatus)new Status(4, Activator.ID, 1, msg, null));
    }

    public static IMetadataRepository loadMetadataRepository(URI location, boolean modifiable, boolean removeFromManager) throws ProvisionException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IMetadataRepositoryManager manager = (IMetadataRepositoryManager)ServiceHelper.getService((BundleContext)Activator.context, (String)clazz.getName());
        boolean existing = manager.contains(location);
        IMetadataRepository result = manager.loadRepository(location, modifiable ? 1 : 0, null);
        if (!existing && removeFromManager) {
            manager.removeRepository(location);
        }
        return result;
    }

    public static IArtifactRepository createArtifactRepository(URI location, String name, boolean append, boolean compress, boolean reusePackedFiles) throws ProvisionException {
        String repositoryName;
        IArtifactRepositoryManager manager;
        IArtifactRepository result;
        Class<?> clazz;
        try {
            IArtifactRepository result2 = Publisher.loadArtifactRepository(location, true, true);
            if (result2 != null && result2.isModifiable()) {
                result2.setProperty("p2.compressed", compress ? "true" : "false");
                if (reusePackedFiles) {
                    result2.setProperty(PUBLISH_PACK_FILES_AS_SIBLINGS, "true");
                }
                if (!append) {
                    result2.removeAll();
                }
                return result2;
            }
        }
        catch (ProvisionException provisionException) {}
        if ((clazz = class$1) == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((result = (manager = (IArtifactRepositoryManager)ServiceHelper.getService((BundleContext)Activator.context, (String)clazz.getName())).createRepository(location, repositoryName = name != null ? name : location + " - artifacts", "org.eclipse.equinox.p2.artifact.repository.simpleRepository", null)) != null) {
            manager.removeRepository(result.getLocation());
            if (reusePackedFiles) {
                result.setProperty(PUBLISH_PACK_FILES_AS_SIBLINGS, "true");
            }
            result.setProperty("p2.compressed", compress ? "true" : "false");
            return result;
        }
        String msg = org.eclipse.equinox.internal.p2.artifact.repository.Messages.repoMan_internalError;
        throw new ProvisionException((IStatus)new Status(4, Activator.ID, 1, msg, null));
    }

    public static IArtifactRepository loadArtifactRepository(URI location, boolean modifiable, boolean removeFromManager) throws ProvisionException {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IArtifactRepositoryManager manager = (IArtifactRepositoryManager)ServiceHelper.getService((BundleContext)Activator.context, (String)clazz.getName());
        boolean existing = manager.contains(location);
        IArtifactRepository result = manager.loadRepository(location, modifiable ? 1 : 0, null);
        if (!existing && removeFromManager) {
            manager.removeRepository(location);
        }
        return result;
    }

    public Publisher(IPublisherInfo info) {
        this.info = info;
        this.results = new PublisherResult();
    }

    public Publisher(IPublisherInfo info, IPublisherResult results) {
        this.info = info;
        this.results = results;
    }

    public IStatus publish(IPublisherAction[] actions, IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)actions.length);
        if (Tracing.DEBUG_PUBLISHING) {
            Tracing.debug((String)"Invoking publisher");
        }
        try {
            MultiStatus finalStatus = new MultiStatus("this", 0, "publishing result", null);
            int i = 0;
            while (i < actions.length) {
                if (sub.isCanceled()) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                IStatus status = actions[i].perform(this.info, this.results, monitor);
                finalStatus.merge(status);
                sub.worked(1);
                ++i;
            }
            if (Tracing.DEBUG_PUBLISHING) {
                Tracing.debug((String)("Publishing complete. Result=" + finalStatus));
            }
            if (!finalStatus.isOK()) {
                MultiStatus multiStatus = finalStatus;
                return multiStatus;
            }
        }
        finally {
            sub.done();
        }
        IMetadataRepository metadataRepository = this.info.getMetadataRepository();
        if (metadataRepository != null) {
            Collection ius = this.results.getIUs(null, null);
            metadataRepository.addInstallableUnits(ius.toArray(new IInstallableUnit[ius.size()]));
        }
        return Status.OK_STATUS;
    }
}

