/*
 * Decompiled with CFR 0.152.
 */
package javax.media.nativewindow;

import com.jogamp.nativewindow.impl.NativeWindowFactoryImpl;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.NativeWindowException;
import javax.media.nativewindow.NativeWindowFactory;
import javax.media.nativewindow.ToolkitLock;

public class DefaultGraphicsDevice
implements Cloneable,
AbstractGraphicsDevice {
    private static final String separator = "_";
    private String type;
    protected String connection;
    protected int unitID;
    protected String uniqueID;
    protected long handle;
    protected ToolkitLock toolkitLock;

    public DefaultGraphicsDevice(String string, String string2, int n) {
        this.type = string;
        this.connection = string2;
        this.unitID = n;
        this.uniqueID = DefaultGraphicsDevice.getUniqueID(string, string2, n);
        this.handle = 0L;
        this.setToolkitLock(NativeWindowFactory.getDefaultToolkitLock(string));
    }

    public DefaultGraphicsDevice(String string, String string2, int n, long l) {
        this.type = string;
        this.connection = string2;
        this.unitID = n;
        this.uniqueID = DefaultGraphicsDevice.getUniqueID(string, string2, n);
        this.handle = l;
        this.setToolkitLock(NativeWindowFactory.createDefaultToolkitLock(string, l));
    }

    public DefaultGraphicsDevice(String string, String string2, int n, long l, ToolkitLock toolkitLock) {
        this.type = string;
        this.connection = string2;
        this.unitID = n;
        this.uniqueID = DefaultGraphicsDevice.getUniqueID(string, string2, n);
        this.handle = l;
        this.setToolkitLock(toolkitLock);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new NativeWindowException(cloneNotSupportedException);
        }
    }

    public final String getType() {
        return this.type;
    }

    public final String getConnection() {
        return this.connection;
    }

    public final int getUnitID() {
        return this.unitID;
    }

    public final String getUniqueID() {
        return this.uniqueID;
    }

    public final long getHandle() {
        return this.handle;
    }

    public final void lock() {
        this.toolkitLock.lock();
    }

    public final void unlock() {
        this.toolkitLock.unlock();
    }

    public boolean close() {
        return false;
    }

    public String toString() {
        return this.getClass().toString() + "[type " + this.getType() + ", connection " + this.getConnection() + ", unitID " + this.getUnitID() + ", handle 0x" + Long.toHexString(this.getHandle()) + "]";
    }

    protected void setToolkitLock(ToolkitLock toolkitLock) {
        this.toolkitLock = null == toolkitLock ? NativeWindowFactoryImpl.getNullToolkitLock() : toolkitLock;
    }

    public final ToolkitLock getToolkitLock() {
        return this.toolkitLock;
    }

    protected static String getUniqueID(String string, String string2, int n) {
        return (string + separator + string2 + separator + n).intern();
    }
}

