/*
 * Copyright (c) 2010 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.effects;

public class TexCoords {

	public static float[] neighboringOffset8(int width, int height) {
		float dx = 1f/width;
		float dy = 1f/height;
		return new float[] {
				-dx, -dy,  0, -dy,  dx, -dy,
				-dx,   0,           dx,   0,
				-dx,  dy,  0,  dy,  dx,  dy
		};
	}

	public static float[] neighboringOffset24(int width, int height) {
		float dx1 = 1f/width;
		float dy1 = 1f/height;
		float dx2 = 2f/width;
		float dy2 = 2f/height;
		return new float[] {
				-dx2, -dy2, -dx1, -dy2,    0, -dy2,  dx1, -dy2,  dx2, -dy2,
				-dx2, -dy1, -dx1, -dy1,    0, -dy1,  dx1, -dy1,  dx2, -dy1,
				-dx2,    0, -dx1,    0,              dx1,    0,  dx2,    0,
				-dx2,  dy1, -dx1,  dy1,    0,  dy1,  dx1,  dy1,  dx2,  dy1,
				-dx2,  dy2, -dx1,  dy2,    0,  dy2,  dx1,  dy2,  dx2,  dy2
		};
	}

}
