/*
 * Copyright (c) 2009,2010 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.app.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import ch.kuramo.javie.app.CommandIds;
import ch.kuramo.javie.app.views.LayerCompositionView;
import ch.kuramo.javie.core.output.JavaSoundWaveOutput;

import com.google.inject.Injector;

public class WaveOutputAction extends AbstractOutputAction<JavaSoundWaveOutput> {

	public WaveOutputAction(LayerCompositionView view) {
		super("Wave...", view);
		setId(CommandIds.WAVE_OUTPUT);
		setActionDefinitionId(CommandIds.WAVE_OUTPUT);
		//setImageDescriptor(Activator.getImageDescriptor("/icons/wave_output.png"));
	}

	@Override
	protected JavaSoundWaveOutput createOutput(Injector injector) {
		return injector.getInstance(JavaSoundWaveOutput.class);
	}

	@Override
	protected String getDefaultExtension() {
		return ".wav";
	}

	@Override
	protected String[] getSaveDialogFilters() {
		List<String> filters = new ArrayList<String>(Arrays.asList("Wave ファイル", "*.wav"));
		filters.addAll(Arrays.asList(super.getSaveDialogFilters()));
		return filters.toArray(new String[filters.size()]);
	}

}
