/*
 * Copyright (c) 2009 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.core;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import ch.kuramo.javie.api.Time;

public class FrameDuration {

	public static final Time FPS_23_976	= new Time(1001, 24000);

	public static final Time FPS_24		= new Time(1000, 24000);

	public static final Time FPS_25		= new Time(1000, 25000);

	public static final Time FPS_29_97	= new Time(1001, 30000);

	public static final Time FPS_30		= new Time(1000, 30000);

	public static final Time FPS_50		= new Time(1000, 50000);

	public static final Time FPS_59_94	= new Time(1001, 60000);

	public static final Time FPS_60		= new Time(1000, 60000);


	private static final Time[] values;

	static {
		try {
			List<Time> list = new ArrayList<Time>();
			for (Field f : FrameDuration.class.getFields()) {
				if (f.getType().equals(Time.class)) {
						list.add((Time) f.get(null));
				}
			}
			Collections.sort(list);
			Collections.reverse(list);
			values = list.toArray(new Time[list.size()]);
		} catch (Exception e) {
			throw new Error(e);
		}
	}


	public static Time[] values() {
		return values.clone();
	}


	private FrameDuration() { }

}
