/*
 * Copyright (c) 2010 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.app.actions;

import java.util.List;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.IWorkbenchWindow;

import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.project.ResetPropertiesOperation;
import ch.kuramo.javie.app.views.LayerCompositionView;
import ch.kuramo.javie.app.views.layercomp.AnimatableValueElement;
import ch.kuramo.javie.app.views.layercomp.EffectAnimatableValueElement;
import ch.kuramo.javie.app.views.layercomp.LayerAnimatableValueElement;
import ch.kuramo.javie.app.views.layercomp.LayerPropertyElement;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.Util;

public class ResetPropertiesAction extends Action {

	private final IWorkbenchWindow window;

	private final TreeViewer viewer;


	public ResetPropertiesAction(IWorkbenchWindow window, TreeViewer viewer) {
		super("リセット");
		this.window = window;
		this.viewer = viewer;

		//setId(CommandIds.RESET_ANIMATABLE_VALUES);
		//setActionDefinitionId(CommandIds.RESET_ANIMATABLE_VALUES);
		//setImageDescriptor(Activator.getImageDescriptor("/icons/reset_avalues.png"));

		setEnabled(false);

		viewer.addSelectionChangedListener(new ISelectionChangedListener() {
			public void selectionChanged(SelectionChangedEvent event) {
				boolean enabled = false;

				TreeSelection selection = (TreeSelection) event.getSelection();
				if (!selection.isEmpty()) {
					enabled = true;
					for (Object element : selection.toList()) {
						if (!(element instanceof AnimatableValueElement)
								&& !(element instanceof LayerPropertyElement<?>)) {
							enabled = false;
							break;
						}
					}
				}

				setEnabled(enabled);
			}
		});
	}

	public void run() {
		List<Object[]> list = Util.newList();

		TreeSelection selection = (TreeSelection) viewer.getSelection();
		for (Object element : selection.toList()) {
			if (element instanceof LayerAnimatableValueElement) {
				LayerAnimatableValueElement layerAVElem = (LayerAnimatableValueElement) element;
				list.add(new Object[] { layerAVElem.getLayer(), -1, layerAVElem.getProperty() });
			} else if (element instanceof EffectAnimatableValueElement) {
				EffectAnimatableValueElement effectAVElem = (EffectAnimatableValueElement) element;
				list.add(new Object[] { effectAVElem.getLayer(), effectAVElem.getEffectIndex(), effectAVElem.getProperty() });
			} else if (element instanceof LayerPropertyElement<?>) {
				LayerPropertyElement<?> layerPropElem = (LayerPropertyElement<?>) element;
				list.add(new Object[] { layerPropElem.getLayer(), -1, layerPropElem.getProperty() });
			} else {
				// SelectionChangedListenerでチェック済みなので、ここに来ることはないはず。
				return;
			}
		}

		if (list.isEmpty()) {
			return;
		}

		ProjectManager pm = ProjectManager.forWorkbenchWindow(window);
		LayerComposition comp = (LayerComposition) viewer.getData(LayerCompositionView.LAYER_COMPOSITION);

		pm.postOperation(new ResetPropertiesOperation(pm, comp, list.toArray(new Object[list.size()][])));
	}

}
