/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.os;

import com.jogamp.common.os.DynamicLinker;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class WindowsDynamicLinkerImpl
implements DynamicLinker {
    private static boolean DEBUG;

    private static native int FreeLibrary(long var0);

    private static native int GetLastError();

    private static native long GetProcAddressA(long var0, String var2);

    private static native long LoadLibraryW(String var0);

    public long openLibraryLocal(String libraryName, boolean debug) {
        return this.openLibraryGlobal(libraryName, debug);
    }

    public long openLibraryGlobal(String libraryName, boolean debug) {
        long handle = WindowsDynamicLinkerImpl.LoadLibraryW(libraryName);
        if (0L == handle && debug) {
            int err = WindowsDynamicLinkerImpl.GetLastError();
            System.err.println("LoadLibraryW \"" + libraryName + "\" failed, error code: 0x" + Integer.toHexString(err) + ", " + err);
        }
        return handle;
    }

    public long lookupSymbol(long libraryHandle, String symbolName) {
        String _symbolName = symbolName;
        long addr = WindowsDynamicLinkerImpl.GetProcAddressA(libraryHandle, _symbolName);
        if (0L == addr) {
            int argAlignment = 4;
            int maxArguments = 12;
            for (int arg = 0; 0L == addr && arg <= 12; ++arg) {
                _symbolName = symbolName + "@" + arg * 4;
                addr = WindowsDynamicLinkerImpl.GetProcAddressA(libraryHandle, _symbolName);
            }
        }
        if (DEBUG) {
            System.err.println("WindowsDynamicLinkerImpl.lookupSymbol(0x" + Long.toHexString(libraryHandle) + ", " + symbolName + ") -> " + _symbolName + ", 0x" + Long.toHexString(addr));
        }
        return addr;
    }

    public long lookupSymbolGlobal(String symbolName) {
        throw new RuntimeException("lookupSymbolGlobal: Not supported on Windows");
    }

    public void closeLibrary(long libraryHandle) {
        WindowsDynamicLinkerImpl.FreeLibrary(libraryHandle);
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                DEBUG = System.getProperty("jogamp.debug.NativeLibrary") != null;
                return null;
            }
        });
    }
}

