/*
 * Original Author: Stefan Gustavson (stegu@itn.liu.se) 2004, 2005
 * Port to Javie: Yoshikazu Kuramochi 2010
 * 
 * Original source code is available at http://staffwww.itn.liu.se/~stegu/simplexnoise/
 */

package ch.kuramo.javie.effects.noiseGrain;

import java.nio.ByteBuffer;

import javax.media.opengl.GL2;

class FractalNoiseTexture {

	private static final int[] perm = {151,160,137,91,90,15,
		  131,13,201,95,96,53,194,233,7,225,140,36,103,30,69,142,8,99,37,240,21,10,23,
		  190, 6,148,247,120,234,75,0,26,197,62,94,252,219,203,117,35,11,32,57,177,33,
		  88,237,149,56,87,174,20,125,136,171,168, 68,175,74,165,71,134,139,48,27,166,
		  77,146,158,231,83,111,229,122,60,211,133,230,220,105,92,41,55,46,245,40,244,
		  102,143,54, 65,25,63,161, 1,216,80,73,209,76,132,187,208, 89,18,169,200,196,
		  135,130,116,188,159,86,164,100,109,198,173,186, 3,64,52,217,226,250,124,123,
		  5,202,38,147,118,126,255,82,85,212,207,206,59,227,47,16,58,17,182,189,28,42,
		  223,183,170,213,119,248,152, 2,44,154,163, 70,221,153,101,155,167, 43,172,9,
		  129,22,39,253, 19,98,108,110,79,113,224,232,178,185, 112,104,218,246,97,228,
		  251,34,242,193,238,210,144,12,191,179,162,241, 81,51,145,235,249,14,239,107,
		  49,192,214, 31,181,199,106,157,184, 84,204,176,115,121,50,45,127, 4,150,254,
		  138,236,205,93,222,114,67,29,24,72,243,141,128,195,78,66,215,61,156,180};

	private static final int[][] grad3 = {{0,1,1},{0,1,-1},{0,-1,1},{0,-1,-1},
										  {1,0,1},{1,0,-1},{-1,0,1},{-1,0,-1},
										  {1,1,0},{1,-1,0},{-1,1,0},{-1,-1,0},	// 12 cube edges
										  {1,0,-1},{-1,0,-1},{0,-1,1},{0,1,1}};	// 4 more to make 16

	private static volatile int permTexture;

	static int getPermTexture(GL2 gl) {
		if (permTexture == 0) {
			byte[] bytes = new byte[256 * 256 * 4];
			for (int i = 0; i < 256; ++i) {
				for (int j = 0; j < 256; ++j) {
					int offset = (i*256+j)*4;
					int value = perm[(j+perm[i]) & 0xFF];
					bytes[offset] = (byte)(grad3[value & 0x0F][0] * 64 + 64);		// Gradient x
					bytes[offset+1] = (byte)(grad3[value & 0x0F][1] * 64 + 64);		// Gradient y
					bytes[offset+2] = (byte)(grad3[value & 0x0F][2] * 64 + 64);		// Gradient z
					bytes[offset+3] = (byte)value;									// Permuted index
				}
			}

			int[] texture = new int[1];
			int[] current = new int[1];
			gl.glGetIntegerv(GL2.GL_TEXTURE_2D, current, 0);
			try {
				gl.glGenTextures(1, texture, 0);
				gl.glBindTexture(GL2.GL_TEXTURE_2D, texture[0]);

				gl.glTexImage2D(GL2.GL_TEXTURE_2D, 0, GL2.GL_RGBA, 256, 256, 0, GL2.GL_RGBA,
						GL2.GL_UNSIGNED_BYTE, ByteBuffer.wrap(bytes));
				gl.glTexParameteri(GL2.GL_TEXTURE_2D, GL2.GL_TEXTURE_MIN_FILTER, GL2.GL_NEAREST);
				gl.glTexParameteri(GL2.GL_TEXTURE_2D, GL2.GL_TEXTURE_MAG_FILTER, GL2.GL_NEAREST);

				synchronized (FractalNoiseTexture.class) {
					if (permTexture == 0) {
						permTexture = texture[0];
						texture[0] = 0;
					}
				}
			} finally {
				gl.glBindTexture(GL2.GL_TEXTURE_2D, current[0]);
				if (texture[0] != 0) gl.glDeleteTextures(1, texture, 0);
			}
		}
		return permTexture;
	}

}
