/*
 * Copyright (c) 2010 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.core.shaders;

import ch.kuramo.javie.api.annotations.ShaderSource;

public class TrackMatteShaders {

	private static final String[] createProgramSource(String name) {
		return new String[] {
								"uniform sampler2DRect texFill;",
								"uniform sampler2DRect texMatte;",
								"uniform float matteOpacity;",
								"",
				String.format(	"vec4 blend_%s(vec4 pDst, vec4 pSrc, float opacity);", name),
								"",
								"void main(void)",
								"{",
								"	vec2 texCoord = gl_TexCoord[0].st;",
								"	vec4 fill = texture2DRect(texFill, texCoord);",
								"	vec4 matte = texture2DRect(texMatte, texCoord);",
				String.format(	"	gl_FragColor = blend_%s(fill, matte, matteOpacity);", name),
								"}"
		};
	}

	private static final String BLEND_FUNCTIONS = "ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions";

	@ShaderSource(attach=BLEND_FUNCTIONS)
	public static final String[] ALPHA = createProgramSource("stencil_alpha");

	@ShaderSource(attach=BLEND_FUNCTIONS)
	public static final String[] ALPHA_INVERTED = createProgramSource("silhouette_alpha");

	@ShaderSource(attach=BLEND_FUNCTIONS)
	public static final String[] LUMA = createProgramSource("stencil_luma");

	@ShaderSource(attach=BLEND_FUNCTIONS)
	public static final String[] LUMA_INVERTED = createProgramSource("silhouette_luma");

}
