/*
 * Copyright (c) 2009,2010 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.core.services;

import java.util.Collection;
import java.util.List;

import ch.kuramo.javie.api.BlendMode;
import ch.kuramo.javie.api.Color;
import ch.kuramo.javie.api.ColorMode;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.Size2i;
import ch.kuramo.javie.api.Vec3d;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.core.DepthBuffer;
import ch.kuramo.javie.core.TrackMatte;
import ch.kuramo.javie.core.VideoLayerBuffer;
import ch.kuramo.javie.core.WrappedOperation;
import ftgl.FTGLfont;

public interface VideoRenderSupport {

	IVideoBuffer createVideoBuffer(ColorMode colorMode, Size2i size);

	IVideoBuffer createVideoBuffer(ColorMode colorMode, VideoBounds bounds);

	DepthBuffer createDepthBuffer(Size2i size);


	int createDepthTexture(Size2i textureSize);

	void deleteTexture(int texture);


	void fillRectCR(IVideoBuffer resultBuffer, double[] mvMatrix, double[] prjMatrix, Size2i size, Color color);

	void trackMatte(
			IVideoBuffer matteBuffer, IVideoBuffer fillBuffer, IVideoBuffer resultBuffer,
			TrackMatte trackMatte, double matteOpacity);

	void blend(
			IVideoBuffer srcBuffer, IVideoBuffer dstBuffer, IVideoBuffer resultBuffer,
			BlendMode blendMode, double opacity, int dissolveSeed);

	void blend(Collection<VideoLayerBuffer> srcBuffers, IVideoBuffer dstBuffer, IVideoBuffer resultBuffer);

	void premultiply(IVideoBuffer vb);

	void premultiply(IVideoBuffer vb, Color colorMatte, boolean discardAlpha);

	void alphaToGrayscale(IVideoBuffer vb);

	void copy(IVideoBuffer src, IVideoBuffer dst);


	<T> T pushMatrixAndExecute(WrappedOperation<T> operation);

	void multModelViewMatrix(
			Vec3d anchorPoint, Vec3d scale, Vec3d orientation, Vec3d rotate, Vec3d position);

	void multModelViewMatrixInverse(
			Vec3d anchorPoint, Vec3d scale, Vec3d orientation, Vec3d rotate, Vec3d position);

	void multCameraMatrix(
			Vec3d orientation, Vec3d rotate, Vec3d position, Vec3d pointOfInterest, boolean flipZ);

	void multCameraMatrixInverse(
			Vec3d orientation, Vec3d rotate, Vec3d position, Vec3d pointOfInterest);

	void multModelViewMatrix(double[] mvMatrix);

	void getMatrix(double[] mvMatrix, double[] prjMatrix);

	void setMatrix(double[] mvMatrix, double[] prjMatrix);

	void resetMatrix();

	Vec3d project(Vec3d point, double[] mvMatrix, double[] prjMatrix, Size2i viewportSize);

	void transform(
			IVideoBuffer srcBuffer, IVideoBuffer resultBuffer, DepthBuffer depthBuffer,
			double[] mvMatrix, double[] prjMatrix);

	void accumulate(List<IVideoBuffer> srcBuffers, List<Double> weights, IVideoBuffer dstBuffer);

	void accumulate(List<IVideoBuffer> srcBuffers, double weight, IVideoBuffer dstBuffer);

	void fillDepth(DepthBuffer depthBuffer, double[] mvMatrix, double[] prjMatrix);


	void renderText(FTGLfont font, Color fillColor, String[] texts, double[][] offsets, IVideoBuffer resultBuffer);

	void renderText(
			FTGLfont font, Color fillColor, String[] texts, double[][] offsets,
			IVideoBuffer resultBuffer, double[] mvMatrix, double[] prjMatrix);

}
