/*
 * Copyright (c) 2009,2010 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.core.internal.services;

import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;

import ch.kuramo.javie.api.AudioMode;
import ch.kuramo.javie.api.ColorMode;
import ch.kuramo.javie.api.Resolution;
import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.core.Camera;
import ch.kuramo.javie.core.services.RenderContext;

public class RenderContextProxy
		extends AbstractCoreContextProxy<RenderContextImpl>
		implements RenderContext {

	private static final ThreadLocal<RenderContextImpl>
			_threadLocal = new ThreadLocal<RenderContextImpl>();

	@Override
	protected ThreadLocal<RenderContextImpl> getThreadLocal() {
		return _threadLocal;
	}

	public GL getGL() {
		return getImpl().getGL();
	}

	public GLU getGLU() {
		return getImpl().getGLU();
	}

	public Resolution getVideoResolution() {
		return getImpl().getVideoResolution();
	}

	public void setVideoResolution(Resolution resolution) {
		getImpl().setVideoResolution(resolution);
	}

	public ColorMode getColorMode() {
		return getImpl().getColorMode();
	}

	public void setColorMode(ColorMode colorMode) {
		getImpl().setColorMode(colorMode);
	}

	public Time getVideoFrameDuration() {
		return getImpl().getVideoFrameDuration();
	}

	public void setVideoFrameDuration(Time frameDuration) {
		getImpl().setVideoFrameDuration(frameDuration);
	}

	public Camera getCamera() {
		return getImpl().getCamera();
	}

	public void setCamera(Camera camera) {
		getImpl().setCamera(camera);
	}

	public AudioMode getAudioMode() {
		return getImpl().getAudioMode();
	}

	public void setAudioMode(AudioMode audioMode) {
		getImpl().setAudioMode(audioMode);
	}

	public int getAudioAnimationRate() {
		return getImpl().getAudioAnimationRate();
	}

	public void setAudioAnimationRate(int rate) {
		getImpl().setAudioAnimationRate(rate);
	}

	public int getAudioFrameCount() {
		return getImpl().getAudioFrameCount();
	}

	public void setAudioFrameCount(int count) {
		getImpl().setAudioFrameCount(count);
	}

}
