/*
 * Copyright (c) 2009,2010 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.core.internal.services;

import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;

import ch.kuramo.javie.api.AudioMode;
import ch.kuramo.javie.api.ColorMode;
import ch.kuramo.javie.api.IAnimatableLayerReference;
import ch.kuramo.javie.api.IAnimatableValue;
import ch.kuramo.javie.api.IAudioBuffer;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.Resolution;
import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.services.IEffectContext;

public abstract class AbstractEffectContextProxy<I extends IEffectContext> implements IEffectContext {

	protected abstract I getImpl();


	public Time getTime() {
		return getImpl().getTime();
	}

	public void setTime(Time time) {
		getImpl().setTime(time);
	}

	public Resolution getVideoResolution() {
		return getImpl().getVideoResolution();
	}

	public ColorMode getColorMode() {
		return getImpl().getColorMode();
	}

	public AudioMode getAudioMode() {
		return getImpl().getAudioMode();
	}

	public int getAudioFrameCount() {
		return getImpl().getAudioFrameCount();
	}

	public void setAudioFrameCount(int count) {
		getImpl().setAudioFrameCount(count);
	}

	public GL getGL() {
		return getImpl().getGL();
	}

	public GLU getGLU() {
		return getImpl().getGLU();
	}

	public IVideoBuffer createVideoBuffer(VideoBounds bounds) {
		return getImpl().createVideoBuffer(bounds);
	}

	public IAudioBuffer createAudioBuffer() {
		return getImpl().createAudioBuffer();
	}

	public <V> V value(IAnimatableValue<V> avalue) {
		return getImpl().value(avalue);
	}

	public IVideoBuffer getLayerVideoFrame(IAnimatableLayerReference layerRef) {
		return getImpl().getLayerVideoFrame(layerRef);
	}

	public IAudioBuffer getLayerAudioChunk(IAnimatableLayerReference layerRef) {
		return getImpl().getLayerAudioChunk(layerRef);
	}

	public String getEffectName() {
		return getImpl().getEffectName();
	}

}
