/*
 * Copyright (c) 2009 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.UUID;
import java.util.WeakHashMap;

public class Util {

	public static String randomId() {
		return UUID.randomUUID().toString();
	}

	public static <E> List<E> newList() {
		return newArrayList();
	}

	public static <E> List<E> newList(Collection<? extends E> c) {
		return newArrayList(c);
	}

	public static <E> ArrayList<E> newArrayList() {
		return new ArrayList<E>();
	}

	public static <E> ArrayList<E> newArrayList(Collection<? extends E> c) {
		return new ArrayList<E>(c);
	}

	public static <E> LinkedList<E> newLinkedList() {
		return new LinkedList<E>();
	}

	public static <E> Set<E> newSet() {
		return newHashSet();
	}

	public static <E> Set<E> newSet(Collection<? extends E> c) {
		return newHashSet(c);
	}

	public static <E> HashSet<E> newHashSet() {
		return new HashSet<E>();
	}

	public static <E> HashSet<E> newHashSet(Collection<? extends E> c) {
		return new HashSet<E>(c);
	}

	public static <E> LinkedHashSet<E> newLinkedHashSet() {
		return new LinkedHashSet<E>();
	}

	public static <E> LinkedHashSet<E> newLinkedHashSet(Collection<? extends E> c) {
		return new LinkedHashSet<E>(c);
	}

	public static <K, V> Map<K, V> newMap() {
		return newHashMap();
	}

	public static <K, V> HashMap<K, V> newHashMap() {
		return new HashMap<K, V>();
	}

	public static <K, V> LinkedHashMap<K, V> newLinkedHashMap() {
		return new LinkedHashMap<K, V>();
	}

	public static <K, V> SortedMap<K, V> newSortedMap() {
		return newTreeMap();
	}

	public static <K, V> TreeMap<K, V> newTreeMap() {
		return new TreeMap<K, V>();
	}

	public static <K, V> WeakHashMap<K, V> newWeakHashMap() {
		return new WeakHashMap<K, V>();
	}

	public static <E> Set<E> unmodifiableSet(E ... elements) {
		List<E> list = Arrays.asList(elements);
		Set<E> set = new LinkedHashSet<E>(list);	// 元の配列の順序を維持する。
		return Collections.unmodifiableSet(set);
	}

	public static <E> void addAll(Collection<? extends E> src, Collection<E> dst) {
		if (src != null) {
			dst.addAll(src);
		}
	}


	private Util() { }

}
