/*
 * Copyright (c) 2009 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.app.views.layercomp;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Event;

import ch.kuramo.javie.app.views.LayerCompositionView;

public class Element {

	public static final Element[] EMPTY_CHILDREN = new Element[0];


	public final TreeViewer viewer;

	public final Element parent;


	private Element(TreeViewer viewer, Element parent) {
		this.viewer = viewer;
		this.parent = parent;
	}

	public Element(TreeViewer viewer) {
		this(viewer, null);
	}

	public Element(Element parent) {
		this(parent.viewer, parent);
	}

	public Image getColumnImage(int columnIndex) {
		return null;
	}

	public String getColumnText(int columnIndex) {
		return null;
	}

	public boolean hasChildren() {
		return false;
	}

	public Element[] getChildren() {
		return EMPTY_CHILDREN;
	}

	public void paintColumn(Event event) {
		if (event.index == LayerCompositionView.TIMELINE_COL) {
			TimelineManager tm = (TimelineManager) viewer.getData(LayerCompositionView.TIMELINE_MANAGER);
			tm.drawCurrentFrameRegion(event);
		}
	}

	public void updateCursor(MouseEvent event, int columnIndex) {
		viewer.getTree().setCursor(null);
	}

	public void mouseDown(MouseEvent event, int columnIndex) {
		if (columnIndex == LayerCompositionView.TIMELINE_COL) {
			TimelineManager tm = (TimelineManager) viewer.getData(LayerCompositionView.TIMELINE_MANAGER);
			tm.mouseDown(event);
		}
	}

	public boolean canEdit(int columnIndex) {
		return false;
	}

	public CellEditor getCellEditor(int columnIndex) {
		return null;
	}

	public Object getCellEditorValue(int columnIndex) {
		return null;
	}

	public void setCellEditorValue(int columnIndex, Object value) {
	}

}
