/*
 * Copyright (c) 2009 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.app.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

import ch.kuramo.javie.app.views.LayerCompositionView;
import ch.kuramo.javie.app.views.layercomp.TimelineManager;

public class RemoveKeyframesAction extends Action {

	private final TreeViewer viewer;

	public RemoveKeyframesAction(TreeViewer treeViewer) {
		super("キーフレームの消去");
		this.viewer = treeViewer;

		//setId(CommandIds.REMOVE_KEYFRAMES);
		//setActionDefinitionId(CommandIds.REMOVE_KEYFRAMES);
		//setImageDescriptor(Activator.getImageDescriptor("/icons/remove_keyframes.png"));

		setEnabled(false);

		Tree tree = treeViewer.getTree();
		final TreeColumn[] columns = tree.getColumns();

		tree.addMouseListener(new MouseAdapter() {
			public void mouseDown(MouseEvent e) {
				int left = 0;
				for (int i = 0; i < columns.length-1; ++i) {
					left += columns[i].getWidth();
				}
				if (left <= e.x && e.x < left + columns[columns.length-1].getWidth()) {
					TimelineManager tm = (TimelineManager) viewer.getData(LayerCompositionView.TIMELINE_MANAGER);
					setEnabled(tm.hasKeyframeSelection());
				} else {
					setEnabled(false);
				}
			}
		});
	}

	public void run() {
		TimelineManager tm = (TimelineManager) viewer.getData(LayerCompositionView.TIMELINE_MANAGER);
		tm.removeSelectedKeyframes();
	}

}
