/*
 * Copyright (c) 2009,2010 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.api.plugin;

/**
 * <p>Javie プラグイン向けの Eclipse 拡張ポイントに使用する基底クラスです。
 * Javie のプラグインは、このクラスを基底クラスとしたクラスを作成し、
 * 拡張ポイント <code>ch.kuramo.javie.api.plugin</code> に指定する必要があります。</p>
 * 
 * <p>
 * クラスの例：
 * <blockquote><pre>
 *  package com.example.javie;
 *  public class MyPlugin extends JaviePlugin {
 *  
 *  	<b>// 今のところ、このクラスの中身は何も必要ありません</b>
 *  
 *  }
 * </pre></blockquote>
 * </p>
 * <p>
 * 拡張ポイントの指定:
 * <blockquote><pre>
 *  &lt;extension name="<b>My Plugin</b>" point="ch.kuramo.javie.api.plugin"&gt;
 *  	&lt;javie-plugin class="<b>com.example.javie.MyPlugin</b>"&gt;
 *  	&lt;/javie-plugin&gt;
 *  &lt;/extension&gt;
 * </pre></blockquote>
 * </p>
 */
public abstract class JaviePlugin {

}
