/*
 * Copyright (c) 2010 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.api;

/**
 * <code>ICamera</code> はカメラに関する情報にアクセスするためのインターフェースです。
 * ビューポートサイズ、モデルビュー行列、投影行列を取得することができます。
 */
public interface ICamera {

	/**
	 * カメラのビューポートサイズを返します。
	 * 
	 * @return カメラのビューポートサイズ
	 */
	Size2i getViewportSize();

	/**
	 * カメラのモデルビュー行列を取得します。
	 * 引数 <code>matrix</code> は長さが16以上である必要があります。
	 * 
	 * @param matrix カメラのモデルビュー行列を受け取る配列。
	 */
	void getModelViewMatrix(double[] matrix);

	/**
	 * カメラの投影行列を取得します。
	 * 引数 <code>matrix</code> は長さが16以上である必要があります。
	 * 
	 * @param matrix カメラの投影行列を受け取る配列。
	 */
	void getProjectionMatrix(double[] matrix);

}
