/*
 * Copyright (c) 2009,2010 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#import <Cocoa/Cocoa.h>
#import <QTKit/QTKit.h>


@interface InputBase : NSObject {
	
	Movie mMovie;
	
	OSType mMediaType;
	long mSampleCount;
	TimeValue64 mDuration;
	TimeScale mTimeScale;
	
}

-(long) sampleCount;
-(TimeValue64) duration;
-(TimeScale) timeScale;

@end


@interface VideoInput : InputBase {
	
	long mWidth;
	long mHeight;
	long mTargetWidth;
	long mTargetHeight;
	
	QTVisualContextRef mVisualContext;
	CVImageBufferRef mCurrentFrame;
	
}

-(id) initWithFile:(NSString*)filename
				  :(CGLContextObj)cglContext
				  :(CGLPixelFormatObj)cglPixelFormat;

-(long) width;
-(long) height;

-(OSStatus) frameImageAtTime:(QTTime)time
							:(GLint)texture
							:(GLint)width
							:(GLint)height
							:(int)alphaType
							:(float)colorMatteR
							:(float)colorMatteG
							:(float)colorMatteB
							:(BOOL)flipVertical;

@end


@interface AudioInput : InputBase {
	
	AudioStreamBasicDescription mASBD;
	MovieAudioExtractionRef mAudioExtraction;
	
}

-(id) initWithFile:(NSString*)filename;

-(OSStatus) setAudioDescription:(NSDictionary*)description;

-(OSStatus) audioChunkFromTime:(QTTime)time
							  :(void*)buffer
							  :(long)offset
							  :(long)frameCount;

@end
