/*
 * Copyright (c) 2009,2010 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.core.internal;

import ch.kuramo.javie.api.BlendMode;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.core.DepthBuffer;
import ch.kuramo.javie.core.VideoLayerBuffer;

class VideoLayerBufferImpl implements VideoLayerBuffer {

	private IVideoBuffer _videoBuffer;

	private DepthBuffer _depthBuffer;

	private final BlendMode _blendMode;

	private final double _opacity;

	private final int _dissolveSeed;


	VideoLayerBufferImpl(
			IVideoBuffer videoBuffer, DepthBuffer depthBuffer,
			BlendMode blendMode, double opacity, int dissolveSeed) {

		_videoBuffer = videoBuffer;
		_depthBuffer = depthBuffer;
		_blendMode = blendMode;
		_opacity = opacity;
		_dissolveSeed = dissolveSeed;
	}

	public void dispose() {
		if (_videoBuffer != null) {
			_videoBuffer.dispose();
			_videoBuffer = null;
		}
		if (_depthBuffer != null) {
			_depthBuffer.dispose();
			_depthBuffer = null;
		}
	}

	public IVideoBuffer getVideoBuffer() {
		return _videoBuffer;
	}

	public DepthBuffer getDepthBuffer() {
		return _depthBuffer;
	}

	public BlendMode getBlendMode() {
		return _blendMode;
	}

	public double getOpacity() {
		return _opacity;
	}

	public int getDissolveSeed() {
		return _dissolveSeed;
	}

}
